/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry.algs;

import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Polygon2D_F32;
import java.util.Comparator;
import org.ddogleg.sorting.QuickSortComparator;
import org.ddogleg.struct.FastQueue;

public class AndrewMonotoneConvexHull_F32 {
    QuickSortComparator<Point2D_F32> sorter;
    FastQueue<Point2D_F32> work = new FastQueue<Point2D_F32>(Point2D_F32.class, false);

    public AndrewMonotoneConvexHull_F32() {
        this.sorter = new QuickSortComparator<Point2D_F32>(new Comparator<Point2D_F32>(){

            @Override
            public int compare(Point2D_F32 a, Point2D_F32 b) {
                if (a.x < b.x) {
                    return -1;
                }
                if (a.x > b.x) {
                    return 1;
                }
                if (a.y < b.y) {
                    return -1;
                }
                if (a.y > b.y) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void process(Point2D_F32[] input, int length, Polygon2D_F32 hull) {
        int i;
        if (length == 2) {
            hull.vertexes.resize(length);
            for (int i2 = 0; i2 < length; ++i2) {
                hull.get(i2).set(input[i2]);
            }
            return;
        }
        this.sorter.sort((Point2D_F32[])input, length);
        this.work.reset();
        for (int i3 = 0; i3 < length; ++i3) {
            Point2D_F32 p = input[i3];
            while (this.work.size() >= 2 && AndrewMonotoneConvexHull_F32.subtractThenCross(p, this.work.getTail(0), this.work.getTail(1)) >= 0.0f) {
                this.work.removeTail();
            }
            this.work.add(p);
        }
        this.work.removeTail();
        int minSize = this.work.size + 2;
        for (i = length - 1; i >= 0; --i) {
            Point2D_F32 p = input[i];
            while (this.work.size() >= minSize && AndrewMonotoneConvexHull_F32.subtractThenCross(p, this.work.getTail(0), this.work.getTail(1)) >= 0.0f) {
                this.work.removeTail();
            }
            this.work.add(p);
        }
        this.work.removeTail();
        hull.vertexes.resize(this.work.size);
        for (i = 0; i < this.work.size(); ++i) {
            ((Point2D_F32[])hull.vertexes.data)[i].set(this.work.get(i));
        }
    }

    private static float subtractThenCross(Point2D_F32 a, Point2D_F32 b, Point2D_F32 c) {
        float x0 = b.x - a.x;
        float y0 = b.y - a.y;
        float x1 = c.x - a.x;
        float y1 = c.y - a.y;
        return x0 * y1 - y0 * x1;
    }
}

