/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.EllipseQuadratic_F32;
import georegression.struct.shapes.EllipseRotated_F32;

public class UtilEllipse_F32 {
    public static EllipseRotated_F32 convert(EllipseQuadratic_F32 input, EllipseRotated_F32 output) {
        float dy;
        float dx;
        if (output == null) {
            output = new EllipseRotated_F32();
        }
        float a11 = input.a;
        float a12 = input.b;
        float a22 = input.c;
        float b1 = 2.0f * input.d;
        float b2 = 2.0f * input.e;
        float c = input.f;
        output.center.x = (a22 * b1 - a12 * b2) / (2.0f * (a12 * a12 - a11 * a22));
        output.center.y = (a11 * b2 - a12 * b1) / (2.0f * (a12 * a12 - a11 * a22));
        float k1 = output.center.x;
        float k2 = output.center.y;
        float mu = 1.0f / (a11 * k1 * k1 + 2.0f * a12 * k1 * k2 + a22 * k2 * k2 - c);
        float m11 = mu * a11;
        float m12 = mu * a12;
        float m22 = mu * a22;
        float inner = (float)Math.sqrt((m11 - m22) * (m11 - m22) + 4.0f * m12 * m12);
        float l1 = (m11 + m22 + inner) / 2.0f;
        float l2 = (m11 + m22 - inner) / 2.0f;
        output.b = 1.0f / (float)Math.sqrt(l1);
        output.a = 1.0f / (float)Math.sqrt(l2);
        if (m11 >= m22) {
            dx = l1 - m22;
            dy = m12;
        } else {
            dx = m12;
            dy = l1 - m11;
        }
        output.phi = (float)Math.atan2(-dx, dy);
        if (output.phi < -GrlConstants.F_PId2) {
            output.phi += (float)Math.PI;
        } else if (output.phi > GrlConstants.F_PId2) {
            output.phi -= (float)Math.PI;
        }
        return output;
    }

    public static EllipseQuadratic_F32 convert(EllipseRotated_F32 input, EllipseQuadratic_F32 output) {
        if (output == null) {
            output = new EllipseQuadratic_F32();
        }
        float x0 = input.center.x;
        float y0 = input.center.y;
        float a = input.a;
        float b = input.b;
        float phi = input.phi;
        float cphi = (float)Math.cos(phi);
        float sphi = (float)Math.sin(phi);
        float cphi2 = cphi * cphi;
        float sphi2 = sphi * sphi;
        float a2 = a * a;
        float b2 = b * b;
        float x02 = x0 * x0;
        float y02 = y0 * y0;
        output.a = cphi2 / a2 + sphi2 / b2;
        output.b = sphi * cphi / a2 - sphi * cphi / b2;
        output.c = sphi2 / a2 + cphi2 / b2;
        output.d = -x0 * cphi2 / a2 - y0 * sphi * cphi / a2 - x0 * sphi2 / b2 + y0 * sphi * cphi / b2;
        output.e = -x0 * sphi * cphi / a2 - y0 * sphi2 / a2 + x0 * sphi * cphi / b2 - y0 * cphi2 / b2;
        output.f = x02 * cphi2 / a2 + 2.0f * x0 * y0 * sphi * cphi / a2 + y02 * sphi2 / a2 + x02 * sphi2 / b2 - 2.0f * x0 * y0 * sphi * cphi / b2 + y02 * cphi2 / b2 - 1.0f;
        return output;
    }

    public static float evaluate(float x, float y, EllipseQuadratic_F32 ellipse) {
        return ellipse.a * x * x + 2.0f * ellipse.b * x * y + ellipse.c * y * y + 2.0f * ellipse.d * x + 2.0f * ellipse.e * y + ellipse.f;
    }

    public static float evaluate(float x, float y, EllipseRotated_F32 ellipse) {
        float cphi = (float)Math.cos(ellipse.phi);
        float sphi = (float)Math.sin(ellipse.phi);
        float left = (x -= ellipse.center.x) * cphi + (y -= ellipse.center.y) * sphi;
        float right = -x * sphi + y * cphi;
        return left * left / (ellipse.a * ellipse.a) + right * right / (ellipse.b * ellipse.b);
    }

    public static Point2D_F32 computePoint(float t, EllipseRotated_F32 ellipse, Point2D_F32 output) {
        if (output == null) {
            output = new Point2D_F32();
        }
        float ct = (float)Math.cos(t);
        float st = (float)Math.sin(t);
        float cphi = (float)Math.cos(ellipse.phi);
        float sphi = (float)Math.sin(ellipse.phi);
        output.x = ellipse.center.x + ellipse.a * ct * cphi - ellipse.b * st * sphi;
        output.y = ellipse.center.y + ellipse.a * ct * sphi + ellipse.b * st * cphi;
        return output;
    }

    public static float computeAngle(Point2D_F32 p, EllipseRotated_F32 ellipse) {
        float ce = (float)Math.cos(ellipse.phi);
        float se = (float)Math.sin(ellipse.phi);
        float xc = p.x - ellipse.center.x;
        float yc = p.y - ellipse.center.y;
        float x = ce * xc + se * yc;
        float y = -se * xc + ce * yc;
        return (float)Math.atan2(y / ellipse.b, x / ellipse.a);
    }
}

