/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.Executor;
import edu.jas.util.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class ExecutableServer
extends Thread {
    private static final Logger logger = Logger.getLogger(ExecutableServer.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final ChannelFactory cf;
    protected List<Executor> servers = null;
    public static final int DEFAULT_PORT = 7411;
    public static final String DONE = "Done";
    public static final String STOP = "Stop";
    private volatile boolean goon = true;
    private Thread mythread = null;

    public ExecutableServer() {
        this(7411);
    }

    public ExecutableServer(int port) {
        this(new ChannelFactory(port));
    }

    public ExecutableServer(ChannelFactory cf) {
        this.cf = cf;
        cf.init();
        this.servers = new ArrayList<Executor>();
    }

    public static void main(String[] args) throws InterruptedException {
        BasicConfigurator.configure();
        int port = 7411;
        if (args.length < 1) {
            System.out.println("Usage: ExecutableServer <port>");
        } else {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ExecutableServer es = new ExecutableServer(port);
        es.init();
        es.join();
    }

    public void init() {
        this.start();
        logger.info((Object)("ExecutableServer at " + this.cf));
    }

    public int size() {
        if (this.servers == null) {
            return -1;
        }
        return this.servers.size();
    }

    @Override
    public void run() {
        SocketChannel channel = null;
        Executor s = null;
        this.mythread = Thread.currentThread();
        while (this.goon) {
            if (this.debug) {
                logger.info((Object)("execute server " + this + " go on"));
            }
            try {
                channel = this.cf.getChannel();
                logger.debug((Object)("execute channel = " + channel));
                if (this.mythread.isInterrupted()) {
                    this.goon = false;
                    logger.debug((Object)("execute server " + this + " interrupted"));
                    channel.close();
                    continue;
                }
                s = new Executor(channel);
                if (this.goon) {
                    this.servers.add(s);
                    s.start();
                    logger.debug((Object)("server " + s + " started"));
                    continue;
                }
                s = null;
                channel.close();
            }
            catch (InterruptedException e) {
                this.goon = false;
                Thread.currentThread().interrupt();
                if (!this.debug) continue;
                e.printStackTrace();
            }
        }
        if (this.debug) {
            logger.info((Object)("execute server " + this + " terminated"));
        }
    }

    public void terminate() {
        this.goon = false;
        logger.debug((Object)"terminating ExecutableServer");
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.servers != null) {
            for (Executor x : this.servers) {
                if (x.channel != null) {
                    x.channel.close();
                }
                try {
                    while (x.isAlive()) {
                        x.interrupt();
                        x.join(100L);
                    }
                    logger.debug((Object)("server " + x + " terminated"));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.servers = null;
        }
        logger.debug((Object)"Executors terminated");
        if (this.mythread == null) {
            return;
        }
        try {
            while (this.mythread.isAlive()) {
                this.mythread.interrupt();
                this.mythread.join(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.mythread = null;
        logger.debug((Object)"ExecuteServer terminated");
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("ExecutableServer(");
        s.append(this.cf.toString());
        s.append(")");
        return s.toString();
    }
}

