/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class ChannelFactory
extends Thread {
    private static final Logger logger = Logger.getLogger(ChannelFactory.class);
    private final boolean debug;
    public static final int DEFAULT_PORT = 4711;
    private final int port;
    private final BlockingQueue<SocketChannel> buf;
    private volatile ServerSocket srv;
    private volatile boolean srvrun;
    private volatile boolean srvstart;

    public ChannelFactory() {
        this(4711);
    }

    public ChannelFactory(int p) {
        block4: {
            this.debug = logger.isDebugEnabled();
            this.srvrun = false;
            this.srvstart = false;
            this.buf = new LinkedBlockingQueue<SocketChannel>();
            this.port = p <= 0 ? 4711 : p;
            try {
                this.srv = new ServerSocket(this.port);
                logger.info((Object)("server bound to port " + this.port));
            }
            catch (BindException e) {
                this.srv = null;
                logger.warn((Object)("server not started, port used " + this.port));
                if (this.debug) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                logger.debug((Object)("IOException " + e));
                if (!logger.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.srv + ", buf = " + this.buf.size() + ")";
    }

    public void init() {
        if (this.srv != null && !this.srvstart) {
            this.start();
            this.srvstart = true;
            logger.info((Object)("ChannelFactory at " + this.srv));
        }
    }

    public SocketChannel getChannel() throws InterruptedException {
        if (this.srv == null) {
            if (this.srvrun) {
                throw new IllegalArgumentException("dont call when no server listens");
            }
        } else if (!this.srvstart) {
            this.init();
        }
        return this.buf.take();
    }

    public SocketChannel getChannel(String h) throws IOException {
        return this.getChannel(h, 4711);
    }

    public SocketChannel getChannel(String h, int p) throws IOException {
        if (p <= 0) {
            p = this.port;
        }
        SocketChannel c = null;
        int i = 0;
        int delay = 5;
        logger.debug((Object)("connecting to " + h));
        while (c == null) {
            try {
                c = new SocketChannel(new Socket(h, p));
            }
            catch (IOException e) {
                if (++i % 50 == 0) {
                    delay += delay;
                    logger.info((Object)("Server on " + h + ":" + p + " not ready in " + delay + "ms"));
                }
                try {
                    Thread.sleep(delay);
                    if (i % 50 != 0 || !this.debug) continue;
                    throw new Exception("time wait, host = " + h + ", port = " + this.port);
                }
                catch (InterruptedException w) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted during IO wait " + w);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        logger.debug((Object)("connected, iter = " + i));
        return c;
    }

    @Override
    public void run() {
        if (this.srv == null) {
            return;
        }
        this.srvrun = true;
        try {
            while (true) {
                logger.info((Object)("waiting for connection on " + this.srv));
                Socket s = this.srv.accept();
                if (this.isInterrupted()) {
                    this.srvrun = false;
                    return;
                }
                logger.debug((Object)"connection accepted");
                SocketChannel c = new SocketChannel(s);
                this.buf.put(c);
            }
        }
        catch (IOException e) {
            this.srvrun = false;
            return;
        }
        catch (InterruptedException e) {
            this.srvrun = false;
            return;
        }
    }

    public void terminate() {
        if (!this.srvstart) {
            logger.debug((Object)"server not started");
            return;
        }
        this.interrupt();
        try {
            if (this.srv != null) {
                this.srv.close();
                this.srvrun = false;
            }
            this.interrupt();
            while (!this.buf.isEmpty()) {
                logger.debug((Object)"closing unused SocketChannel");
                SocketChannel c = (SocketChannel)this.buf.poll();
                if (c == null) continue;
                c.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug((Object)"ChannelFactory terminated");
    }
}

