/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.Counter;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

class Broadcaster
extends Thread {
    private static final Logger logger = Logger.getLogger(Broadcaster.class);
    private final SocketChannel channel;
    private final List bcaster;
    private Counter listElem;
    private final SortedMap<Counter, Object> theList;

    public Broadcaster(SocketChannel s, List p, Counter le, SortedMap<Counter, Object> sm) {
        this.channel = s;
        this.bcaster = p;
        this.listElem = le;
        this.theList = sm;
    }

    public void closeChannel() {
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChannel(Object n, Object o) throws IOException {
        SocketChannel socketChannel = this.channel;
        synchronized (socketChannel) {
            this.channel.send(n);
            this.channel.send(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(Object o) {
        Counter li = null;
        Object object = this.listElem;
        synchronized (object) {
            this.listElem.add(1);
            li = new Counter(this.listElem.intValue());
        }
        object = this.theList;
        synchronized (object) {
            this.theList.put(li, o);
        }
        object = this.bcaster;
        synchronized (object) {
            for (Broadcaster br : this.bcaster) {
                try {
                    br.sendChannel(li, o);
                }
                catch (IOException e) {
                    try {
                        br.closeChannel();
                        while (br.isAlive()) {
                            br.interrupt();
                            br.join(100L);
                        }
                    }
                    catch (InterruptedException u) {
                        Thread.currentThread().interrupt();
                    }
                    this.bcaster.remove(br);
                }
            }
        }
    }

    @Override
    public void run() {
        boolean goon = true;
        while (goon) {
            try {
                Object o = this.channel.receive();
                this.broadcast(o);
                if (!this.isInterrupted()) continue;
                goon = false;
            }
            catch (IOException e) {
                goon = false;
            }
            catch (ClassNotFoundException e) {
                goon = false;
                e.printStackTrace();
            }
        }
        logger.debug((Object)("broadcaster terminated " + this));
        this.channel.close();
    }

    @Override
    public String toString() {
        return "Broadcaster(" + this.channel + "," + this.bcaster.size() + "," + this.listElem + ")";
    }
}

