/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufdroot;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.root.PolyUtilRoot;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorRealAlgebraic<C extends GcdRingElem<C> & Rational>
extends FactorAbstract<RealAlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(FactorRealAlgebraic.class);
    public final FactorAbstract<AlgebraicNumber<C>> factorAlgebraic;

    protected FactorRealAlgebraic() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorRealAlgebraic(RealAlgebraicRing<C> fac) {
        this(fac, FactorFactory.getImplementation(fac.algebraic));
    }

    public FactorRealAlgebraic(RealAlgebraicRing<C> fac, FactorAbstract<AlgebraicNumber<C>> factorAlgebraic) {
        super(fac);
        this.factorAlgebraic = factorAlgebraic;
    }

    @Override
    public List<GenPolynomial<RealAlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<RealAlgebraicNumber<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<RealAlgebraicNumber<C>>> factors = new ArrayList<GenPolynomial<RealAlgebraicNumber<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        RealAlgebraicRing rfac = (RealAlgebraicRing)pfac.coFac;
        RealAlgebraicNumber<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            P = P.monic();
            factors.add(((GenPolynomial)pfac.getONE()).multiply(ldcf));
        }
        GenPolynomialRing afac = new GenPolynomialRing(rfac.algebraic, pfac);
        GenPolynomial A = PolyUtilRoot.algebraicFromRealCoefficients(afac, P);
        List afactors = this.factorAlgebraic.baseFactorsSquarefree(A);
        for (GenPolynomial a : afactors) {
            GenPolynomial p = PolyUtilRoot.realFromAlgebraicCoefficients(pfac, a);
            factors.add(p);
        }
        logger.info((Object)("real algebraic factors = " + factors));
        return factors;
    }
}

