/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFiniteFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteAlgebraicFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class SquarefreeFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeAbstract<C> {
    private static final Logger logger = Logger.getLogger(SquarefreeFieldCharP.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final RingFactory<C> coFac;
    protected final AlgebraicNumberRing<C> aCoFac;
    protected final QuotientRing<C> qCoFac;

    public SquarefreeFieldCharP(RingFactory<C> fac) {
        super(GCDFactory.getProxy(fac));
        if (!fac.isField()) {
            logger.warn((Object)("fac should be a field: " + fac.toScript()));
        }
        if (fac.characteristic().signum() == 0) {
            throw new IllegalArgumentException("characterisic(fac) must be non-zero");
        }
        this.coFac = fac;
        RingFactory<C> oFac = this.coFac;
        if (oFac instanceof AlgebraicNumberRing) {
            this.aCoFac = (AlgebraicNumberRing)oFac;
            this.qCoFac = null;
        } else {
            this.aCoFac = null;
            this.qCoFac = oFac instanceof QuotientRing ? (QuotientRing)oFac : null;
        }
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.engine + " over " + this.coFac;
    }

    @Override
    public GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> s = pfac.getONE();
        SortedMap<GenPolynomial<C>, Long> factors = this.baseSquarefreeFactors(P);
        logger.info((Object)("sqfPart,factors = " + factors));
        for (GenPolynomial<C> sp : factors.keySet()) {
            s = s.multiply((GenPolynomial<GenPolynomial<C>>)sp);
        }
        return s.monic();
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> A) {
        TreeMap<GenPolynomial<C>, Long> sfactors = new TreeMap<GenPolynomial<C>, Long>();
        if (A == null || A.isZERO()) {
            return sfactors;
        }
        GenPolynomialRing pfac = A.ring;
        if (A.isConstant()) {
            GcdRingElem coeff = (GcdRingElem)A.leadingBaseCoefficient();
            SortedMap<GcdRingElem, Long> rfactors = this.squarefreeFactors(coeff);
            if (rfactors != null && rfactors.size() > 0) {
                for (Map.Entry<GcdRingElem, Long> me : rfactors.entrySet()) {
                    GcdRingElem c = me.getKey();
                    if (c.isONE()) continue;
                    GenPolynomial<GcdRingElem> cr = ((GenPolynomial)pfac.getONE()).multiply(c);
                    Long rk = me.getValue();
                    sfactors.put(cr, rk);
                }
            } else {
                sfactors.put(A, 1L);
            }
            return sfactors;
        }
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GcdRingElem ldbcf = (GcdRingElem)A.leadingBaseCoefficient();
        if (!ldbcf.isONE()) {
            A = A.divide(ldbcf);
            SortedMap<GcdRingElem, Long> rfactors = this.squarefreeFactors(ldbcf);
            if (rfactors != null && rfactors.size() > 0) {
                for (Map.Entry<GcdRingElem, Long> me : rfactors.entrySet()) {
                    GcdRingElem c = me.getKey();
                    if (c.isONE()) continue;
                    GenPolynomial<GcdRingElem> cr = ((GenPolynomial)pfac.getONE()).multiply(c);
                    Long rk = me.getValue();
                    sfactors.put(cr, rk);
                }
            } else {
                GenPolynomial<GcdRingElem> f1 = ((GenPolynomial)pfac.getONE()).multiply(ldbcf);
                sfactors.put(f1, 1L);
            }
            ldbcf = (GcdRingElem)pfac.coFac.getONE();
        }
        AbelianGroupElem T0 = A;
        long e = 1L;
        GenPolynomial<C> T = null;
        GenPolynomial<C> V = null;
        long k = 0L;
        long mp = 0L;
        boolean init = true;
        while (true) {
            if (init) {
                if (T0.isConstant() || T0.isZERO()) break;
                GenPolynomial<C> Tp = PolyUtil.baseDeriviative(T0);
                T = this.engine.baseGcd(T0, Tp);
                T = T.monic();
                V = PolyUtil.basePseudoDivide(T0, T);
                k = 0L;
                mp = 0L;
                init = false;
            }
            if (V.isConstant()) {
                mp = pfac.characteristic().longValue();
                T0 = this.baseRootCharacteristic(T);
                logger.info((Object)("char root: T0 = " + T0 + ", T = " + T));
                if (T0 == null) {
                    T0 = pfac.getZERO();
                }
                e *= mp;
                init = true;
                continue;
            }
            if (mp != 0L && ++k % mp == 0L) {
                T = PolyUtil.basePseudoDivide(T, V);
                System.out.println("k = " + k);
                ++k;
            }
            GenPolynomial<C> W = this.engine.baseGcd(T, V);
            W = W.monic();
            GenPolynomial<C> z = PolyUtil.basePseudoDivide(V, W);
            V = W;
            T = PolyUtil.basePseudoDivide(T, V);
            if (z.degree(0) <= 0L) continue;
            if (ldbcf.isONE() && !((GcdRingElem)z.leadingBaseCoefficient()).isONE()) {
                z = z.monic();
                logger.info((Object)("z,monic = " + z));
            }
            sfactors.put(z, e * k);
        }
        logger.info((Object)("exit char root: T0 = " + T0 + ", T = " + T));
        return sfactors;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for multivariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> s = pfac.getONE();
        SortedMap<GenPolynomial<GenPolynomial<C>>, Long> factors = this.recursiveUnivariateSquarefreeFactors(P);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sqfPart,factors = " + factors));
        }
        for (GenPolynomial<GenPolynomial<C>> sp : factors.keySet()) {
            s = s.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)sp);
        }
        return PolyUtil.monic(s);
    }

    @Override
    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> P) {
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> sfactors = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (P == null || P.isZERO()) {
            return sfactors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing cfac = (GenPolynomialRing)pfac.coFac;
        GcdRingElem ldbcf = (GcdRingElem)P.leadingBaseCoefficient().leadingBaseCoefficient();
        if (!ldbcf.isONE()) {
            GenPolynomial<GcdRingElem> lc = ((GenPolynomial)cfac.getONE()).multiply(ldbcf);
            GenPolynomial<GenPolynomial<GcdRingElem>> pl = ((GenPolynomial)pfac.getONE()).multiply(lc);
            sfactors.put(pl, 1L);
            GcdRingElem li = (GcdRingElem)ldbcf.inverse();
            P = P.multiply(((GenPolynomial)cfac.getONE()).multiply(li));
            ldbcf = (GcdRingElem)P.leadingBaseCoefficient().leadingBaseCoefficient();
            if (this.debug) {
                logger.debug((Object)("new ldbcf: " + ldbcf));
            }
        }
        GenPolynomial<C> Pc = this.engine.recursiveContent(P);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Pc = " + Pc));
        }
        if (!(Pc = Pc.monic()).isONE()) {
            P = PolyUtil.coefficientPseudoDivide(P, Pc);
        }
        SortedMap<GenPolynomial<C>, Long> rsf = this.squarefreeFactors((C)Pc);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rsf = " + rsf));
        }
        for (Map.Entry<GenPolynomial<C>, Long> me : rsf.entrySet()) {
            GenPolynomial<C> c = me.getKey();
            if (c.isONE()) continue;
            GenPolynomial<GenPolynomial<C>> cr = ((GenPolynomial)pfac.getONE()).multiply(c);
            Long rk = me.getValue();
            sfactors.put(cr, rk);
        }
        AbelianGroupElem T0 = P;
        long e = 1L;
        GenPolynomial T = null;
        GenPolynomial V = null;
        long k = 0L;
        long mp = 0L;
        boolean init = true;
        while (true) {
            if (init) {
                if (T0.isConstant() || T0.isZERO()) break;
                GenPolynomial Tp = PolyUtil.recursiveDeriviative(T0);
                T = this.engine.recursiveUnivariateGcd(T0, Tp);
                T = PolyUtil.monic(T);
                V = PolyUtil.recursivePseudoDivide(T0, T);
                k = 0L;
                mp = 0L;
                init = false;
            }
            if (V.isConstant()) {
                mp = pfac.characteristic().longValue();
                T0 = this.recursiveUnivariateRootCharacteristic(T);
                logger.info((Object)("char root: T0r = " + T0 + ", Tr = " + T));
                if (T0 == null) {
                    T0 = pfac.getZERO();
                }
                e *= mp;
                init = true;
            }
            if (mp != 0L && ++k % mp == 0L) {
                T = PolyUtil.recursivePseudoDivide(T, V);
                System.out.println("k = " + k);
                ++k;
            }
            GenPolynomial W = this.engine.recursiveUnivariateGcd(T, V);
            W = PolyUtil.monic(W);
            GenPolynomial z = PolyUtil.recursivePseudoDivide(V, W);
            V = W;
            T = PolyUtil.recursivePseudoDivide(T, V);
            if (z.isONE() || z.isZERO()) continue;
            z = PolyUtil.monic(z);
            logger.info((Object)("z,put = " + z));
            sfactors.put(z, e * k);
        }
        logger.info((Object)("exit char root: T0 = " + T0 + ", T = " + T));
        if (sfactors.size() == 0) {
            sfactors.put((GenPolynomial<GenPolynomial<C>>)pfac.getONE(), 1L);
        }
        return sfactors;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseSquarefreePart(P);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> s = pfac.getONE();
        SortedMap<GenPolynomial<C>, Long> factors = this.squarefreeFactors((C)P);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sqfPart,factors = " + factors));
        }
        for (GenPolynomial<C> sp : factors.keySet()) {
            if (sp.isConstant()) continue;
            s = s.multiply((GenPolynomial<GenPolynomial<C>>)sp);
        }
        return s.monic();
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseSquarefreeFactors(P);
        }
        TreeMap<GenPolynomial<C>, Long> sfactors = new TreeMap<GenPolynomial<C>, Long>();
        if (P.isZERO()) {
            return sfactors;
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        SortedMap PP = this.recursiveUnivariateSquarefreeFactors(Pr);
        for (Map.Entry m : PP.entrySet()) {
            Long i = m.getValue();
            GenPolynomial Dr = m.getKey();
            GenPolynomial D = PolyUtil.distribute(pfac, Dr);
            sfactors.put(D, i);
        }
        return sfactors;
    }

    @Override
    public SortedMap<C, Long> squarefreeFactors(C coeff) {
        if (coeff == null) {
            return null;
        }
        TreeMap<Object, Long> factors = new TreeMap<Object, Long>();
        RingFactory cfac = (RingFactory)coeff.factory();
        if (this.aCoFac != null) {
            AlgebraicNumber an = (AlgebraicNumber)coeff;
            if (cfac.isFinite()) {
                SquarefreeFiniteFieldCharP reng = (SquarefreeFiniteFieldCharP)SquarefreeFactory.getImplementation(cfac);
                SortedMap<C, Long> rfactors = reng.rootCharacteristic(coeff);
                logger.info((Object)("rfactors,finite = " + rfactors));
                factors.putAll(rfactors);
            } else {
                SquarefreeInfiniteAlgebraicFieldCharP reng = (SquarefreeInfiniteAlgebraicFieldCharP)SquarefreeFactory.getImplementation(cfac);
                SortedMap rfactors = reng.squarefreeFactors(an);
                logger.info((Object)("rfactors,infinite,algeb = " + rfactors));
                for (Map.Entry me : rfactors.entrySet()) {
                    AlgebraicNumber c = me.getKey();
                    if (c.isONE()) continue;
                    GcdRingElem cr = c;
                    Long rk = me.getValue();
                    factors.put(cr, rk);
                }
            }
        } else if (this.qCoFac != null) {
            Quotient q = (Quotient)coeff;
            SquarefreeInfiniteFieldCharP reng = (SquarefreeInfiniteFieldCharP)SquarefreeFactory.getImplementation(cfac);
            SortedMap rfactors = reng.squarefreeFactors(q);
            logger.info((Object)("rfactors,infinite = " + rfactors));
            for (Map.Entry me : rfactors.entrySet()) {
                Quotient c = me.getKey();
                if (c.isONE()) continue;
                GcdRingElem cr = c;
                Long rk = me.getValue();
                factors.put(cr, rk);
            }
        } else if (cfac.isFinite()) {
            SquarefreeFiniteFieldCharP reng = (SquarefreeFiniteFieldCharP)SquarefreeFactory.getImplementation(cfac);
            SortedMap<C, Long> rfactors = reng.rootCharacteristic(coeff);
            logger.info((Object)("rfactors,finite = " + rfactors));
            factors.putAll(rfactors);
        } else {
            logger.warn((Object)("case " + cfac + " not implemented"));
        }
        return factors;
    }

    public abstract GenPolynomial<C> baseRootCharacteristic(GenPolynomial<C> var1);

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<C>> var1);

    public boolean isCharRoot(GenPolynomial<C> P, SortedMap<GenPolynomial<C>, Long> F) {
        boolean f;
        if (P == null || F == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (P.isZERO() && F.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> t = P.ring.getONE();
        long p = P.ring.characteristic().longValue();
        for (Map.Entry<GenPolynomial<C>, Long> me : F.entrySet()) {
            GenPolynomial<C> f2 = me.getKey();
            Long E = me.getValue();
            long e = E;
            GenPolynomial<C> g = Power.positivePower(f2, e);
            if (!f2.isConstant()) {
                g = Power.positivePower(g, p);
            }
            t = t.multiply((GenPolynomial<GenPolynomial<C>>)g);
        }
        boolean bl = f = P.equals(t) || P.equals(t.negate());
        if (!f) {
            System.out.println("\nfactorization(map): " + f);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
            P = P.monic();
            t = t.monic();
            boolean bl2 = f = P.equals(t) || P.equals(t.negate());
            if (f) {
                return f;
            }
            System.out.println("\nfactorization(map): " + f);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
        }
        return f;
    }

    public boolean isRecursiveCharRoot(GenPolynomial<GenPolynomial<C>> P, SortedMap<GenPolynomial<GenPolynomial<C>>, Long> F) {
        boolean f;
        if (P == null || F == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (P.isZERO() && F.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> t = P.ring.getONE();
        long p = P.ring.characteristic().longValue();
        for (Map.Entry<GenPolynomial<GenPolynomial<C>>, Long> me : F.entrySet()) {
            GenPolynomial<GenPolynomial<C>> f2 = me.getKey();
            Long E = me.getValue();
            long e = E;
            GenPolynomial<GenPolynomial<C>> g = Power.positivePower(f2, e);
            if (!f2.isConstant()) {
                g = Power.positivePower(g, p);
            }
            t = t.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)g);
        }
        boolean bl = f = P.equals(t) || P.equals(t.negate());
        if (!f) {
            System.out.println("\nfactorization(map): " + f);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
            P = P.monic();
            t = t.monic();
            boolean bl2 = f = P.equals(t) || P.equals(t.negate());
            if (f) {
                return f;
            }
            System.out.println("\nfactorization(map): " + f);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
        }
        return f;
    }

    public boolean isRecursiveCharRoot(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> r) {
        boolean f;
        if (P == null || r == null) {
            throw new IllegalArgumentException("P and r may not be null");
        }
        if (P.isZERO() && r.isZERO()) {
            return true;
        }
        long p = P.ring.characteristic().longValue();
        GenPolynomial<GenPolynomial<C>> t = Power.positivePower(r, p);
        boolean bl = f = P.equals(t) || P.equals(t.negate());
        if (!f) {
            System.out.println("\nisCharRoot: " + f);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
            P = P.monic();
            t = t.monic();
            boolean bl2 = f = P.equals(t) || P.equals(t.negate());
            if (f) {
                return f;
            }
            System.out.println("\nisCharRoot: " + f);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
        }
        return f;
    }
}

