/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class HenselUtil {
    private static final Logger logger = Logger.getLogger(HenselUtil.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHensel(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S, GenPolynomial<MOD> T) throws NoLiftingException {
        GcdRingElem b;
        RingFactory p;
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing pfac = A.ring;
        RingFactory q = p = pfac.coFac;
        ModularRingFactory P = (ModularRingFactory)p;
        ModularRingFactory Q = (ModularRingFactory)q;
        BigInteger Qi = Q.getIntegerModul();
        BigInteger M2 = M.multiply(M.fromInteger(2L));
        BigInteger Mq = Qi;
        BigInteger c = C.leadingBaseCoefficient();
        C = C.multiply(c);
        GcdRingElem a = (GcdRingElem)A.leadingBaseCoefficient();
        if (!a.isONE()) {
            A = A.divide((Object)a);
            S = S.multiply((Object)a);
        }
        if (!(b = (GcdRingElem)B.leadingBaseCoefficient()).isONE()) {
            B = B.divide((Object)b);
            T = T.multiply((Object)b);
        }
        GcdRingElem cm = (GcdRingElem)P.fromInteger(c.getVal());
        A = A.multiply((Object)cm);
        B = B.multiply((Object)cm);
        T = T.divide((Object)cm);
        S = S.divide((Object)cm);
        GenPolynomial<RingElem<BigInteger>> Ai = PolyUtil.integerFromModularCoefficients(fac, A);
        GenPolynomial<RingElem<BigInteger>> Bi = PolyUtil.integerFromModularCoefficients(fac, B);
        ExpVector ea = Ai.leadingExpVector();
        ExpVector eb = Bi.leadingExpVector();
        Ai.doPutToMap(ea, c);
        Bi.doPutToMap(eb, c);
        GenPolynomial<Object> A1p = A;
        GenPolynomial<Object> B1p = B;
        while (Mq.compareTo(M2) < 0) {
            GenPolynomial<GenPolynomial<GenPolynomial<BigInteger>>> E = C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi))));
            if (E.isZERO()) {
                logger.info((Object)"leaving on zero E");
                break;
            }
            E = E.divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)Qi));
            GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(pfac, E);
            GenPolynomial<GenPolynomial<Object>> Ap = S.multiply((Object)Ep);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> Bp = T.multiply((Object)Ep);
            GenPolynomial<Object>[] QR = Ap.quotientRemainder(B);
            GenPolynomial<Object> Qp = QR[0];
            GenPolynomial<Object> Rp = QR[1];
            A1p = Rp;
            B1p = Bp.sum((GenPolynomial<GenPolynomial<GenPolynomial<Object>>>)A.multiply((Object)Qp));
            GenPolynomial<RingElem<BigInteger>> Ea = PolyUtil.integerFromModularCoefficients(fac, A1p);
            GenPolynomial<RingElem<BigInteger>> Eb = PolyUtil.integerFromModularCoefficients(fac, B1p);
            GenPolynomial<BigInteger> Ea1 = Ea.multiply(Qi);
            GenPolynomial<BigInteger> Eb1 = Eb.multiply(Qi);
            Ea = Ai.sum((BigInteger)((Object)Eb1));
            Eb = Bi.sum((BigInteger)((Object)Ea1));
            assert (Ea.degree(0) + Eb.degree(0) <= C.degree(0));
            Mq = Qi;
            Qi = Q.getIntegerModul().multiply(P.getIntegerModul());
            Q = ModLongRing.MAX_LONG.compareTo(Qi.getVal()) > 0 ? new ModLongRing(Qi.getVal()) : new ModIntegerRing(Qi.getVal());
            Ai = Ea;
            Bi = Eb;
        }
        GreatestCommonDivisorPrimitive<BigInteger> ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        BigInteger ai = ufd.baseContent(Ai);
        Ai = Ai.divide(ai);
        BigInteger bi = null;
        try {
            bi = c.divide(ai);
            Bi = Bi.divide(bi);
        }
        catch (RuntimeException e) {
            throw new NoLiftingException("no exact lifting possible " + e);
        }
        return new HenselApprox<Object>(Ai, Bi, A1p, B1p);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHensel(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B) throws NoLiftingException {
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        try {
            GenPolynomial<MOD>[] gst = A.egcd(B);
            if (!gst[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
            }
            GenPolynomial<MOD> s = gst[1];
            GenPolynomial<MOD> t = gst[2];
            HenselApprox<MOD> ab = HenselUtil.liftHensel(C, M, A, B, s, t);
            return ab;
        }
        catch (ArithmeticException e) {
            throw new NoLiftingException("coefficient error " + e);
        }
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadratic(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S, GenPolynomial<MOD> T) throws NoLiftingException {
        GcdRingElem b;
        RingFactory p;
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing pfac = A.ring;
        RingFactory q = p = pfac.coFac;
        ModularRingFactory P = (ModularRingFactory)p;
        ModularRingFactory Q = (ModularRingFactory)q;
        BigInteger Qi = Q.getIntegerModul();
        BigInteger M2 = M.multiply(M.fromInteger(2L));
        BigInteger Mq = Qi;
        GenPolynomialRing qfac = new GenPolynomialRing(Q, pfac);
        BigInteger c = C.leadingBaseCoefficient();
        C = C.multiply(c);
        GcdRingElem a = (GcdRingElem)A.leadingBaseCoefficient();
        if (!a.isONE()) {
            A = A.divide((Object)a);
            S = S.multiply((Object)a);
        }
        if (!(b = (GcdRingElem)B.leadingBaseCoefficient()).isONE()) {
            B = B.divide((Object)b);
            T = T.multiply((Object)b);
        }
        GcdRingElem cm = (GcdRingElem)P.fromInteger(c.getVal());
        A = A.multiply((Object)cm);
        B = B.multiply((Object)cm);
        T = T.divide((Object)cm);
        S = S.divide((Object)cm);
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(fac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(fac, B);
        ExpVector ea = Ai.leadingExpVector();
        ExpVector eb = Bi.leadingExpVector();
        Ai.doPutToMap(ea, c);
        Bi.doPutToMap(eb, c);
        GenPolynomial<Object> A1p = A;
        GenPolynomial<Object> B1p = B;
        GenPolynomial<Object> Sp = S;
        GenPolynomial<Object> Tp = T;
        GenPolynomial<RingElem<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(fac, S);
        GenPolynomial<RingElem<BigInteger>> Ti = PolyUtil.integerFromModularCoefficients(fac, T);
        GenPolynomial Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
        GenPolynomial Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
        while (Mq.compareTo(M2) < 0) {
            MonoidElem<GenPolynomial<GenPolynomial<BigInteger>>> E = C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi))));
            if (((GenPolynomial)E).isZERO()) {
                logger.info((Object)"leaving on zero E");
                break;
            }
            E = ((GenPolynomial)E).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)Qi));
            GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(qfac, E);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> Ap = Sp.multiply((Object)Ep);
            GenPolynomial Bp = Tp.multiply((Object)Ep);
            GenPolynomial<GenPolynomial<C>>[] QR = Ap.quotientRemainder(Bq);
            GenPolynomial Qp = QR[0];
            GenPolynomial<GenPolynomial<Object>> Rp = QR[1];
            A1p = Rp;
            B1p = Bp.sum(Aq.multiply(Qp));
            GenPolynomial<RingElem<BigInteger>> Ea = PolyUtil.integerFromModularCoefficients(fac, A1p);
            GenPolynomial<RingElem<BigInteger>> Eb = PolyUtil.integerFromModularCoefficients(fac, B1p);
            GenPolynomial<RingElem<BigInteger>> Ea1 = Ea.multiply(Qi);
            GenPolynomial<RingElem<BigInteger>> Eb1 = Eb.multiply(Qi);
            Ea = Ai.sum((BigInteger)((Object)Eb1));
            Eb = Bi.sum((BigInteger)((Object)Ea1));
            assert (Ea.degree(0) + Eb.degree(0) <= C.degree(0));
            Ai = Ea;
            Bi = Eb;
            E = fac.getONE();
            E = ((GenPolynomial)E).subtract(Si.multiply((BigInteger)((Object)Ai))).subtract(Ti.multiply((BigInteger)((Object)Bi)));
            E = ((GenPolynomial)E).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)Qi));
            Ep = PolyUtil.fromIntegerCoefficients(qfac, E);
            Ap = Sp.multiply((Object)Ep);
            Bp = Tp.multiply((Object)Ep);
            QR = Bp.quotientRemainder(Aq);
            Qp = QR[0];
            Rp = QR[1];
            B1p = Rp;
            A1p = Ap.sum(Bq.multiply(Qp));
            Ea = PolyUtil.integerFromModularCoefficients(fac, A1p);
            Eb = PolyUtil.integerFromModularCoefficients(fac, B1p);
            Ea1 = Ea.multiply(Qi);
            Eb1 = Eb.multiply(Qi);
            Ea = Si.sum((BigInteger)((Object)Ea1));
            Eb = Ti.sum((BigInteger)((Object)Eb1));
            Si = Ea;
            Ti = Eb;
            Mq = Qi;
            Qi = Q.getIntegerModul().multiply(Q.getIntegerModul());
            Q = ModLongRing.MAX_LONG.compareTo(Qi.getVal()) > 0 ? new ModLongRing(Qi.getVal()) : new ModIntegerRing(Qi.getVal());
            qfac = new GenPolynomialRing(Q, pfac);
            Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
            Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
            Sp = PolyUtil.fromIntegerCoefficients(qfac, Si);
            Tp = PolyUtil.fromIntegerCoefficients(qfac, Ti);
        }
        GreatestCommonDivisorPrimitive<BigInteger> ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        BigInteger ai = ufd.baseContent(Ai);
        Ai = Ai.divide(ai);
        BigInteger bi = null;
        try {
            bi = c.divide(ai);
            Bi = Bi.divide(bi);
        }
        catch (RuntimeException e) {
            throw new NoLiftingException("no exact lifting possible " + e);
        }
        return new HenselApprox<Object>(Ai, Bi, A1p, B1p);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadratic(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B) throws NoLiftingException {
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        try {
            GenPolynomial<MOD>[] gst = A.egcd(B);
            if (!gst[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
            }
            GenPolynomial<MOD> s = gst[1];
            GenPolynomial<MOD> t = gst[2];
            HenselApprox<MOD> ab = HenselUtil.liftHenselQuadratic(C, M, A, B, s, t);
            return ab;
        }
        catch (ArithmeticException e) {
            throw new NoLiftingException("coefficient error " + e);
        }
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadraticFac(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B) throws NoLiftingException {
        if (C == null || C.isZERO()) {
            throw new IllegalArgumentException("C must be nonzero");
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        try {
            GenPolynomial<MOD>[] gst = A.egcd(B);
            if (!gst[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
            }
            GenPolynomial<MOD> s = gst[1];
            GenPolynomial<MOD> t = gst[2];
            HenselApprox<MOD> ab = HenselUtil.liftHenselQuadraticFac(C, M, A, B, s, t);
            return ab;
        }
        catch (ArithmeticException e) {
            throw new NoLiftingException("coefficient error " + e);
        }
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadraticFac(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S, GenPolynomial<MOD> T) throws NoLiftingException {
        MonoidElem<GenPolynomial<GenPolynomial<ModLong>>> Em;
        GcdRingElem cm;
        GcdRingElem b;
        BigInteger PP;
        RingFactory p;
        if (C == null || C.isZERO()) {
            throw new IllegalArgumentException("C must be nonzero");
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing pfac = A.ring;
        RingFactory q = p = pfac.coFac;
        ModularRingFactory P = (ModularRingFactory)p;
        ModularRingFactory Q = (ModularRingFactory)q;
        BigInteger Qi = PP = Q.getIntegerModul();
        BigInteger M2 = M.multiply(M.fromInteger(2L));
        if (debug) {
            logger.debug((Object)("M2 =  " + M2));
        }
        BigInteger Mq = Qi;
        GenPolynomialRing qfac = new GenPolynomialRing(Q, pfac);
        BigInteger Mi = Q.getIntegerModul().multiply(Q.getIntegerModul());
        Iterable<ModLong> Qmm = ModLongRing.MAX_LONG.compareTo(Mi.getVal()) > 0 ? new ModLongRing(Mi.getVal()) : new ModIntegerRing(Mi.getVal());
        GenPolynomialRing<ModLong> mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)Qmm), qfac);
        GcdRingElem Qm = (GcdRingElem)Qmm.fromInteger(Qi.getVal());
        BigInteger c = C.leadingBaseCoefficient();
        C = C.multiply(c);
        GcdRingElem a = (GcdRingElem)A.leadingBaseCoefficient();
        if (!a.isONE()) {
            A = A.divide((Object)a);
            S = S.multiply((Object)a);
        }
        if (!(b = (GcdRingElem)B.leadingBaseCoefficient()).isONE()) {
            B = B.divide((Object)b);
            T = T.multiply((Object)b);
        }
        if ((cm = (GcdRingElem)P.fromInteger(c.getVal())).isZERO()) {
            System.out.println("c =  " + c);
            System.out.println("P =  " + P);
            throw new ArithmeticException("c mod p == 0 not meaningful");
        }
        A = A.multiply((Object)cm);
        S = S.divide((Object)cm);
        B = B.multiply((Object)cm);
        T = T.divide((Object)cm);
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(fac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(fac, B);
        ExpVector ea = Ai.leadingExpVector();
        ExpVector eb = Bi.leadingExpVector();
        Ai.doPutToMap(ea, c);
        Bi.doPutToMap(eb, c);
        GenPolynomial<Object> A1p = A;
        GenPolynomial<Object> B1p = B;
        GenPolynomial<Object> Sp = S;
        GenPolynomial<Object> Tp = T;
        GenPolynomial<BigInteger> Si = PolyUtil.integerFromModularCoefficients(fac, S);
        GenPolynomial<BigInteger> Ti = PolyUtil.integerFromModularCoefficients(fac, T);
        GenPolynomial Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
        GenPolynomial Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
        GenPolynomial<ModLong> Cm = PolyUtil.fromIntegerCoefficients(mfac, C);
        GenPolynomial<ModLong> Am = PolyUtil.fromIntegerCoefficients(mfac, Ai);
        GenPolynomial<ModLong> Bm = PolyUtil.fromIntegerCoefficients(mfac, Bi);
        GenPolynomial<RingElem<ModLong>> Sm = PolyUtil.fromIntegerCoefficients(mfac, Si);
        GenPolynomial<RingElem<ModLong>> Tm = PolyUtil.fromIntegerCoefficients(mfac, Ti);
        while (Mq.compareTo(M2) < 0) {
            if (debug) {
                logger.debug((Object)("mfac =  " + Cm.ring));
            }
            if (((GenPolynomial)(Em = Cm.subtract((ModLong)((Object)Am.multiply((ModLong)((Object)Bm)))))).isZERO() && C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi)))).isZERO()) {
                logger.info((Object)"leaving on zero E");
                break;
            }
            GenPolynomial<BigInteger> Ei = PolyUtil.integerFromModularCoefficients(fac, Em);
            GenPolynomial Emp = PolyUtil.fromIntegerCoefficients(qfac, Ei = Ei.divide(Qi));
            if (Emp.isZERO() && C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi)))).isZERO()) {
                logger.info((Object)"leaving on zero Emp");
                break;
            }
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> Ap = Sp.multiply((Object)Emp);
            GenPolynomial Bp = Tp.multiply((Object)Emp);
            GenPolynomial<GenPolynomial<C>>[] QR = null;
            QR = Ap.quotientRemainder(Bq);
            GenPolynomial Qp = QR[0];
            GenPolynomial<GenPolynomial<Object>> Rp = QR[1];
            A1p = Rp;
            B1p = Bp.sum(Aq.multiply(Qp));
            GenPolynomial<RingElem<ModLong>> Ema = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, A1p));
            GenPolynomial<RingElem<ModLong>> Emb = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, B1p));
            GenPolynomial<RingElem<ModLong>> Ema1 = Ema.multiply((ModLong)Qm);
            GenPolynomial<RingElem<ModLong>> Emb1 = Emb.multiply((ModLong)Qm);
            Ema = Am.sum((ModLong)((Object)Emb1));
            Emb = Bm.sum((ModLong)((Object)Ema1));
            assert (Ema.degree(0) + Emb.degree(0) <= Cm.degree(0));
            Am = Ema;
            Bm = Emb;
            Ai = PolyUtil.integerFromModularCoefficients(fac, Am);
            Bi = PolyUtil.integerFromModularCoefficients(fac, Bm);
            Em = mfac.getONE();
            Em = ((GenPolynomial)Em).subtract(Sm.multiply((ModLong)((Object)Am))).subtract(Tm.multiply((ModLong)((Object)Bm)));
            Ei = PolyUtil.integerFromModularCoefficients(fac, Em);
            Ei = Ei.divide(Qi);
            Emp = PolyUtil.fromIntegerCoefficients(qfac, Ei);
            Ap = Sp.multiply((Object)Emp);
            Bp = Tp.multiply((Object)Emp);
            QR = Bp.quotientRemainder(Aq);
            Qp = QR[0];
            Rp = QR[1];
            B1p = Rp;
            A1p = Ap.sum(Bq.multiply(Qp));
            Ema = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, A1p));
            Emb = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, B1p));
            Ema1 = Ema.multiply(Qm);
            Emb1 = Emb.multiply(Qm);
            Ema = Sm.sum((ModLong)((Object)Ema1));
            Emb = Tm.sum((ModLong)((Object)Emb1));
            Sm = Ema;
            Tm = Emb;
            Si = PolyUtil.integerFromModularCoefficients(fac, Sm);
            Ti = PolyUtil.integerFromModularCoefficients(fac, Tm);
            Mq = Qi = Q.getIntegerModul().multiply(Q.getIntegerModul());
            Q = ModLongRing.MAX_LONG.compareTo(Qi.getVal()) > 0 ? new ModLongRing(Qi.getVal()) : new ModIntegerRing(Qi.getVal());
            qfac = new GenPolynomialRing(Q, pfac);
            BigInteger Qmmi = Qmm.getIntegerModul().multiply(Qmm.getIntegerModul());
            Qmm = ModLongRing.MAX_LONG.compareTo(Qmmi.getVal()) > 0 ? new ModLongRing(Qmmi.getVal()) : new ModIntegerRing(Qmmi.getVal());
            mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)Qmm), qfac);
            Qm = (GcdRingElem)Qmm.fromInteger(Qi.getVal());
            Cm = PolyUtil.fromIntegerCoefficients(mfac, C);
            Am = PolyUtil.fromIntegerCoefficients(mfac, Ai);
            Bm = PolyUtil.fromIntegerCoefficients(mfac, Bi);
            Sm = PolyUtil.fromIntegerCoefficients(mfac, Si);
            Tm = PolyUtil.fromIntegerCoefficients(mfac, Ti);
            assert (HenselUtil.isHenselLift(C, Mi, PP, Ai, Bi));
            Mi = Mi.fromInteger(Qmm.getIntegerModul().getVal());
            Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
            Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
            Sp = PolyUtil.fromIntegerCoefficients(qfac, Si);
            Tp = PolyUtil.fromIntegerCoefficients(qfac, Ti);
        }
        if (!((GenPolynomial)(Em = Cm.subtract((ModLong)((Object)Am.multiply((ModLong)((Object)Bm)))))).isZERO()) {
            System.out.println("Em =  " + Em);
        }
        GreatestCommonDivisorPrimitive<BigInteger> ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        BigInteger ai = ufd.baseContent(Ai);
        Ai = Ai.divide(ai);
        BigInteger[] qr = c.quotientRemainder(ai);
        BigInteger bi = null;
        boolean exact = true;
        if (qr[1].isZERO()) {
            bi = qr[0];
            try {
                Bi = Bi.divide(bi);
            }
            catch (RuntimeException e) {
                System.out.println("*catch: no exact factorization: " + bi + ", e = " + e);
                exact = false;
            }
        } else {
            System.out.println("*remainder: no exact factorization: q = " + qr[0] + ", r = " + qr[1]);
            exact = false;
        }
        if (!exact) {
            System.out.println("*Ai =  " + Ai);
            System.out.println("*ai =  " + ai);
            System.out.println("*Bi =  " + Bi);
            System.out.println("*bi =  " + bi);
            System.out.println("*c  =  " + c);
            throw new NoLiftingException("no exact lifting possible");
        }
        return new HenselApprox(Ai, Bi, Aq, Bq);
    }

    public static boolean isHenselLift(GenPolynomial<BigInteger> C, BigInteger M, BigInteger p, List<GenPolynomial<BigInteger>> G) {
        GenPolynomial<ModInteger> hlp;
        if (C == null || C.isZERO()) {
            return false;
        }
        GenPolynomialRing pfac = C.ring;
        ModIntegerRing pm = new ModIntegerRing(p.getVal(), true);
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(pm, pfac);
        MonoidElem<GenPolynomial<ModInteger>> cl = mfac.getONE();
        for (GenPolynomial<BigInteger> hl : G) {
            hlp = PolyUtil.fromIntegerCoefficients(mfac, hl);
            cl = ((GenPolynomial)cl).multiply(hlp);
        }
        GenPolynomial<ModInteger> cp = PolyUtil.fromIntegerCoefficients(mfac, C);
        if (!cp.equals(cl)) {
            System.out.println("Hensel precondition wrong!");
            if (debug) {
                System.out.println("cl      = " + cl);
                System.out.println("cp      = " + cp);
                System.out.println("mon(cl) = " + ((GenPolynomial)cl).monic());
                System.out.println("mon(cp) = " + cp.monic());
                System.out.println("cp-cl   = " + cp.subtract((ModInteger)cl));
                System.out.println("M       = " + M + ", p = " + p);
            }
            return false;
        }
        BigInteger mip = p;
        while (mip.compareTo(M) < 0) {
            mip = mip.multiply(mip);
        }
        pm = new ModIntegerRing(mip.getVal(), false);
        mfac = new GenPolynomialRing<ModInteger>(pm, pfac);
        cl = mfac.getONE();
        for (GenPolynomial<BigInteger> hl : G) {
            hlp = PolyUtil.fromIntegerCoefficients(mfac, hl);
            cl = ((GenPolynomial)cl).multiply(hlp);
        }
        cp = PolyUtil.fromIntegerCoefficients(mfac, C);
        if (!cp.equals(cl)) {
            System.out.println("Hensel post condition wrong!");
            System.out.println("cl    = " + cl);
            System.out.println("cp    = " + cp);
            System.out.println("cp-cl = " + cp.subtract((ModInteger)cl));
            System.out.println("M = " + M + ", p = " + p + ", p^e = " + mip);
            return false;
        }
        return true;
    }

    public static boolean isHenselLift(GenPolynomial<BigInteger> C, BigInteger M, BigInteger p, GenPolynomial<BigInteger> A, GenPolynomial<BigInteger> B) {
        ArrayList<GenPolynomial<BigInteger>> G = new ArrayList<GenPolynomial<BigInteger>>(2);
        G.add(A);
        G.add(B);
        return HenselUtil.isHenselLift(C, M, p, G);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isHenselLift(GenPolynomial<BigInteger> C, BigInteger M, BigInteger p, HenselApprox<MOD> Ha) {
        ArrayList<GenPolynomial<BigInteger>> G = new ArrayList<GenPolynomial<BigInteger>>(2);
        G.add(Ha.A);
        G.add(Ha.B);
        return HenselUtil.isHenselLift(C, M, p, G);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> GenPolynomial<MOD>[] liftExtendedEuclidean(GenPolynomial<MOD> A, GenPolynomial<MOD> B, long k) throws NoLiftingException {
        BigInteger p;
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + A + ", B = " + B);
        }
        GenPolynomialRing fac = A.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] gst = null;
        try {
            gst = A.egcd(B);
            if (!gst[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
            }
        }
        catch (ArithmeticException e) {
            throw new NoLiftingException("coefficient error " + e);
        }
        GenPolynomial<Object> S = gst[1];
        GenPolynomial<Object> T = gst[2];
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        MonoidElem one = ifac.getONE();
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(ifac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(ifac, B);
        GenPolynomial<RingElem<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(ifac, S);
        GenPolynomial<RingElem<BigInteger>> Ti = PolyUtil.integerFromModularCoefficients(ifac, T);
        ModularRingFactory mcfac = (ModularRingFactory)fac.coFac;
        BigInteger modul = p = mcfac.getIntegerModul();
        int i = 1;
        while ((long)i < k) {
            GenPolynomial<GenPolynomial<GenPolynomial<BigInteger>>> e = ((GenPolynomial)one).subtract(Si.multiply((BigInteger)((Object)Ai))).subtract(Ti.multiply((BigInteger)((Object)Bi)));
            if (e.isZERO()) {
                logger.info((Object)"leaving on zero e in liftExtendedEuclidean");
                break;
            }
            e = e.divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)modul));
            GenPolynomial c = PolyUtil.fromIntegerCoefficients(fac, e);
            GenPolynomial<GenPolynomial<MOD>> s = S.multiply((Object)c);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>> t = T.multiply((Object)c);
            GenPolynomial<GenPolynomial<C>>[] QR = s.quotientRemainder(B);
            GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> q = QR[0];
            s = QR[1];
            t = t.sum((GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>)q.multiply((GenPolynomial<GenPolynomial<MOD>>)A));
            GenPolynomial<BigInteger> si = PolyUtil.integerFromModularCoefficients(ifac, s);
            GenPolynomial<BigInteger> ti = PolyUtil.integerFromModularCoefficients(ifac, t);
            Si = Si.sum((BigInteger)((Object)si.multiply(modul)));
            Ti = Ti.sum((BigInteger)((Object)ti.multiply(modul)));
            modul = modul.multiply(p);
            ++i;
        }
        mcfac = ModLongRing.MAX_LONG.compareTo(modul.getVal()) > 0 ? new ModLongRing(modul.getVal()) : new ModIntegerRing(modul.getVal());
        GenPolynomialRing mfac = new GenPolynomialRing(mcfac, fac);
        S = PolyUtil.fromIntegerCoefficients(mfac, Si);
        T = PolyUtil.fromIntegerCoefficients(mfac, Ti);
        ArrayList<GenPolynomial<MOD>> AP = new ArrayList<GenPolynomial<MOD>>();
        AP.add(B);
        AP.add(A);
        ArrayList<GenPolynomial<MOD>> SP = new ArrayList<GenPolynomial<MOD>>();
        SP.add(S);
        SP.add(T);
        if (!HenselUtil.isExtendedEuclideanLift(AP, SP)) {
            System.out.println("isExtendedEuclideanLift: false");
        }
        GenPolynomial[] rel = new GenPolynomial[]{S, T};
        return rel;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftExtendedEuclidean(List<GenPolynomial<MOD>> A, long k) throws NoLiftingException {
        if (A == null || A.size() == 0) {
            throw new IllegalArgumentException("A must be non null and non empty");
        }
        GenPolynomialRing fac = A.get((int)0).ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem zero = fac.getZERO();
        int r = A.size();
        ArrayList<AbelianGroupElem> Q = new ArrayList<AbelianGroupElem>(r);
        for (int i = 0; i < r; ++i) {
            Q.add(zero);
        }
        Q.set(r - 2, A.get(r - 1));
        for (int j = r - 3; j >= 0; --j) {
            GenPolynomial<GenPolynomial> q = A.get(j + 1).multiply((MOD)((GenPolynomial)Q.get(j + 1)));
            Q.set(j, q);
        }
        ArrayList<AbelianGroupElem> B = new ArrayList<AbelianGroupElem>(r + 1);
        ArrayList<GenPolynomial<MOD>> lift = new ArrayList<GenPolynomial<MOD>>(r);
        for (int i = 0; i < r; ++i) {
            B.add(zero);
            lift.add((GenPolynomial<MOD>)zero);
        }
        GenPolynomial<MOD> one = fac.getONE();
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        B.add(0, one);
        GenPolynomial<MOD> b = one;
        for (int j = 0; j < r - 1; ++j) {
            List<GenPolynomial<MOD>> S = HenselUtil.liftDiophant((GenPolynomial)Q.get(j), A.get(j), (GenPolynomial)B.get(j), k);
            b = S.get(0);
            GenPolynomial bb = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, b));
            B.set(j + 1, bb);
            lift.set(j, S.get(1));
            if (!debug) continue;
            logger.info((Object)("lift(" + j + ") = " + lift.get(j)));
        }
        lift.set(r - 1, b);
        if (debug) {
            logger.info((Object)("lift(" + (r - 1) + ") = " + b));
        }
        return lift;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> C, long k) throws NoLiftingException {
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + A + ", B = " + B + ", C = " + C);
        }
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem zero = fac.getZERO();
        for (int i = 0; i < 2; ++i) {
            sol.add((GenPolynomial<MOD>)zero);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        for (Monomial<Object> m : C) {
            long e = m.e.getVal(0);
            List<GenPolynomial<Object>> S = HenselUtil.liftDiophant(A, B, e, k);
            GcdRingElem a = (GcdRingElem)m.c;
            a = (GcdRingElem)fac.coFac.fromInteger(((Modular)((Object)a)).getSymmetricInteger().getVal());
            int i = 0;
            for (GenPolynomial<Object> genPolynomial : S) {
                GenPolynomial<GcdRingElem> genPolynomial3 = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, genPolynomial));
                genPolynomial3 = genPolynomial3.multiply(a);
                GenPolynomial<GenPolynomial<GcdRingElem>> genPolynomial4 = ((GenPolynomial)sol.get(i)).sum(genPolynomial3);
                sol.set(i++, genPolynomial4);
            }
        }
        A = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, A));
        B = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, B));
        C = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, C));
        GenPolynomial<GenPolynomial<GenPolynomial>> y = B.multiply((Object)((GenPolynomial)sol.get(0))).sum((GenPolynomial)A.multiply((Object)((GenPolynomial)sol.get(1))));
        if (!y.equals(C)) {
            System.out.println("A = " + A + ", B = " + B);
            System.out.println("s1 = " + sol.get(0) + ", s2 = " + sol.get(1));
            System.out.println("Error: A*r1 + B*r2 = " + y + " : " + fac.coFac);
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> A, GenPolynomial<MOD> C, long k) throws NoLiftingException {
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem zero = fac.getZERO();
        for (int i = 0; i < A.size(); ++i) {
            sol.add((GenPolynomial<MOD>)zero);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        for (Monomial<MOD> m : C) {
            long e = m.e.getVal(0);
            List<GenPolynomial<MOD>> S = HenselUtil.liftDiophant(A, e, k);
            GcdRingElem a = (GcdRingElem)m.c;
            a = (GcdRingElem)fac.coFac.fromInteger(((Modular)((Object)a)).getSymmetricInteger().getVal());
            int i = 0;
            for (GenPolynomial<MOD> genPolynomial : S) {
                GenPolynomial<GcdRingElem> genPolynomial3 = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, genPolynomial));
                genPolynomial3 = genPolynomial3.multiply(a);
                GenPolynomial<GenPolynomial<GcdRingElem>> genPolynomial4 = ((GenPolynomial)sol.get(i)).sum(genPolynomial3);
                sol.set(i++, genPolynomial4);
            }
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> A, GenPolynomial<MOD> B, long e, long k) throws NoLiftingException {
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + A + ", B = " + B);
        }
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = A.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] lee = HenselUtil.liftExtendedEuclidean(B, A, k);
        GenPolynomial<MOD> s1 = lee[0];
        GenPolynomial<MOD> s2 = lee[1];
        if (e == 0L) {
            sol.add(s1);
            sol.add(s2);
            return sol;
        }
        fac = s1.ring;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        A = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, A));
        B = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, B));
        GenPolynomial xe = fac.univariate(0, e);
        GenPolynomial<GenPolynomial<Object>> q = s1.multiply((MOD)xe);
        GenPolynomial<GenPolynomial<C>>[] QR = q.quotientRemainder(A);
        q = QR[0];
        GenPolynomial r1 = QR[1];
        GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> r2 = s2.multiply((MOD)xe).sum((GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>)q.multiply(B));
        sol.add(r1);
        sol.add(r2);
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>>> y = B.multiply((Object)r1).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>>>>)A.multiply((Object)r2));
        if (!y.equals(xe)) {
            System.out.println("A = " + A + ", B = " + B);
            System.out.println("r1 = " + r1 + ", r2 = " + r2);
            System.out.println("Error: A*r1 + B*r2 = " + y);
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> A, long e, long k) throws NoLiftingException {
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = A.get((int)0).ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<MOD>> lee = HenselUtil.liftExtendedEuclidean(A, k);
        if (e == 0L) {
            return lee;
        }
        fac = lee.get((int)0).ring;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        ArrayList<GenPolynomial<MOD>> S = new ArrayList<GenPolynomial<MOD>>(lee.size());
        for (GenPolynomial<Object> a : lee) {
            a = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, a));
            S.add(a);
        }
        GenPolynomial xe = fac.univariate(0, e);
        int i = 0;
        for (GenPolynomial genPolynomial : S) {
            GenPolynomial<GenPolynomial<MOD>> q = genPolynomial.multiply(xe);
            GenPolynomial r = q.remainder((GenPolynomial<GenPolynomial<MOD>>)A.get(i++));
            sol.add(r);
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isDiophantLift(GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S1, GenPolynomial<MOD> S2, GenPolynomial<MOD> C) {
        GenPolynomialRing fac = C.ring;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        GenPolynomial a = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, A));
        GenPolynomial b = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, B));
        GenPolynomial s1 = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, S1));
        GenPolynomial s2 = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, S2));
        GenPolynomial t = a.multiply(s1).sum(b.multiply(s2));
        if (t.equals(C)) {
            return true;
        }
        if (debug) {
            System.out.println("a  = " + a);
            System.out.println("b  = " + b);
            System.out.println("s1 = " + s1);
            System.out.println("s2 = " + s2);
            System.out.println("t  = " + t);
            System.out.println("C  = " + C);
        }
        return false;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isExtendedEuclideanLift(List<GenPolynomial<MOD>> A, List<GenPolynomial<MOD>> S) {
        GenPolynomialRing fac = A.get((int)0).ring;
        MonoidElem C = fac.getONE();
        return HenselUtil.isDiophantLift(A, S, C);
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isDiophantLift(List<GenPolynomial<MOD>> A, List<GenPolynomial<MOD>> S, GenPolynomial<MOD> C) {
        GenPolynomialRing fac = A.get((int)0).ring;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        ArrayList B = new ArrayList(A.size());
        int i = 0;
        for (GenPolynomial<MOD> ai : A) {
            void var9_11;
            MonoidElem monoidElem = fac.getONE();
            int j = 0;
            for (GenPolynomial<MOD> aj : A) {
                if (i != j) {
                    GenPolynomial<GenPolynomial<MOD>> genPolynomial = var9_11.multiply(aj);
                }
                ++j;
            }
            GenPolynomial genPolynomial = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, var9_11));
            B.add(genPolynomial);
            ++i;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> t = fac.getZERO();
        i = 0;
        for (GenPolynomial genPolynomial : B) {
            GenPolynomial<Object> b = S.get(i++);
            b = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, b));
            GenPolynomial<GenPolynomial<MOD>> s = genPolynomial.multiply(b);
            t = t.sum(s);
        }
        if (!t.equals(C)) {
            if (debug) {
                System.out.println("no diophant lift!");
                System.out.println("A = " + A);
                System.out.println("B = " + B);
                System.out.println("S = " + S);
                System.out.println("C = " + C);
                System.out.println("t = " + t);
            }
            return false;
        }
        return true;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHenselMonic(GenPolynomial<BigInteger> C, List<GenPolynomial<MOD>> F, long k) throws NoLiftingException {
        BigInteger p;
        if (C == null || C.isZERO() || F == null || F.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<Object>> lift = new ArrayList<GenPolynomial<MOD>>(F.size());
        GenPolynomialRing pfac = F.get((int)0).ring;
        RingFactory pcfac = pfac.coFac;
        ModularRingFactory PF = (ModularRingFactory)pcfac;
        BigInteger P = PF.getIntegerModul();
        int n = F.size();
        if (n == 1) {
            GenPolynomial<Object> f = F.get(0);
            Iterable<ModLong> mcfac = ModLongRing.MAX_LONG.compareTo(P.getVal()) > 0 ? new ModLongRing(P.getVal()) : new ModIntegerRing(P.getVal());
            GenPolynomialRing<ModLong> mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)mcfac), fac);
            f = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, f));
            lift.add(f);
            return lift;
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        List<GenPolynomial<BigInteger>> Fi = PolyUtil.integerFromModularCoefficients(ifac, F);
        List S = HenselUtil.liftExtendedEuclidean(F, k + 1L);
        logger.info((Object)("EE lift = " + S));
        List<GenPolynomial<MOD>> Sx = PolyUtil.fromIntegerCoefficients(pfac, PolyUtil.integerFromModularCoefficients(ifac, S));
        try {
            boolean il = HenselUtil.isExtendedEuclideanLift(F, Sx);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        List<GenPolynomial<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(ifac, S);
        ModularRingFactory mcfac = PF;
        BigInteger modul = p = mcfac.getIntegerModul();
        GenPolynomialRing mfac = new GenPolynomialRing(mcfac, fac);
        List Sp = PolyUtil.fromIntegerCoefficients(mfac, Si);
        int i = 1;
        while ((long)i < k) {
            GenPolynomial<RingElem<BigInteger>> e = fac.getONE();
            for (GenPolynomial<BigInteger> fi : Fi) {
                e = e.multiply((RingElem<BigInteger>)fi);
            }
            if ((e = C.subtract((BigInteger)((Object)e))).isZERO()) {
                logger.info((Object)"leaving on zero e");
                break;
            }
            try {
                e = e.divide(modul);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw ex;
            }
            GenPolynomial c = PolyUtil.fromIntegerCoefficients(mfac, e);
            ArrayList s = new ArrayList(S.size());
            int j = 0;
            for (GenPolynomial genPolynomial : Sp) {
                GenPolynomial<GenPolynomial<MOD>> genPolynomial2 = genPolynomial.multiply(c);
                GenPolynomial genPolynomial3 = genPolynomial2.remainder((GenPolynomial<GenPolynomial<MOD>>)F.get(j++));
                s.add(genPolynomial3);
            }
            List<GenPolynomial<BigInteger>> si = PolyUtil.integerFromModularCoefficients(ifac, s);
            ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>(F.size());
            j = 0;
            for (GenPolynomial<RingElem<BigInteger>> f : Fi) {
                f = f.sum((BigInteger)((Object)si.get(j++).multiply(modul)));
                arrayList.add(f);
            }
            Fi = arrayList;
            modul = modul.multiply(p);
            if ((long)i >= k - 1L) {
                logger.info((Object)("e != 0 for k = " + k));
            }
            ++i;
        }
        mcfac = ModLongRing.MAX_LONG.compareTo((modul = Power.positivePower(p, k)).getVal()) > 0 ? new ModLongRing(modul.getVal()) : new ModIntegerRing(modul.getVal());
        mfac = new GenPolynomialRing(mcfac, fac);
        lift = PolyUtil.fromIntegerCoefficients(mfac, Fi);
        return lift;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHensel(GenPolynomial<BigInteger> C, List<GenPolynomial<MOD>> F, long k, BigInteger g) throws NoLiftingException {
        BigInteger p;
        if (C == null || C.isZERO() || F == null || F.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<Object>> lift = new ArrayList<GenPolynomial<MOD>>(F.size());
        GenPolynomialRing pfac = F.get((int)0).ring;
        RingFactory pcfac = pfac.coFac;
        ModularRingFactory PF = (ModularRingFactory)pcfac;
        BigInteger P = PF.getIntegerModul();
        int n = F.size();
        if (n == 1) {
            GenPolynomial<Object> f = F.get(0);
            Iterable<ModLong> mcfac = ModLongRing.MAX_LONG.compareTo(P.getVal()) > 0 ? new ModLongRing(P.getVal()) : new ModIntegerRing(P.getVal());
            GenPolynomialRing<ModLong> mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)mcfac), fac);
            f = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, f));
            lift.add(f);
            return lift;
        }
        BigInteger cc = g;
        for (int i = 1; i < F.size(); ++i) {
            C = C.multiply(cc);
        }
        GcdRingElem cm = (GcdRingElem)PF.fromInteger(cc.getVal());
        ArrayList<GenPolynomial<MOD>> Fp = new ArrayList<GenPolynomial<MOD>>(F.size());
        for (GenPolynomial<MOD> fm : F) {
            GenPolynomial<Object> am = fm.monic();
            am = am.multiply((MOD)cm);
            Fp.add(am);
        }
        F = Fp;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        List<GenPolynomial<BigInteger>> Fi = PolyUtil.integerFromModularCoefficients(ifac, F);
        for (GenPolynomial<BigInteger> ai : Fi) {
            if (ai.isZERO()) continue;
            ExpVector ea = ai.leadingExpVector();
            ai.doPutToMap(ea, cc);
        }
        List S = HenselUtil.liftExtendedEuclidean(F, k + 1L);
        logger.info((Object)("EE lift = " + S));
        List<GenPolynomial<MOD>> Sx = PolyUtil.fromIntegerCoefficients(pfac, PolyUtil.integerFromModularCoefficients(ifac, S));
        try {
            boolean il = HenselUtil.isExtendedEuclideanLift(F, Sx);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        List<GenPolynomial<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(ifac, S);
        ModularRingFactory mcfac = PF;
        BigInteger modul = p = mcfac.getIntegerModul();
        GenPolynomialRing mfac = new GenPolynomialRing(mcfac, fac);
        List Sp = PolyUtil.fromIntegerCoefficients(mfac, Si);
        int i = 1;
        while ((long)i < k) {
            GenPolynomial<RingElem<BigInteger>> e = fac.getONE();
            for (GenPolynomial<BigInteger> fi : Fi) {
                e = e.multiply((RingElem<BigInteger>)fi);
            }
            if ((e = C.subtract((BigInteger)((Object)e))).isZERO()) {
                logger.info((Object)"leaving on zero e");
                break;
            }
            try {
                e = e.divide(modul);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw ex;
            }
            GenPolynomial c = PolyUtil.fromIntegerCoefficients(mfac, e);
            ArrayList s = new ArrayList(S.size());
            int j = 0;
            for (GenPolynomial genPolynomial : Sp) {
                GenPolynomial<GenPolynomial<MOD>> genPolynomial2 = genPolynomial.multiply(c);
                GenPolynomial genPolynomial3 = genPolynomial2.remainder((GenPolynomial<GenPolynomial<MOD>>)F.get(j++));
                s.add(genPolynomial3);
            }
            List<GenPolynomial<BigInteger>> si = PolyUtil.integerFromModularCoefficients(ifac, s);
            ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>(F.size());
            j = 0;
            for (GenPolynomial<RingElem<BigInteger>> f : Fi) {
                f = f.sum((BigInteger)((Object)si.get(j++).multiply(modul)));
                arrayList.add(f);
            }
            Fi = arrayList;
            modul = modul.multiply(p);
            if ((long)i >= k - 1L) {
                logger.info((Object)("e != 0 for k = " + k));
            }
            ++i;
        }
        GreatestCommonDivisorAbstract<BigInteger> ufd = GCDFactory.getImplementation(cc);
        ArrayList<GenPolynomial<BigInteger>> Fii = new ArrayList<GenPolynomial<BigInteger>>(F.size());
        for (GenPolynomial<BigInteger> bi : Fi) {
            GenPolynomial<BigInteger> ci = null;
            ci = ufd.basePrimitivePart(bi);
            Fii.add(ci);
        }
        Fi = Fii;
        modul = Power.positivePower(p, k);
        mcfac = ModLongRing.MAX_LONG.compareTo(modul.getVal()) > 0 ? new ModLongRing(modul.getVal()) : new ModIntegerRing(modul.getVal());
        mfac = new GenPolynomialRing(mcfac, fac);
        lift = PolyUtil.fromIntegerCoefficients(mfac, Fi);
        return lift;
    }
}

