/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselMultUtil;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class GreatestCommonDivisorHensel<MOD extends GcdRingElem<MOD> & Modular>
extends GreatestCommonDivisorAbstract<BigInteger> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorHensel.class);
    private final boolean debug = logger.isDebugEnabled();
    public final boolean quadratic;
    public final GreatestCommonDivisorAbstract<BigInteger> iufd;
    private final GreatestCommonDivisorAbstract<BigInteger> ufd;

    public GreatestCommonDivisorHensel() {
        this(true);
    }

    public GreatestCommonDivisorHensel(boolean quadratic) {
        this.quadratic = quadratic;
        this.iufd = new GreatestCommonDivisorSubres<BigInteger>();
        this.ufd = this;
    }

    @Override
    public GenPolynomial<BigInteger> baseGcd(GenPolynomial<BigInteger> P, GenPolynomial<BigInteger> S) {
        AbelianGroupElem<GenPolynomial<BigInteger>> q;
        AbelianGroupElem<GenPolynomial<BigInteger>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        GenPolynomialRing fac = P.ring;
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        if (this.debug) {
            logger.debug((Object)("degrees: e = " + e + ", f = " + f));
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        BigInteger a = this.baseContent(r);
        BigInteger b = this.baseContent(q);
        BigInteger c = this.gcd(a, b);
        r = this.divide(r, a);
        q = this.divide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply((GenPolynomial<BigInteger>)((Object)c));
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply((GenPolynomial<BigInteger>)((Object)c));
        }
        BigInteger ac = (BigInteger)((GenPolynomial)r).leadingBaseCoefficient();
        BigInteger bc = (BigInteger)((GenPolynomial)q).leadingBaseCoefficient();
        BigInteger cc = this.gcd(ac, bc);
        ExpVector rdegv = ((GenPolynomial)r).degreeVector();
        ExpVector qdegv = ((GenPolynomial)q).degreeVector();
        PrimeList primes = new PrimeList(PrimeList.Range.medium);
        int pn = 50;
        GenPolynomial<ModLong> cm = null;
        GenPolynomial<ModLong>[] ecm = null;
        GenPolynomial<ModLong> sm = null;
        GenPolynomial<ModLong> tm = null;
        HenselApprox<ModLong> lift = null;
        if (this.debug) {
            logger.debug((Object)("c = " + c));
            logger.debug((Object)("cc = " + cc));
            logger.debug((Object)("primes = " + primes));
        }
        int i = 0;
        for (java.math.BigInteger p : primes) {
            GenPolynomial<ModLong> cmf;
            AbelianGroupElem<GenPolynomial<BigInteger>> crq;
            GenPolynomial<ModLong> rm;
            GenPolynomialRing<ModLong> mfac;
            GenPolynomial<ModLong> qm;
            if (++i >= pn) {
                logger.error((Object)("prime list exhausted, pn = " + pn));
                return this.iufd.baseGcd(P, S);
            }
            Iterable<ModLong> cofac = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
            GcdRingElem nf = (GcdRingElem)cofac.fromInteger(cc.getVal());
            if (nf.isZERO() || (nf = (GcdRingElem)cofac.fromInteger(((BigInteger)((GenPolynomial)q).leadingBaseCoefficient()).getVal())).isZERO() || (nf = (GcdRingElem)cofac.fromInteger(((BigInteger)((GenPolynomial)r).leadingBaseCoefficient()).getVal())).isZERO() || !(qm = PolyUtil.fromIntegerCoefficients(mfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)cofac), fac.nvar, fac.tord, fac.getVars()), q)).degreeVector().equals(qdegv) || !(rm = PolyUtil.fromIntegerCoefficients(mfac, r)).degreeVector().equals(rdegv)) continue;
            if (this.debug) {
                logger.info((Object)("cofac = " + cofac.getIntegerModul()));
            }
            if ((cm = qm.gcd(rm)).isConstant()) {
                logger.debug((Object)("cm, constant = " + cm));
                return ((GenPolynomial)fac.getONE()).multiply(c);
            }
            GenPolynomial<ModLong> rmf = rm.divide(cm);
            ecm = cm.egcd(rmf);
            if (ecm[0].isONE()) {
                crq = r;
                cmf = rmf;
                sm = ecm[1];
                tm = ecm[2];
            } else {
                GenPolynomial<ModLong> qmf = qm.divide(cm);
                ecm = cm.egcd(qmf);
                if (ecm[0].isONE()) {
                    crq = q;
                    cmf = qmf;
                    sm = ecm[1];
                    tm = ecm[2];
                } else {
                    logger.info((Object)"both gcd != 1: Hensel not applicable");
                    return this.iufd.baseGcd(P, S);
                }
            }
            BigInteger cn = (BigInteger)((GenPolynomial)crq).maxNorm();
            cn = cn.multiply(((BigInteger)((GenPolynomial)crq).leadingBaseCoefficient()).abs());
            cn = cn.multiply(cn.fromInteger(2L));
            if (this.debug) {
                System.out.println("crq = " + crq);
                System.out.println("cm  = " + cm);
                System.out.println("cmf = " + cmf);
                System.out.println("sm  = " + sm);
                System.out.println("tm  = " + tm);
                System.out.println("cn  = " + cn);
            }
            try {
                lift = this.quadratic ? HenselUtil.liftHenselQuadratic(crq, cn, cm, cmf, sm, tm) : HenselUtil.liftHensel(crq, cn, cm, cmf, sm, tm);
            }
            catch (NoLiftingException nle) {
                logger.info((Object)("giving up on Hensel gcd reverting to Subres gcd " + nle));
                return this.iufd.baseGcd(P, S);
            }
            q = lift.A;
            if (this.debug) {
                System.out.println("q   = " + q);
                System.out.println("qf  = " + lift.B);
            }
            q = this.basePrimitivePart(q);
            if (PolyUtil.baseSparsePseudoRemainder(P, q = ((GenPolynomial)q).multiply((GenPolynomial<BigInteger>)((Object)c)).abs()).isZERO() && PolyUtil.baseSparsePseudoRemainder(S, q).isZERO()) break;
            logger.info((Object)"final devision not successfull");
        }
        return q;
    }

    @Override
    public GenPolynomial<GenPolynomial<BigInteger>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<BigInteger>> P, GenPolynomial<GenPolynomial<BigInteger>> S) {
        GenPolynomial lb;
        AbelianGroupElem<GenPolynomial<BigInteger>> q;
        AbelianGroupElem<GenPolynomial<BigInteger>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        if (this.debug) {
            logger.debug((Object)("degrees: e = " + e + ", f = " + f));
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        GenPolynomial<BigInteger> a = this.ufd.recursiveContent((GenPolynomial<GenPolynomial<BigInteger>>)r);
        GenPolynomial<BigInteger> b = this.ufd.recursiveContent((GenPolynomial<GenPolynomial<BigInteger>>)q);
        GenPolynomial<BigInteger> c = this.ufd.gcd(a, b);
        r = PolyUtil.recursiveDivide(r, a);
        q = PolyUtil.recursiveDivide(q, b);
        a = PolyUtil.basePseudoDivide(a, c);
        b = PolyUtil.basePseudoDivide(b, c);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply(c);
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply(c);
        }
        GenPolynomial la = (GenPolynomial)((GenPolynomial)r).leadingBaseCoefficient();
        GenPolynomial<BigInteger> lc = this.ufd.gcd(la, lb = (GenPolynomial)((GenPolynomial)q).leadingBaseCoefficient());
        if (!lc.isConstant()) {
            GenPolynomial<GenPolynomial<BigInteger>> T = this.iufd.recursiveUnivariateGcd((GenPolynomial<GenPolynomial<BigInteger>>)r, (GenPolynomial<GenPolynomial<BigInteger>>)q);
            T = ((GenPolynomial)T.abs()).multiply(c);
            logger.info((Object)("non monic ldcf (" + lc + ") not implemented: " + T + "= gcd(" + r + "," + q + ") * " + c));
            return T;
        }
        GenPolynomial qs = PolyUtil.switchVariables(q);
        GenPolynomial rs = PolyUtil.switchVariables(r);
        GenPolynomialRing rfac = qs.ring;
        RingFactory rrfac = rfac.coFac;
        GenPolynomialRing cfac = (GenPolynomialRing)rrfac;
        GenPolynomialRing<BigInteger> dfac = cfac.extend(rfac.getVars());
        GenPolynomial qd = PolyUtil.distribute(dfac, qs);
        GenPolynomial<GenPolynomial<BigInteger>> rd = PolyUtil.distribute(dfac, rs);
        BigInteger ac = (BigInteger)rd.leadingBaseCoefficient();
        BigInteger bc = (BigInteger)qd.leadingBaseCoefficient();
        BigInteger cc = this.gcd(ac, bc);
        PrimeList primes = new PrimeList(PrimeList.Range.medium);
        Iterator<java.math.BigInteger> primeIter = primes.iterator();
        int pn = 50;
        GenPolynomial<BigInteger> ce0 = null;
        for (int i = 0; i < 11; ++i) {
            List<GenPolynomial<ModLong>> lift;
            BigInteger gg;
            BigInteger geh;
            BigInteger an;
            GenPolynomial g;
            BigInteger bn;
            GenPolynomial pe;
            GenPolynomial<BigInteger> he;
            AbelianGroupElem<GenPolynomial<BigInteger>> s;
            GenPolynomial<BigInteger> ui;
            GenPolynomial<GenPolynomial<BigInteger>> re0;
            GenPolynomial qe0;
            java.math.BigInteger p = null;
            if (i == 0) {
                primes = new PrimeList(PrimeList.Range.medium);
                primeIter = primes.iterator();
            }
            if (i == 4) {
                primes = new PrimeList(PrimeList.Range.small);
                primeIter = primes.iterator();
                p = primeIter.next();
                p = primeIter.next();
                p = primeIter.next();
                p = primeIter.next();
            }
            if (i == 9) {
                primes = new PrimeList(PrimeList.Range.large);
                primeIter = primes.iterator();
            }
            Object cofac = null;
            int pi = 0;
            while (pi < pn && primeIter.hasNext()) {
                p = primeIter.next();
                logger.info((Object)("prime = " + p));
                Iterable<ModLong> cf = null;
                cf = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
                GcdRingElem nf = (GcdRingElem)cf.fromInteger(cc.getVal());
                if (nf.isZERO() || (nf = (GcdRingElem)cf.fromInteger(((BigInteger)((GenPolynomial)((GenPolynomial)q).leadingBaseCoefficient()).leadingBaseCoefficient()).getVal())).isZERO() || (nf = (GcdRingElem)cf.fromInteger(((BigInteger)((GenPolynomial)((GenPolynomial)r).leadingBaseCoefficient()).leadingBaseCoefficient()).getVal())).isZERO()) continue;
                cofac = cf;
                break;
            }
            if (cofac == null) {
                GenPolynomial<GenPolynomial<BigInteger>> T = this.iufd.recursiveUnivariateGcd((GenPolynomial<GenPolynomial<BigInteger>>)q, (GenPolynomial<GenPolynomial<BigInteger>>)r);
                logger.info((Object)("no lucky prime, gave up on Hensel: " + T + "= gcd(" + r + "," + q + ")"));
                return ((GenPolynomial)T.abs()).multiply(c);
            }
            ArrayList<BigInteger> V = new ArrayList<BigInteger>(P.ring.nvar);
            GenPolynomialRing<BigInteger> ckfac = dfac;
            GenPolynomial<Object> qe = qd;
            GenPolynomial re = rd;
            for (int j = dfac.nvar; j > 1; --j) {
                block38: {
                    BigInteger vii;
                    GenPolynomial<BigInteger> rei;
                    GenPolynomial<BigInteger> qei;
                    long degq = qe.degree(ckfac.nvar - 2);
                    long degr = re.degree(ckfac.nvar - 2);
                    ckfac = ckfac.contract(1);
                    long vi = 1L;
                    if (p.longValue() > 1000L) {
                        vi = 0L;
                    }
                    do {
                        GcdRingElem vp;
                        if ((vp = (GcdRingElem)cofac.fromInteger(vi++)).isZERO() && vi != 1L) {
                            qe = null;
                            re = null;
                            break block38;
                        }
                        vii = new BigInteger(vi - 1L);
                        qei = PolyUtil.evaluateMain(ckfac, qe, vii);
                        rei = PolyUtil.evaluateMain(ckfac, re, vii);
                    } while (degq != qei.degree(ckfac.nvar - 1) || degr != rei.degree(ckfac.nvar - 1));
                    V.add(vii);
                    qe = qei;
                    re = rei;
                }
                if (qe == null && re == null) break;
            }
            if (qe == null && re == null) continue;
            logger.info((Object)("evaluation points  = " + V));
            GenPolynomial<BigInteger> ce = this.ufd.baseGcd(qe, re);
            if (ce.isConstant()) {
                return ((GenPolynomial)P.ring.getONE()).multiply(c);
            }
            logger.info((Object)("base gcd = " + ce));
            if (i == 0) {
                qe0 = qe;
                re0 = re;
                ce0 = ce;
                continue;
            }
            long d0 = ce0.degree(0);
            long d1 = ce.degree(0);
            if (d1 < d0) {
                qe0 = qe;
                re0 = re;
                ce0 = ce;
                continue;
            }
            if (d1 > d0) continue;
            long dx = ((GenPolynomial)r).degree(0);
            if (d0 == dx) {
                if (!PolyUtil.recursivePseudoRemainder(q, r).isZERO()) continue;
                r = ((GenPolynomial)((GenPolynomial)r).abs()).multiply(c);
                logger.info((Object)("exit with r | q : " + r));
                return r;
            }
            BigInteger mn = null;
            GenPolynomial<BigInteger> re1 = PolyUtil.basePseudoDivide(re, ce);
            GenPolynomial<BigInteger> qe1 = PolyUtil.basePseudoDivide(qe, ce);
            GenPolynomial<BigInteger> gcr = this.ufd.baseGcd(re1, ce);
            GenPolynomial<BigInteger> gcq = this.ufd.baseGcd(qe1, ce);
            if (gcr.isONE() && gcq.isONE()) {
                if (la.totalDegree() > lb.totalDegree()) {
                    ui = qd;
                    s = q;
                    he = qe1;
                    pe = qe;
                    bn = (BigInteger)qd.maxNorm();
                    mn = bn.multiply(cc).multiply(new BigInteger(2L));
                    g = lb;
                    logger.debug((Object)"select deg: ui = qd, g = b");
                } else {
                    ui = rd;
                    s = r;
                    he = re1;
                    pe = re;
                    an = (BigInteger)rd.maxNorm();
                    mn = an.multiply(cc).multiply(new BigInteger(2L));
                    g = la;
                    logger.debug((Object)"select deg: ui = rd, g = a");
                }
            } else if (gcr.isONE()) {
                ui = rd;
                s = r;
                he = re1;
                pe = re;
                an = (BigInteger)rd.maxNorm();
                mn = an.multiply(cc).multiply(new BigInteger(2L));
                g = la;
                logger.debug((Object)"select: ui = rd, g = a");
            } else if (gcq.isONE()) {
                ui = qd;
                s = q;
                he = qe1;
                pe = qe;
                bn = (BigInteger)qd.maxNorm();
                mn = bn.multiply(cc).multiply(new BigInteger(2L));
                g = lb;
                logger.debug((Object)"select: ui = qd, g = b");
            } else {
                logger.info((Object)"both gcds != 1: method not applicable");
                break;
            }
            GenPolynomial<BigInteger> lui = lc;
            GenPolynomial<BigInteger> lh = PolyUtil.basePseudoDivide(g, lui);
            BigInteger ge = PolyUtil.evaluateAll(g.ring.coFac, lui, V);
            if (ge.isZERO() || (geh = PolyUtil.evaluateAll(g.ring.coFac, lh, V)).isZERO() || (gg = (BigInteger)PolyUtil.evaluateAll(g.ring.coFac, g, V)).isZERO()) continue;
            he = he.multiply(ge);
            GenPolynomial<BigInteger> gi = lui.extendLower(dfac, 0, 0L);
            ui = ui.multiply((BigInteger)((Object)gi));
            logger.info((Object)("gcd(ldcf): " + lui + ", ldcf cofactor: " + lh + ", base cofactor: " + he));
            long k = Power.logarithm(new BigInteger(p), mn);
            BigInteger qp = Power.positivePower(cofac.getIntegerModul(), k);
            Iterable<ModLong> muqfac = ModLongRing.MAX_LONG.compareTo(qp.getVal()) > 0 ? new ModLongRing(qp.getVal(), true) : new ModIntegerRing(qp.getVal(), true);
            GenPolynomialRing<ModLong> mucpfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)muqfac), ckfac);
            if (((GcdRingElem)muqfac.fromInteger(ge.getVal())).isZERO()) continue;
            GenPolynomial<ModLong> cm = PolyUtil.fromIntegerCoefficients(mucpfac, ce);
            GenPolynomial<ModLong> hm = PolyUtil.fromIntegerCoefficients(mucpfac, he);
            if (cm.degree(0) != ce.degree(0) || hm.degree(0) != he.degree(0) || cm.isZERO() || hm.isZERO()) continue;
            logger.info((Object)("univariate modulo p^k: " + cm + ", " + hm));
            GenPolynomialRing<ModLong> qcfac = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)muqfac), dfac);
            GenPolynomial<ModLong> uq = PolyUtil.fromIntegerCoefficients(qcfac, ui);
            if (!ui.leadingExpVector().equals(uq.leadingExpVector())) {
                logger.info((Object)("ev(ui) = " + ui.leadingExpVector() + ", ev(uq) = " + uq.leadingExpVector()));
                continue;
            }
            logger.info((Object)("multivariate modulo p^k: " + uq));
            ArrayList F = new ArrayList(2);
            F.add(cm);
            F.add(hm);
            ArrayList<GenPolynomial<BigInteger>> G = new ArrayList<GenPolynomial<BigInteger>>(2);
            G.add((GenPolynomial<BigInteger>)lui.ring.getONE());
            G.add((GenPolynomial<BigInteger>)lui.ring.getONE());
            try {
                lift = HenselMultUtil.liftHensel(ui, uq, F, V, k, G);
                logger.info((Object)("lift = " + lift));
            }
            catch (NoLiftingException nle) {
                logger.info((Object)"NoLiftingException");
                continue;
            }
            catch (ArithmeticException ae) {
                logger.info((Object)"ArithmeticException");
                continue;
            }
            catch (NotInvertibleException ni) {
                logger.info((Object)"NotInvertibleException");
                continue;
            }
            GenPolynomial<BigInteger> ci = PolyUtil.integerFromModularCoefficients(dfac, lift.get(0));
            ci = this.basePrimitivePart(ci);
            GenPolynomial Cr = PolyUtil.recursive(rfac, ci);
            GenPolynomial Cs = PolyUtil.switchVariables(Cr);
            if (!Cs.ring.equals(P.ring)) {
                System.out.println("Cs.ring = " + Cs.ring + ", P.ring = " + P.ring);
            }
            GenPolynomial<GenPolynomial<BigInteger>> Q = this.ufd.recursivePrimitivePart(Cs);
            Q = this.ufd.baseRecursivePrimitivePart(Q);
            Q = ((GenPolynomial)Q.abs()).multiply(c);
            GenPolynomial Pq = PolyUtil.recursivePseudoRemainder(P, Q);
            GenPolynomial Sq = PolyUtil.recursivePseudoRemainder(S, Q);
            if (Pq.isZERO() && Sq.isZERO()) {
                logger.info((Object)("gcd normal exit: " + Q));
                return Q;
            }
            logger.info((Object)("bad Q = " + Q));
        }
        GenPolynomial<GenPolynomial<BigInteger>> T = this.iufd.recursiveUnivariateGcd((GenPolynomial<GenPolynomial<BigInteger>>)r, (GenPolynomial<GenPolynomial<BigInteger>>)q);
        T = ((GenPolynomial)T.abs()).multiply(c);
        logger.info((Object)("no lucky prime or evaluation points, gave up on Hensel: " + T + "= gcd(" + r + "," + q + ")"));
        return T;
    }

    GenPolynomial<BigInteger> invertPoly(ModularRingFactory<MOD> mfac, GenPolynomial<BigInteger> li, List<BigInteger> V) {
        if (li == null || li.isZERO()) {
            throw new RuntimeException("li not invertible: " + li);
        }
        if (li.isONE()) {
            return li;
        }
        GenPolynomialRing<BigInteger> pfac = li.ring;
        GenPolynomialRing<MOD> mpfac = new GenPolynomialRing<MOD>(mfac, pfac);
        GenPolynomial<MOD> lm = PolyUtil.fromIntegerCoefficients(mpfac, li);
        ArrayList<GenPolynomial<MOD>> lid = new ArrayList<GenPolynomial<MOD>>(V.size());
        int i = 0;
        for (BigInteger bi : V) {
            GcdRingElem m = (GcdRingElem)mfac.fromInteger(bi.getVal());
            GenPolynomial<Object> mp = mpfac.univariate(i);
            mp = mp.subtract((MOD)m);
            lid.add(mp);
            ++i;
        }
        GenPolynomial<MOD> mi = lm;
        GenPolynomial<BigInteger> inv = PolyUtil.integerFromModularCoefficients(pfac, mi);
        return inv;
    }
}

