/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorRational
extends FactorAbsolute<BigRational> {
    private static final Logger logger = Logger.getLogger(FactorRational.class);
    private final boolean debug = logger.isInfoEnabled();
    protected final FactorAbstract<BigInteger> iengine = FactorFactory.getImplementation(BigInteger.ONE);

    protected FactorRational() {
        super(BigRational.ONE);
    }

    @Override
    public List<GenPolynomial<BigRational>> baseFactorsSquarefree(GenPolynomial<BigRational> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<BigRational>> factors = new ArrayList<GenPolynomial<BigRational>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<BigRational> Pr = P;
        BigRational ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            Pr = Pr.monic();
        }
        BigInteger bi = BigInteger.ONE;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(bi, pfac);
        GenPolynomial<BigInteger> Pi = PolyUtil.integerFromRationalCoefficients(ifac, Pr);
        if (this.debug) {
            logger.info((Object)("Pi = " + Pi));
        }
        List<GenPolynomial<BigInteger>> ifacts = this.iengine.baseFactorsSquarefree(Pi);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ifacts = " + ifacts));
        }
        if (ifacts.size() <= 1) {
            factors.add(P);
            return factors;
        }
        List rfacts = PolyUtil.fromIntegerCoefficients(pfac, ifacts);
        rfacts = PolyUtil.monic(rfacts);
        if (!ldcf.isONE()) {
            GenPolynomial<BigRational> r = rfacts.get(0);
            rfacts.remove(r);
            r = r.multiply(ldcf);
            rfacts.set(0, r);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rfacts = " + rfacts));
        }
        factors.addAll(rfacts);
        return factors;
    }

    @Override
    public List<GenPolynomial<BigRational>> factorsSquarefree(GenPolynomial<BigRational> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<BigRational>> factors = new ArrayList<GenPolynomial<BigRational>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactorsSquarefree(P);
        }
        GenPolynomial<BigRational> Pr = P;
        BigRational ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            Pr = Pr.monic();
        }
        BigInteger bi = BigInteger.ONE;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(bi, pfac);
        GenPolynomial<BigInteger> Pi = PolyUtil.integerFromRationalCoefficients(ifac, Pr);
        if (this.debug) {
            logger.info((Object)("Pi = " + Pi));
        }
        List<GenPolynomial<BigInteger>> ifacts = this.iengine.factorsSquarefree(Pi);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ifacts = " + ifacts));
        }
        if (ifacts.size() <= 1) {
            factors.add(P);
            return factors;
        }
        List rfacts = PolyUtil.fromIntegerCoefficients(pfac, ifacts);
        rfacts = PolyUtil.monic(rfacts);
        if (!ldcf.isONE()) {
            GenPolynomial<BigRational> r = rfacts.get(0);
            rfacts.remove(r);
            r = r.multiply(ldcf);
            rfacts.set(0, r);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rfacts = " + rfacts));
        }
        factors.addAll(rfacts);
        return factors;
    }
}

