/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorQuotient<C extends GcdRingElem<C>>
extends FactorAbstract<Quotient<C>> {
    private static final Logger logger = Logger.getLogger(FactorQuotient.class);
    protected final FactorAbstract<C> nengine;

    protected FactorQuotient() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorQuotient(QuotientRing<C> fac) {
        this(fac, FactorFactory.getImplementation(fac.ring.coFac));
    }

    public FactorQuotient(QuotientRing<C> fac, FactorAbstract<C> nengine) {
        super(fac);
        this.nengine = nengine;
    }

    @Override
    public List<GenPolynomial<Quotient<C>>> baseFactorsSquarefree(GenPolynomial<Quotient<C>> P) {
        return this.factorsSquarefree(P);
    }

    @Override
    public List<GenPolynomial<Quotient<C>>> factorsSquarefree(GenPolynomial<Quotient<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<Quotient<C>>> factors = new ArrayList<GenPolynomial<Quotient<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        GenPolynomial<Quotient<C>> Pr = P;
        Quotient<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            Pr = Pr.monic();
        }
        QuotientRing qi = (QuotientRing)pfac.coFac;
        GenPolynomialRing ci = qi.ring;
        GenPolynomialRing ifac = new GenPolynomialRing(ci, pfac);
        GenPolynomial Pi = PolyUfdUtil.integralFromQuotientCoefficients(ifac, Pr);
        List<GenPolynomial<GenPolynomial<C>>> irfacts = this.nengine.recursiveFactorsSquarefree(Pi);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("irfacts = " + irfacts));
        }
        if (irfacts.size() <= 1) {
            factors.add(P);
            return factors;
        }
        List qfacts = PolyUfdUtil.quotientFromIntegralCoefficients(pfac, irfacts);
        if (!ldcf.isONE()) {
            GenPolynomial<Quotient<Quotient<C>>> r = qfacts.get(0);
            qfacts.remove(r);
            r = r.multiply(ldcf);
            qfacts.add(0, r);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("qfacts = " + qfacts));
        }
        factors.addAll(qfacts);
        return factors;
    }
}

