/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.root.Interval;
import edu.jas.root.Rectangle;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.List;
import org.apache.log4j.Logger;

public class RootUtil {
    private static final Logger logger = Logger.getLogger(RootUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends RingElem<C>> long signVar(List<C> L) {
        long v = 0L;
        if (L == null || L.isEmpty()) {
            return v;
        }
        RingElem A = (RingElem)L.get(0);
        for (int i = 1; i < L.size(); ++i) {
            RingElem B = (RingElem)L.get(i);
            while (B == null || B.signum() == 0) {
                if (++i >= L.size()) {
                    return v;
                }
                B = (RingElem)L.get(i);
            }
            if (A.signum() * B.signum() < 0) {
                ++v;
            }
            A = B;
        }
        return v;
    }

    public static <C extends RingElem<C> & Rational> Interval<C> parseInterval(RingFactory<C> fac, String s) {
        int r = s.length();
        int el = s.indexOf("[");
        if (el >= 0) {
            int ri = s.indexOf("]");
            if (ri > 0) {
                r = ri;
            }
        } else {
            el = -1;
        }
        String iv = s.substring(el + 1, r).trim();
        int k = iv.indexOf(",");
        if (k < 0) {
            k = s.indexOf(" ");
        }
        if (k < 0) {
            RingElem mid = (RingElem)fac.parse(iv);
            return new Interval<RingElem>(mid);
        }
        String ls = iv.substring(0, k).trim();
        String rs = iv.substring(k + 1, iv.length()).trim();
        RingElem left = (RingElem)fac.parse(ls);
        RingElem right = (RingElem)fac.parse(rs);
        if (debug) {
            logger.debug((Object)("Interval: left = " + left + ", right = " + right));
        }
        return new Interval<RingElem>(left, right);
    }

    public static <C extends RingElem<C> & Rational> Rectangle<C> parseRectangle(RingFactory<Complex<C>> fac, String s) {
        int r = s.length();
        int el = s.indexOf("[");
        if (el >= 0) {
            int ri = s.indexOf("]");
            if (ri > 0) {
                r = ri;
            }
        } else {
            el = -1;
        }
        String iv = s.substring(el + 1, r).trim();
        int k = iv.indexOf(",");
        if (k < 0) {
            k = s.indexOf(" ");
        }
        if (k < 0) {
            Complex mid = (Complex)fac.parse(iv);
            return new Rectangle(mid);
        }
        String ls = iv.substring(0, k).trim();
        String rs = iv.substring(k + 1, iv.length()).trim();
        Complex sw = (Complex)fac.parse(ls);
        Complex ne = (Complex)fac.parse(rs);
        if (debug) {
            logger.debug((Object)("Rectangle: sw = " + sw + ", ne = " + ne));
        }
        return new Rectangle(sw, ne);
    }
}

