/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import java.util.ArrayList;
import java.util.List;

class CoeffToRecReAlg<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<C, RealAlgebraicNumber<C>> {
    protected final List<RealAlgebraicRing<C>> lfac;
    final int depth;

    public CoeffToRecReAlg(int depth, RealAlgebraicRing<C> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        RealAlgebraicRing afac = fac;
        this.depth = depth;
        this.lfac = new ArrayList<RealAlgebraicRing<C>>(this.depth);
        this.lfac.add(fac);
        for (int i = 1; i < this.depth; ++i) {
            RingFactory rf = afac.algebraic.ring.coFac;
            if (!(rf instanceof RealAlgebraicRing)) {
                throw new IllegalArgumentException("fac depth to low");
            }
            afac = (RealAlgebraicRing)rf;
            this.lfac.add(afac);
        }
    }

    @Override
    public RealAlgebraicNumber<C> eval(C c) {
        if (c == null) {
            return this.lfac.get(0).getZERO();
        }
        Object ac = c;
        RealAlgebraicRing<C> af = this.lfac.get(this.lfac.size() - 1);
        AbelianGroupElem zero = af.algebraic.ring.getZERO();
        RealAlgebraicNumber<C> an = new RealAlgebraicNumber<C>(af, ((GenPolynomial)zero).sum(ac));
        for (int i = this.lfac.size() - 2; i >= 0; --i) {
            af = this.lfac.get(i);
            zero = af.algebraic.ring.getZERO();
            ac = an;
            an = new RealAlgebraicNumber<C>(af, ((GenPolynomial)zero).sum(ac));
        }
        return an;
    }
}

