/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class CoeffToComplexFromComplex<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<Complex<C>, ComplexAlgebraicNumber<C>> {
    protected final ComplexAlgebraicRing<C> cfac;
    protected final AlgebraicNumber<Complex<C>> zero;

    public CoeffToComplexFromComplex(ComplexAlgebraicRing<C> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.cfac = fac;
        AlgebraicNumberRing afac = this.cfac.algebraic;
        this.zero = afac.getZERO();
    }

    @Override
    public ComplexAlgebraicNumber<C> eval(Complex<C> c) {
        if (c == null) {
            return this.cfac.getZERO();
        }
        return new ComplexAlgebraicNumber<C>(this.cfac, this.zero.sum(c));
    }
}

