/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.ps.Coefficients;
import edu.jas.ps.TaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesMap;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class UnivPowerSeriesRing<C extends RingElem<C>>
implements RingFactory<UnivPowerSeries<C>> {
    protected static final Random random = new Random();
    public static final int DEFAULT_TRUNCATE = 11;
    int truncate;
    public static final String DEFAULT_NAME = "x";
    String var;
    public final RingFactory<C> coFac;
    public final UnivPowerSeries<C> ONE;
    public final UnivPowerSeries<C> ZERO;

    private UnivPowerSeriesRing() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    public UnivPowerSeriesRing(RingFactory<C> coFac) {
        this(coFac, 11, DEFAULT_NAME);
    }

    public UnivPowerSeriesRing(RingFactory<C> coFac, int truncate) {
        this(coFac, truncate, DEFAULT_NAME);
    }

    public UnivPowerSeriesRing(RingFactory<C> coFac, String name) {
        this(coFac, 11, name);
    }

    public UnivPowerSeriesRing(GenPolynomialRing<C> pfac) {
        this(pfac.coFac, 11, pfac.getVars()[0]);
    }

    public UnivPowerSeriesRing(RingFactory<C> cofac, int truncate, String name) {
        this.coFac = cofac;
        this.truncate = truncate;
        this.var = name;
        this.ONE = new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                if (i == 0) {
                    return (RingElem)UnivPowerSeriesRing.this.coFac.getONE();
                }
                return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
            }
        });
        this.ZERO = new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public UnivPowerSeries<C> fixPoint(UnivPowerSeriesMap<C> map) {
        UnivPowerSeries ps1 = new UnivPowerSeries(this);
        UnivPowerSeries<C> ps2 = map.map(ps1);
        ps1.lazyCoeffs = ps2.lazyCoeffs;
        return ps2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String scf = this.coFac.getClass().getSimpleName();
        sb.append(scf + "((" + this.var + "))");
        return sb.toString();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer("PS(");
        String f = null;
        try {
            f = ((RingElem)((Object)this.coFac)).toScriptFactory();
        }
        catch (Exception e) {
            f = this.coFac.toScript();
        }
        s.append(f + ",\"" + this.var + "\"," + this.truncate + ")");
        return s.toString();
    }

    public boolean equals(Object B) {
        UnivPowerSeriesRing a = null;
        try {
            a = (UnivPowerSeriesRing)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.coFac.equals(a.coFac)) {
            return false;
        }
        return this.var.equals(a.var);
    }

    public int hashCode() {
        int h = this.coFac.hashCode();
        h += this.var.hashCode() << 27;
        return h += this.truncate;
    }

    @Override
    public UnivPowerSeries<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public UnivPowerSeries<C> getONE() {
        return this.ONE;
    }

    @Override
    public List<UnivPowerSeries<C>> generators() {
        List rgens = this.coFac.generators();
        ArrayList<UnivPowerSeries<C>> gens = new ArrayList<UnivPowerSeries<C>>(rgens.size());
        for (final RingElem cg : rgens) {
            UnivPowerSeries g = new UnivPowerSeries(this, new Coefficients<C>(){

                @Override
                public C generate(int i) {
                    if (i == 0) {
                        return cg;
                    }
                    return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
                }
            });
            gens.add(g);
        }
        gens.add(this.ONE.shift(1));
        return gens;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    public UnivPowerSeries<C> getEXP() {
        return this.fixPoint(new UnivPowerSeriesMap<C>(){

            @Override
            public UnivPowerSeries<C> map(UnivPowerSeries<C> e) {
                return e.integrate((RingElem)UnivPowerSeriesRing.this.coFac.getONE());
            }
        });
    }

    public UnivPowerSeries<C> getSIN() {
        return this.fixPoint(new UnivPowerSeriesMap<C>(){

            @Override
            public UnivPowerSeries<C> map(UnivPowerSeries<C> s) {
                return ((UnivPowerSeries)s.negate()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getONE()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getZERO());
            }
        });
    }

    public UnivPowerSeries<C> getCOS() {
        return this.fixPoint(new UnivPowerSeriesMap<C>(){

            @Override
            public UnivPowerSeries<C> map(UnivPowerSeries<C> c) {
                return ((UnivPowerSeries)c.negate()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getZERO()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getONE());
            }
        });
    }

    public UnivPowerSeries<C> getTAN() {
        return this.fixPoint(new UnivPowerSeriesMap<C>(){

            @Override
            public UnivPowerSeries<C> map(UnivPowerSeries<C> t) {
                return t.multiply(t).sum((UnivPowerSeries)UnivPowerSeriesRing.this.getONE()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getZERO());
            }
        });
    }

    public UnivPowerSeries<C> solveODE(UnivPowerSeries<C> f, C c) {
        return f.integrate(c);
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    @Override
    public UnivPowerSeries<C> fromInteger(long a) {
        return this.ONE.multiply((RingElem)this.coFac.fromInteger(a));
    }

    @Override
    public UnivPowerSeries<C> fromInteger(BigInteger a) {
        return this.ONE.multiply((RingElem)this.coFac.fromInteger(a));
    }

    public GenPolynomialRing<C> polyRing() {
        return new GenPolynomialRing<C>(this.coFac, 1, new String[]{this.var});
    }

    public UnivPowerSeries<C> fromPolynomial(GenPolynomial<C> a) {
        if (a == null || a.isZERO()) {
            return this.ZERO;
        }
        if (a.isONE()) {
            return this.ONE;
        }
        if (a.ring.nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        HashMap<Integer, C> cache = new HashMap<Integer, C>(a.length());
        for (Monomial<C> m : a) {
            long e = m.exponent().getVal(0);
            cache.put((int)e, m.coefficient());
        }
        return new UnivPowerSeries(this, new Coefficients<C>(cache){

            @Override
            public C generate(int i) {
                return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public UnivPowerSeries<C> random() {
        return this.random(5, 0.7f, random);
    }

    @Override
    public UnivPowerSeries<C> random(int k) {
        return this.random(k, 0.7f, random);
    }

    @Override
    public UnivPowerSeries<C> random(int k, Random rnd) {
        return this.random(k, 0.7f, rnd);
    }

    public UnivPowerSeries<C> random(int k, float d) {
        return this.random(k, d, random);
    }

    public UnivPowerSeries<C> random(final int k, final float d, final Random rnd) {
        return new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                float f = rnd.nextFloat();
                RingElem c = f < d ? (RingElem)UnivPowerSeriesRing.this.coFac.random(k, rnd) : (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
                return c;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> copy(UnivPowerSeries<C> c) {
        return new UnivPowerSeries(this, c.lazyCoeffs);
    }

    @Override
    public UnivPowerSeries<C> parse(String s) {
        throw new UnsupportedOperationException("parse for power series not implemented");
    }

    @Override
    public UnivPowerSeries<C> parse(Reader r) {
        throw new UnsupportedOperationException("parse for power series not implemented");
    }

    public UnivPowerSeries<C> seriesOfTaylor(final TaylorFunction<C> f, C a) {
        return new UnivPowerSeries(this, new Coefficients<C>((RingElem)a){
            TaylorFunction<C> der;
            long k;
            long n;
            final /* synthetic */ RingElem val$a;
            {
                this.val$a = ringElem;
                this.der = f;
                this.k = 0L;
                this.n = 1L;
            }

            @Override
            public C generate(int i) {
                Object c2;
                if (i == 0) {
                    RingElem c2 = this.der.evaluate(this.val$a);
                    this.der = this.der.deriviative();
                    return c2;
                }
                if (i > 0) {
                    c2 = this.get(i - 1);
                }
                ++this.k;
                this.n *= this.k;
                c2 = this.der.evaluate(this.val$a);
                c2 = (RingElem)c2.divide((MonoidElem)((MonoidElem)UnivPowerSeriesRing.this.coFac.fromInteger(this.n)));
                this.der = this.der.deriviative();
                return c2;
            }
        });
    }
}

