/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.ps.Coefficients;
import edu.jas.ps.Multiply;
import edu.jas.ps.Negate;
import edu.jas.ps.Subtract;
import edu.jas.ps.Sum;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.BinaryFunctor;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.Selector;
import edu.jas.structure.UnaryFunctor;

public class UnivPowerSeries<C extends RingElem<C>>
implements RingElem<UnivPowerSeries<C>> {
    public final UnivPowerSeriesRing<C> ring;
    Coefficients<C> lazyCoeffs;
    private int truncate = 11;
    private int order = -1;

    private UnivPowerSeries() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    UnivPowerSeries(UnivPowerSeriesRing<C> ring) {
        this.ring = ring;
        this.lazyCoeffs = null;
    }

    public UnivPowerSeries(UnivPowerSeriesRing<C> ring, Coefficients<C> lazyCoeffs) {
        if (lazyCoeffs == null || ring == null) {
            throw new IllegalArgumentException("null not allowed: ring = " + ring + ", lazyCoeffs = " + lazyCoeffs);
        }
        this.ring = ring;
        this.lazyCoeffs = lazyCoeffs;
        this.truncate = ring.truncate;
    }

    @Override
    public UnivPowerSeriesRing<C> factory() {
        return this.ring;
    }

    @Override
    public UnivPowerSeries<C> copy() {
        return new UnivPowerSeries<C>(this.ring, this.lazyCoeffs);
    }

    public String toString() {
        return this.toString(this.truncate);
    }

    public String toString(int truncate) {
        StringBuffer sb = new StringBuffer();
        UnivPowerSeries s = this;
        String var = this.ring.var;
        for (int i = 0; i < truncate; ++i) {
            Object c = s.coefficient(i);
            int si = c.signum();
            if (si == 0) continue;
            if (si > 0) {
                if (sb.length() > 0) {
                    sb.append(" + ");
                }
            } else {
                c = (RingElem)c.negate();
                sb.append(" - ");
            }
            if (!c.isONE() || i == 0) {
                if (c instanceof GenPolynomial || c instanceof AlgebraicNumber) {
                    sb.append("{ ");
                }
                sb.append(c.toString());
                if (c instanceof GenPolynomial || c instanceof AlgebraicNumber) {
                    sb.append(" }");
                }
                if (i > 0) {
                    sb.append(" * ");
                }
            }
            if (i == 0) continue;
            if (i == 1) {
                sb.append(var);
                continue;
            }
            sb.append(var + "^" + i);
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        sb.append(" + BigO(" + var + "^" + truncate + ")");
        return sb.toString();
    }

    @Override
    public String toScript() {
        StringBuffer sb = new StringBuffer("");
        UnivPowerSeries s = this;
        String var = this.ring.var;
        for (int i = 0; i < this.truncate; ++i) {
            Object c = s.coefficient(i);
            int si = c.signum();
            if (si == 0) continue;
            if (si > 0) {
                if (sb.length() > 0) {
                    sb.append(" + ");
                }
            } else {
                c = (RingElem)c.negate();
                sb.append(" - ");
            }
            if (!c.isONE() || i == 0) {
                if (c instanceof GenPolynomial || c instanceof AlgebraicNumber) {
                    sb.append("{ ");
                }
                sb.append(c.toScript());
                if (c instanceof GenPolynomial || c instanceof AlgebraicNumber) {
                    sb.append(" }");
                }
                if (i > 0) {
                    sb.append(" * ");
                }
            }
            if (i == 0) continue;
            if (i == 1) {
                sb.append(var);
                continue;
            }
            sb.append(var + "**" + i);
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        return sb.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((UnivPowerSeriesRing)this.factory()).toScript();
    }

    public C coefficient(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index not allowed");
        }
        return this.lazyCoeffs.get(index);
    }

    public GenPolynomial<C> asPolynomial() {
        GenPolynomial<C> p = this.ring.polyRing().getZERO();
        for (int i = 0; i <= this.truncate; ++i) {
            C c = this.coefficient(i);
            ExpVector e = ExpVector.create(1, 0, i);
            p = p.sum(c, e);
        }
        return p;
    }

    public C leadingCoefficient() {
        return this.coefficient(0);
    }

    public UnivPowerSeries<C> reductum() {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                return UnivPowerSeries.this.coefficient(i + 1);
            }
        });
    }

    public UnivPowerSeries<C> prepend(C h) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>((RingElem)h){
            final /* synthetic */ RingElem val$h;
            {
                this.val$h = ringElem;
            }

            @Override
            public C generate(int i) {
                if (i == 0) {
                    return this.val$h;
                }
                return UnivPowerSeries.this.coefficient(i - 1);
            }
        });
    }

    public UnivPowerSeries<C> shift(final int k) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                if (i - k < 0) {
                    return (RingElem)UnivPowerSeries.this.ring.coFac.getZERO();
                }
                return UnivPowerSeries.this.coefficient(i - k);
            }
        });
    }

    public UnivPowerSeries<C> select(final Selector<? super C> sel) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                Object c = UnivPowerSeries.this.coefficient(i);
                if (sel.select(c)) {
                    return c;
                }
                return (RingElem)UnivPowerSeries.this.ring.coFac.getZERO();
            }
        });
    }

    public UnivPowerSeries<C> shiftSelect(final Selector<? super C> sel) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){
            int pos = 0;

            @Override
            public C generate(int i) {
                Object c;
                if (i > 0) {
                    Object c2 = this.get(i - 1);
                }
                while (!sel.select(c = UnivPowerSeries.this.coefficient(this.pos++))) {
                }
                return c;
            }
        });
    }

    public UnivPowerSeries<C> map(final UnaryFunctor<? super C, C> f) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                return (RingElem)f.eval(UnivPowerSeries.this.coefficient(i));
            }
        });
    }

    public <C2 extends RingElem<C2>> UnivPowerSeries<C> zip(final BinaryFunctor<? super C, ? super C2, C> f, final UnivPowerSeries<C2> ps) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                return (RingElem)f.eval(UnivPowerSeries.this.coefficient(i), ps.coefficient(i));
            }
        });
    }

    @Override
    public UnivPowerSeries<C> sum(UnivPowerSeries<C> ps) {
        return this.zip(new Sum(), ps);
    }

    @Override
    public UnivPowerSeries<C> subtract(UnivPowerSeries<C> ps) {
        return this.zip(new Subtract(), ps);
    }

    @Override
    public UnivPowerSeries<C> multiply(C c) {
        return this.map(new Multiply<C>(c));
    }

    @Override
    public UnivPowerSeries<C> negate() {
        return this.map(new Negate());
    }

    @Override
    public UnivPowerSeries<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public C evaluate(C e) {
        RingElem v = this.coefficient(0);
        Object p = e;
        for (int i = 1; i < this.truncate; ++i) {
            RingElem c = (RingElem)this.coefficient(i).multiply(p);
            v = v.sum((RingElem)c);
            p = (RingElem)p.multiply(e);
        }
        return (C)v;
    }

    public int order() {
        if (this.order < 0) {
            for (int i = 0; i <= this.truncate; ++i) {
                if (this.coefficient(i).isZERO()) continue;
                this.order = i;
                return this.order;
            }
            this.order = this.truncate + 1;
        }
        return this.order;
    }

    public int truncate() {
        return this.truncate;
    }

    public int setTruncate(int t) {
        if (t < 0) {
            throw new IllegalArgumentException("negative truncate not allowed");
        }
        int ot = this.truncate;
        this.truncate = t;
        return ot;
    }

    @Override
    public int signum() {
        return this.coefficient(this.order()).signum();
    }

    @Override
    public int compareTo(UnivPowerSeries<C> ps) {
        int n;
        int m = this.order();
        int pos = m <= (n = ps.order()) ? m : n;
        int s = 0;
        while ((s = this.coefficient(pos).compareTo(ps.coefficient(pos))) == 0 && ++pos <= this.truncate) {
        }
        return s;
    }

    @Override
    public boolean isZERO() {
        return this.compareTo(this.ring.ZERO) == 0;
    }

    @Override
    public boolean isONE() {
        return this.compareTo(this.ring.ONE) == 0;
    }

    @Override
    public boolean equals(Object B) {
        UnivPowerSeries a = null;
        try {
            a = (UnivPowerSeries)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i = 0; i <= this.truncate; ++i) {
            h += this.coefficient(i).hashCode();
            h <<= 23;
        }
        return h;
    }

    @Override
    public boolean isUnit() {
        return this.leadingCoefficient().isUnit();
    }

    @Override
    public UnivPowerSeries<C> multiply(final UnivPowerSeries<C> ps) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                RingElem c = null;
                for (int k = 0; k <= i; ++k) {
                    RingElem m = (RingElem)UnivPowerSeries.this.coefficient(k).multiply(ps.coefficient(i - k));
                    c = c == null ? m : c.sum(m);
                }
                return c;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> inverse() {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                RingElem d = (RingElem)UnivPowerSeries.this.leadingCoefficient().inverse();
                if (i == 0) {
                    return d;
                }
                MonoidElem c = null;
                for (int k = 0; k < i; ++k) {
                    RingElem m = (RingElem)this.get(k).multiply(UnivPowerSeries.this.coefficient(i - k));
                    c = c == null ? m : c.sum(m);
                }
                c = (RingElem)c.multiply((MonoidElem)d.negate());
                return c;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> divide(UnivPowerSeries<C> ps) {
        int n;
        if (ps.isUnit()) {
            return this.multiply((UnivPowerSeries<C>)ps.inverse());
        }
        int m = this.order();
        if (m < (n = ps.order())) {
            return this.ring.getZERO();
        }
        if (!ps.coefficient(n).isUnit()) {
            throw new ArithmeticException("division by non unit coefficient " + ps.coefficient(n) + ", n = " + n);
        }
        UnivPowerSeries<C> st = m == 0 ? this : this.shift(-m);
        UnivPowerSeries<C> sps = n == 0 ? ps : ps.shift(-n);
        UnivPowerSeries<C> q = st.multiply((UnivPowerSeries<C>)sps.inverse());
        UnivPowerSeries<C> sq = m == n ? q : q.shift(m - n);
        return sq;
    }

    @Override
    public UnivPowerSeries<C> remainder(UnivPowerSeries<C> ps) {
        int n;
        int m = this.order();
        if (m >= (n = ps.order())) {
            return this.ring.getZERO();
        }
        return this;
    }

    public UnivPowerSeries<C>[] quotientRemainder(UnivPowerSeries<C> S) {
        return new UnivPowerSeries[]{this.divide(S), this.remainder(S)};
    }

    public UnivPowerSeries<C> differentiate() {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                MonoidElem v = UnivPowerSeries.this.coefficient(i + 1);
                v = (RingElem)v.multiply((MonoidElem)((MonoidElem)UnivPowerSeries.this.ring.coFac.fromInteger(i + 1)));
                return v;
            }
        });
    }

    public UnivPowerSeries<C> integrate(C c) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>((RingElem)c){
            final /* synthetic */ RingElem val$c;
            {
                this.val$c = ringElem;
            }

            @Override
            public C generate(int i) {
                if (i == 0) {
                    return this.val$c;
                }
                MonoidElem v = UnivPowerSeries.this.coefficient(i - 1);
                v = (RingElem)v.divide((MonoidElem)((MonoidElem)UnivPowerSeries.this.ring.coFac.fromInteger(i)));
                return v;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> gcd(UnivPowerSeries<C> ps) {
        int n;
        if (ps.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return ps;
        }
        int m = this.order();
        int ll = m < (n = ps.order()) ? m : n;
        return ((UnivPowerSeries)this.ring.getONE()).shift(ll);
    }

    public UnivPowerSeries<C>[] egcd(UnivPowerSeries<C> S) {
        throw new UnsupportedOperationException("egcd for power series not implemented");
    }
}

