/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TableRelation;
import edu.jas.structure.RingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class RecSolvablePolynomial<C extends RingElem<C>>
extends GenSolvablePolynomial<GenPolynomial<C>> {
    public final RecSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(RecSolvablePolynomial.class);
    private final boolean debug = logger.isDebugEnabled();

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> r) {
        super(r);
        this.ring = r;
    }

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> r, ExpVector e) {
        this(r);
        this.val.put(e, this.ring.getONECoefficient());
    }

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> r, GenPolynomial<C> c, ExpVector e) {
        this(r);
        if (c != null && !c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> r, GenPolynomial<C> c) {
        this(r, c, r.evzero);
    }

    public RecSolvablePolynomial(RecSolvablePolynomialRing<C> r, GenSolvablePolynomial<GenPolynomial<C>> S) {
        this(r, S.val);
    }

    protected RecSolvablePolynomial(RecSolvablePolynomialRing<C> r, SortedMap<ExpVector, GenPolynomial<C>> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public RecSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public RecSolvablePolynomial<C> copy() {
        return new RecSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof RecSolvablePolynomial)) {
            return false;
        }
        return super.equals(B);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(RecSolvablePolynomial<C> Bp) {
        if (Bp == null || Bp.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == Bp.ring.nvar);
        if (this.debug) {
            logger.info((Object)("ring = " + this.ring.toScript()));
        }
        ExpVector Z = this.ring.evzero;
        GenPolynomialRing cfac = (GenPolynomialRing)this.ring.coFac;
        ExpVector Zc = cfac.evzero;
        GenSolvablePolynomial Dp = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial zero = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        GenPolynomial one = (GenPolynomial)this.ring.getONECoefficient();
        RecSolvablePolynomial<Object> C1 = null;
        RecSolvablePolynomial<C> C2 = null;
        SortedMap A = this.val;
        SortedMap B = Bp.val;
        Set Bk = B.entrySet();
        if (this.debug) {
            logger.info((Object)("input A = " + this));
        }
        for (Map.Entry y : A.entrySet()) {
            GenPolynomial a = (GenPolynomial)y.getValue();
            ExpVector e = (ExpVector)y.getKey();
            if (this.debug) {
                logger.info((Object)("e = " + e + ", a = " + a));
            }
            int[] ep = e.dependencyOnVariables();
            int el1 = this.ring.nvar + 1;
            if (ep.length > 0) {
                el1 = ep[0];
            }
            if (this.debug) {
                logger.info((Object)("input B = " + Bp));
            }
            for (Map.Entry x : Bk) {
                ExpVector g2;
                ExpVector g1;
                ExpVector g;
                GenPolynomial b = (GenPolynomial)x.getValue();
                ExpVector f = (ExpVector)x.getKey();
                if (this.debug) {
                    logger.info((Object)("f = " + f + ", b = " + b));
                }
                int[] fp = f.dependencyOnVariables();
                int fl1 = 0;
                if (fp.length > 0) {
                    fl1 = fp[fp.length - 1];
                }
                int fl1s = this.ring.nvar + 1 - fl1;
                RecSolvablePolynomial Cps = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
                RecSolvablePolynomial<Object> Cs = null;
                if (this.ring.coeffTable.isEmpty() || b.isConstant() || e.isZERO()) {
                    Cps = new RecSolvablePolynomial(this.ring, b, e);
                    if (this.debug) {
                        logger.info((Object)("symmetric coeff, e*b: b = " + b + ", e = " + e));
                    }
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric coeff, e*b: b = " + b + ", e = " + e));
                    }
                    for (Map.Entry z : b.val.entrySet()) {
                        GenPolynomial c2;
                        RingElem c = (RingElem)z.getValue();
                        GenPolynomial<RingElem> cc = ((GenPolynomial)b.ring.getONE()).multiply(c);
                        g = z.getKey();
                        if (this.debug) {
                            logger.info((Object)("g = " + g + ", c = " + c));
                        }
                        int[] gp = g.dependencyOnVariables();
                        int gl1 = 0;
                        if (gp.length > 0) {
                            gl1 = gp[gp.length - 1];
                        }
                        int gl1s = b.ring.nvar + 1 - gl1;
                        if (this.debug) {
                            logger.info((Object)("gl1s = " + gl1s));
                        }
                        ExpVector e1 = e;
                        ExpVector e2 = Z;
                        if (!e.isZERO()) {
                            e1 = e.subst(el1, 0L);
                            e2 = Z.subst(el1, e.getVal(el1));
                        }
                        g1 = g;
                        g2 = Zc;
                        if (!g.isZERO()) {
                            g1 = g.subst(gl1, 0L);
                            g2 = Zc.subst(gl1, g.getVal(gl1));
                        }
                        if (this.debug) {
                            logger.info((Object)("coeff, e1 = " + e1 + ", e2 = " + e2 + ", Cps = " + Cps));
                            logger.info((Object)("coeff, g1 = " + g1 + ", g2 = " + g2));
                        }
                        TableRelation crel = this.ring.coeffTable.lookup(e2, g2);
                        if (this.debug) {
                            logger.info((Object)("coeff, crel = " + crel.p));
                        }
                        Cs = new RecSolvablePolynomial<RingElem>(this.ring, crel.p);
                        if (crel.f != null) {
                            c2 = ((GenPolynomial)b.ring.getONE()).multiply(crel.f);
                            C2 = new RecSolvablePolynomial<C>(this.ring, c2, Z);
                            Cs = Cs.multiply(C2);
                            ExpVector e4 = crel.e == null ? e2 : e2.subtract(crel.e);
                            this.ring.coeffTable.update(e4, g2, (GenSolvablePolynomial<GenPolynomial<Object>>)Cs);
                        }
                        if (crel.e != null) {
                            C1 = new RecSolvablePolynomial<Object>(this.ring, one, crel.e);
                            Cs = C1.multiply(Cs);
                            this.ring.coeffTable.update(e2, g2, (GenSolvablePolynomial<GenPolynomial<Object>>)Cs);
                        }
                        if (!g1.isZERO()) {
                            c2 = ((GenPolynomial)b.ring.getONE()).multiply(g1);
                            C2 = new RecSolvablePolynomial<C>(this.ring, c2, Z);
                            Cs = Cs.multiply(C2);
                        }
                        if (!e1.isZERO()) {
                            C1 = new RecSolvablePolynomial<C>(this.ring, one, e1);
                            Cs = C1.multiply(Cs);
                        }
                        Cs = Cs.multiplyLeft(cc);
                        Cps = (RecSolvablePolynomial)Cps.sum(Cs);
                    }
                    if (this.debug) {
                        logger.info((Object)("coeff, Cs = " + Cs + ", Cps = " + Cps));
                    }
                }
                if (this.debug) {
                    logger.info((Object)("coeff-poly: Cps = " + Cps));
                }
                GenSolvablePolynomial Dps = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
                GenSolvablePolynomial Ds = null;
                if (this.ring.table.isEmpty() || Cps.isConstant() || f.isZERO()) {
                    if (this.debug) {
                        logger.info((Object)("symmetric poly, P_eb*f: Cps = " + Cps + ", f = " + f));
                    }
                    g = e.sum(f);
                    Ds = Cps.isConstant() ? new RecSolvablePolynomial<C>(this.ring, (GenPolynomial)Cps.leadingBaseCoefficient(), g) : this.shift(Cps, f);
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric poly, P_eb*f: Cps = " + Cps + ", f = " + f));
                    }
                    for (Map.Entry z : Cps.val.entrySet()) {
                        int gl1s;
                        GenPolynomial c = (GenPolynomial)z.getValue();
                        ExpVector g3 = (ExpVector)z.getKey();
                        if (this.debug) {
                            logger.info((Object)("g = " + g3 + ", c = " + c));
                        }
                        int[] gp = g3.dependencyOnVariables();
                        int gl1 = this.ring.nvar + 1;
                        if (gp.length > 0) {
                            gl1 = gp[0];
                        }
                        if ((gl1s = this.ring.nvar + 1 - gl1) <= fl1s) {
                            ExpVector h = g3.sum(f);
                            if (this.debug) {
                                logger.info((Object)("disjoint poly: g = " + g3 + ", f = " + f + ", h = " + h));
                            }
                            Ds = (RecSolvablePolynomial)zero.sum(one, h);
                        } else {
                            RecSolvablePolynomial<C> D1;
                            RecSolvablePolynomial<C> D2;
                            g1 = g3.subst(gl1, 0L);
                            g2 = Z.subst(gl1, g3.getVal(gl1));
                            ExpVector f1 = f.subst(fl1, 0L);
                            ExpVector f2 = Z.subst(fl1, f.getVal(fl1));
                            if (this.debug) {
                                logger.info((Object)("poly, g1 = " + g1 + ", f1 = " + f1 + ", Dps = " + Dps));
                                logger.info((Object)("poly, g2 = " + g2 + ", f2 = " + f2));
                            }
                            TableRelation rel = this.ring.table.lookup(g2, f2);
                            if (this.debug) {
                                logger.info((Object)("poly, g  = " + g3 + ", f  = " + f + ", rel = " + rel));
                            }
                            Ds = new RecSolvablePolynomial<C>(this.ring, rel.p);
                            if (rel.f != null) {
                                D2 = new RecSolvablePolynomial<C>(this.ring, one, rel.f);
                                Ds = ((RecSolvablePolynomial)Ds).multiply(D2);
                                ExpVector g4 = rel.e == null ? g2 : g2.subtract(rel.e);
                                this.ring.table.update(g4, f2, Ds);
                            }
                            if (rel.e != null) {
                                D1 = new RecSolvablePolynomial<C>(this.ring, one, rel.e);
                                Ds = D1.multiply((RecSolvablePolynomial<C>)Ds);
                                this.ring.table.update(g2, f2, Ds);
                            }
                            if (!f1.isZERO()) {
                                D2 = new RecSolvablePolynomial<C>(this.ring, one, f1);
                                Ds = ((RecSolvablePolynomial)Ds).multiply(D2);
                            }
                            if (!g1.isZERO()) {
                                D1 = new RecSolvablePolynomial<C>(this.ring, one, g1);
                                Ds = D1.multiply((RecSolvablePolynomial<C>)Ds);
                            }
                        }
                        Ds = ((RecSolvablePolynomial)Ds).multiplyLeft(c);
                        Dps = (RecSolvablePolynomial)Dps.sum(Ds);
                    }
                    Ds = Dps;
                }
                if (this.debug) {
                    logger.info((Object)("recursion+: Ds = " + Ds + ", a = " + a));
                }
                Ds = ((RecSolvablePolynomial)Ds).multiplyLeft(a);
                if (this.debug) {
                    logger.info((Object)("recursion-: Ds = " + Ds));
                }
                Dp = (RecSolvablePolynomial)Dp.sum(Ds);
                if (!this.debug) continue;
                logger.info((Object)("end B loop: Dp = " + Dp));
            }
            if (!this.debug) continue;
            logger.info((Object)("end A loop: Dp = " + Dp));
        }
        return Dp;
    }

    @Override
    public RecSolvablePolynomial<C> multiply(RecSolvablePolynomial<C> S, RecSolvablePolynomial<C> T) {
        if (S.isZERO() || T.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (S.isONE()) {
            return this.multiply(T);
        }
        if (T.isONE()) {
            return S.multiply(this);
        }
        return S.multiply(this).multiply(T);
    }

    public RecSolvablePolynomial<C> recMultiply(GenPolynomial<C> b) {
        RecSolvablePolynomial<C> Cp = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        Cp = new RecSolvablePolynomial<C>(this.ring, b, this.ring.evzero);
        return this.multiply(Cp);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(GenPolynomial<C> b, GenPolynomial<C> c) {
        GenSolvablePolynomial Cp = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (c == null || c.isZERO()) {
            return Cp;
        }
        RecSolvablePolynomial<C> Cb = new RecSolvablePolynomial<C>(this.ring, b, this.ring.evzero);
        RecSolvablePolynomial<C> Cc = new RecSolvablePolynomial<C>(this.ring, c, this.ring.evzero);
        return Cb.multiply(this).multiply(Cc);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        GenPolynomial b = (GenPolynomial)this.ring.getONECoefficient();
        return this.multiply(b, e);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(ExpVector e, ExpVector f) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (f == null || f.isZERO()) {
            return this;
        }
        GenPolynomial b = (GenPolynomial)this.ring.getONECoefficient();
        return this.multiply(b, e, b, f);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(GenPolynomial<C> b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvablePolynomial<C> Cp = new RecSolvablePolynomial<C>(this.ring, b, e);
        return this.multiply(Cp);
    }

    @Override
    public RecSolvablePolynomial<C> multiply(GenPolynomial<C> b, ExpVector e, GenPolynomial<C> c, ExpVector f) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvablePolynomial<C> Cp = new RecSolvablePolynomial<C>(this.ring, b, e);
        RecSolvablePolynomial<C> Dp = new RecSolvablePolynomial<C>(this.ring, c, f);
        return this.multiply(Cp, Dp);
    }

    @Override
    public RecSolvablePolynomial<C> multiplyLeft(GenPolynomial<C> b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvablePolynomial<C> Cp = new RecSolvablePolynomial<C>(this.ring, b, e);
        return Cp.multiply(this);
    }

    @Override
    public RecSolvablePolynomial<C> multiplyLeft(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        GenPolynomial b = (GenPolynomial)this.ring.getONECoefficient();
        RecSolvablePolynomial<C> Cp = new RecSolvablePolynomial<C>(this.ring, b, e);
        return Cp.multiply(this);
    }

    @Override
    public RecSolvablePolynomial<C> multiplyLeft(GenPolynomial<C> b) {
        GenSolvablePolynomial Cp = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        GenSolvablePolynomial bb = null;
        if (b instanceof GenSolvablePolynomial) {
            logger.debug((Object)"warn: wrong method dispatch in JRE multiply(b) - trying to fix");
            bb = (GenSolvablePolynomial)b;
        }
        SortedMap Cm = ((RecSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            GenPolynomial<GenPolynomial> c;
            ExpVector e = (ExpVector)y.getKey();
            GenPolynomial a = (GenPolynomial)y.getValue();
            if (bb != null) {
                GenSolvablePolynomial aa = (GenSolvablePolynomial)a;
                c = bb.multiply(aa);
            } else {
                c = b.multiply(a);
            }
            if (c.isZERO()) continue;
            Cm.put(e, c);
        }
        return Cp;
    }

    @Override
    public RecSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, GenPolynomial<C>> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(m.getValue(), m.getKey());
    }

    @Override
    public RecSolvablePolynomial<C> multiply(Map.Entry<ExpVector, GenPolynomial<C>> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiply(m.getValue(), m.getKey());
    }

    protected RecSolvablePolynomial<C> shift(RecSolvablePolynomial<C> B, ExpVector f) {
        GenSolvablePolynomial C = ((RecSolvablePolynomial)this.ring.getZERO()).copy();
        if (B == null || B.isZERO()) {
            return C;
        }
        if (f == null || f.isZERO()) {
            return B;
        }
        SortedMap Cm = ((RecSolvablePolynomial)C).val;
        SortedMap Bm = B.val;
        for (Map.Entry y : Bm.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            GenPolynomial a = (GenPolynomial)y.getValue();
            ExpVector d = e.sum(f);
            if (a.isZERO()) continue;
            Cm.put(d, a);
        }
        return C;
    }
}

