/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.QuotientRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class Quotient<C extends RingElem<C>>
implements RingElem<Quotient<C>>,
QuotPair<C> {
    private static final Logger logger = Logger.getLogger(Quotient.class);
    private final boolean debug = logger.isDebugEnabled();
    public final QuotientRing<C> ring;
    public final C num;
    public final C den;

    public Quotient(QuotientRing<C> r) {
        this(r, (RingElem)r.ring.getZERO());
    }

    public Quotient(QuotientRing<C> r, C n) {
        this((QuotientRing<RingElem>)r, (RingElem)n, (RingElem)r.ring.getONE(), true);
    }

    public Quotient(QuotientRing<C> r, C n, C d) {
        this(r, n, d, false);
    }

    protected Quotient(QuotientRing<C> r, C n, C d, boolean isred) {
        if (d == null || d.isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = r;
        if (d.signum() < 0) {
            n = (RingElem)n.negate();
            d = (RingElem)d.negate();
        }
        if (isred) {
            this.num = n;
            this.den = d;
            return;
        }
        if (n instanceof GcdRingElem && d instanceof GcdRingElem) {
            GcdRingElem ng = (GcdRingElem)n;
            GcdRingElem dg = (GcdRingElem)d;
            GcdRingElem gcd = ng.gcd(dg);
            if (this.debug) {
                logger.info((Object)("gcd = " + gcd));
            }
            if (gcd.isONE()) {
                this.num = n;
                this.den = d;
            } else {
                this.num = n.divide((GcdRingElem)gcd);
                this.den = d.divide((GcdRingElem)gcd);
            }
        } else {
            logger.warn((Object)"gcd = ????");
            this.num = n;
            this.den = d;
        }
    }

    @Override
    public QuotientRing<C> factory() {
        return this.ring;
    }

    @Override
    public C numerator() {
        return this.num;
    }

    @Override
    public C denominator() {
        return this.den;
    }

    @Override
    public boolean isConstant() {
        throw new UnsupportedOperationException("isConstant not implemented");
    }

    @Override
    public Quotient<C> copy() {
        return new Quotient<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        return !this.num.isZERO();
    }

    public String toString() {
        return "Quotient[ " + this.num.toString() + " / " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "Quotient( " + this.num.toScript() + " , " + this.den.toScript() + " )";
    }

    @Override
    public String toScriptFactory() {
        return ((QuotientRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Quotient<C> b) {
        if (b == null || b.isZERO()) {
            return this.signum();
        }
        RingElem r = (RingElem)this.num.multiply(b.den);
        RingElem s = (RingElem)this.den.multiply(b.num);
        RingElem x = r.subtract(s);
        return x.signum();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Quotient)) {
            return false;
        }
        Quotient a = null;
        try {
            a = (Quotient)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return 0 == this.compareTo(a);
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.num.hashCode();
        h = 37 * h + this.den.hashCode();
        return h;
    }

    @Override
    public Quotient<C> abs() {
        return new Quotient<RingElem>((QuotientRing<RingElem>)this.ring, (RingElem)this.num.abs(), (RingElem)this.den, true);
    }

    @Override
    public Quotient<C> sum(Quotient<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        RingElem n = (RingElem)this.num.multiply(S.den);
        n = (RingElem)n.sum((AbelianGroupElem)this.den.multiply(S.num));
        RingElem d = (RingElem)this.den.multiply(S.den);
        return new Quotient<RingElem>(this.ring, n, d, false);
    }

    @Override
    public Quotient<C> negate() {
        return new Quotient<RingElem>((QuotientRing<RingElem>)this.ring, (RingElem)this.num.negate(), (RingElem)this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Quotient<C> subtract(Quotient<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        RingElem n = (RingElem)this.num.multiply(S.den);
        n = (RingElem)n.subtract((AbelianGroupElem)this.den.multiply(S.num));
        RingElem d = (RingElem)this.den.multiply(S.den);
        return new Quotient<RingElem>(this.ring, n, d, false);
    }

    @Override
    public Quotient<C> divide(Quotient<C> S) {
        return this.multiply((Quotient<C>)S.inverse());
    }

    @Override
    public Quotient<C> inverse() {
        return new Quotient<C>(this.ring, this.den, this.num, true);
    }

    @Override
    public Quotient<C> remainder(Quotient<C> S) {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        return this.ring.getZERO();
    }

    public Quotient<C>[] quotientRemainder(Quotient<C> S) {
        return new Quotient[]{this.divide(S), this.remainder(S)};
    }

    @Override
    public Quotient<C> multiply(Quotient<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (S.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return S;
        }
        RingElem n = (RingElem)this.num.multiply(S.num);
        RingElem d = (RingElem)this.den.multiply(S.den);
        return new Quotient<RingElem>(this.ring, n, d, false);
    }

    public Quotient<C> monic() {
        logger.info((Object)"monic not implemented");
        return this;
    }

    @Override
    public Quotient<C> gcd(Quotient<C> b) {
        if (b == null || b.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return b;
        }
        if (this.num instanceof GcdRingElem && this.den instanceof GcdRingElem && b.num instanceof GcdRingElem && b.den instanceof GcdRingElem) {
            return this.ring.getONE();
        }
        throw new UnsupportedOperationException("gcd not implemented " + this.num.getClass().getName());
    }

    public Quotient<C>[] egcd(Quotient<C> b) {
        Quotient[] ret = new Quotient[]{null, null, null};
        if (b == null || b.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = b;
            return ret;
        }
        if (this.num instanceof GcdRingElem && this.den instanceof GcdRingElem && b.num instanceof GcdRingElem && b.den instanceof GcdRingElem) {
            Element two = this.ring.fromInteger(2L);
            ret[0] = this.ring.getONE();
            ret[1] = this.multiply((Quotient<C>)two).inverse();
            ret[2] = b.multiply((Quotient<C>)two).inverse();
            return ret;
        }
        throw new UnsupportedOperationException("egcd not implemented " + this.num.getClass().getName());
    }
}

