/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PreemptStatus;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public final class GenWordPolynomialRing<C extends RingElem<C>>
implements RingFactory<GenWordPolynomial<C>> {
    public final RingFactory<C> coFac;
    public final WordFactory alphabet;
    public final GenWordPolynomial<C> ZERO;
    public final GenWordPolynomial<C> ONE;
    public final Word wone;
    static final Random random = new Random();
    private int isField = -1;
    private static final Logger logger = Logger.getLogger(GenWordPolynomialRing.class);
    final boolean checkPreempt = PreemptStatus.isAllowed();

    public GenWordPolynomialRing(RingFactory<C> cf, WordFactory wf) {
        this.coFac = cf;
        this.alphabet = wf;
        this.ZERO = new GenWordPolynomial(this);
        RingElem coeff = (RingElem)this.coFac.getONE();
        this.wone = wf.getONE();
        this.ONE = new GenWordPolynomial<RingElem>(this, coeff, this.wone);
    }

    public GenWordPolynomialRing(RingFactory<C> cf, GenWordPolynomialRing o) {
        this(cf, o.alphabet);
    }

    public GenWordPolynomialRing(GenPolynomialRing<C> fac) {
        this(fac.coFac, new WordFactory(fac.vars));
    }

    public GenWordPolynomialRing<C> copy() {
        return new GenWordPolynomialRing<C>(this.coFac, this);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("WordPolyRing(");
        if (this.coFac instanceof RingElem) {
            s.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            s.append(this.coFac.toString().trim());
        }
        s.append(",");
        s.append(this.alphabet.toString());
        s.append(")");
        return s.toString();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("WordPolyRing.new(");
                break;
            }
            default: {
                s.append("WordPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            s.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            s.append(this.coFac.toScript().trim());
        }
        s.append(",");
        s.append(this.alphabet.toScript());
        s.append(")");
        return s.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof GenWordPolynomialRing)) {
            return false;
        }
        GenWordPolynomialRing oring = null;
        try {
            oring = (GenWordPolynomialRing)other;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (oring == null) {
            return false;
        }
        if (!this.coFac.equals(oring.coFac)) {
            return false;
        }
        return this.alphabet.equals(oring.alphabet);
    }

    public int hashCode() {
        int h = this.coFac.hashCode() << 11;
        return h += this.alphabet.hashCode();
    }

    public String getVars() {
        return this.alphabet.getVal();
    }

    public C getZEROCoefficient() {
        return (C)((RingElem)this.coFac.getZERO());
    }

    public C getONECoefficient() {
        return (C)((RingElem)this.coFac.getONE());
    }

    @Override
    public GenWordPolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenWordPolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative() && this.alphabet.isFinite();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isFinite() {
        return this.alphabet.isFinite() && this.coFac.isFinite();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.coFac.isField() && this.alphabet.isFinite()) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public GenWordPolynomial<C> valueOf(C a) {
        return new GenWordPolynomial<C>(this, a);
    }

    public GenWordPolynomial<C> valueOf(Word e) {
        return new GenWordPolynomial<RingElem>(this, (RingElem)this.coFac.getONE(), e);
    }

    public GenWordPolynomial<C> valueOf(C a, Word e) {
        return new GenWordPolynomial<C>(this, a, e);
    }

    public GenWordPolynomial<C> valueOf(GenPolynomial<C> a) {
        if (a.isZERO()) {
            return this.getZERO();
        }
        if (a.isONE()) {
            return this.getONE();
        }
        Element p = ((GenWordPolynomial)this.getZERO()).copy();
        for (Map.Entry m : a.val.entrySet()) {
            RingElem c = (RingElem)m.getValue();
            ExpVector e = m.getKey();
            Word w = this.alphabet.valueOf(e);
            ((GenWordPolynomial)p).doPutToMap(w, c);
        }
        return p;
    }

    public List<GenWordPolynomial<C>> valueOf(List<GenPolynomial<C>> A) {
        ArrayList<GenWordPolynomial<C>> B = new ArrayList<GenWordPolynomial<C>>(A.size());
        if (A.isEmpty()) {
            return B;
        }
        for (GenPolynomial<C> a : A) {
            GenWordPolynomial<C> b = this.valueOf(a);
            B.add(b);
        }
        return B;
    }

    @Override
    public GenWordPolynomial<C> fromInteger(long a) {
        return new GenWordPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.wone);
    }

    @Override
    public GenWordPolynomial<C> fromInteger(BigInteger a) {
        return new GenWordPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.wone);
    }

    @Override
    public GenWordPolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public GenWordPolynomial<C> random(int n, Random rnd) {
        return this.random(5, n, 3, rnd);
    }

    public GenWordPolynomial<C> random(int k, int l, int d) {
        return this.random(k, l, d, random);
    }

    public GenWordPolynomial<C> random(int k, int l, int d, Random rnd) {
        GenWordPolynomial<RingElem> r = this.getZERO();
        for (int i = 0; i < l; ++i) {
            int di = Math.abs(rnd.nextInt() % d);
            Word e = this.alphabet.random(di, rnd);
            RingElem a = (RingElem)this.coFac.random(k, rnd);
            r = r.sum(a, e);
        }
        return r;
    }

    @Override
    public GenWordPolynomial<C> copy(GenWordPolynomial<C> c) {
        return new GenWordPolynomial(this, c.val);
    }

    @Override
    public GenWordPolynomial<C> parse(String s) {
        String val = s;
        if (!s.contains("|")) {
            val = val.replace("{", "").replace("}", "");
        }
        return this.parse(new StringReader(val));
    }

    @Override
    public GenWordPolynomial<C> parse(Reader r) {
        logger.error((Object)"parse not implemented");
        throw new UnsupportedOperationException("not implemented");
    }

    public GenWordPolynomial<C> univariate(int i) {
        GenWordPolynomial<RingElem> p = this.getZERO();
        List<Word> wgen = this.alphabet.generators();
        if (0 <= i && i < wgen.size()) {
            RingElem one = (RingElem)this.coFac.getONE();
            Word f = wgen.get(i);
            p = p.sum(one, f);
        }
        return p;
    }

    public List<GenWordPolynomial<C>> univariateList() {
        int n = this.alphabet.length();
        ArrayList<GenWordPolynomial<C>> pols = new ArrayList<GenWordPolynomial<C>>(n);
        for (int i = 0; i < n; ++i) {
            GenWordPolynomial<C> p = this.univariate(i);
            pols.add(p);
        }
        return pols;
    }

    public List<GenWordPolynomial<C>> getGenerators() {
        List<GenWordPolynomial<C>> univs = this.univariateList();
        ArrayList<GenWordPolynomial<C>> gens = new ArrayList<GenWordPolynomial<C>>(univs.size() + 1);
        gens.add((GenWordPolynomial<C>)this.getONE());
        gens.addAll(univs);
        return gens;
    }

    @Override
    public List<GenWordPolynomial<C>> generators() {
        List cogens = this.coFac.generators();
        List<GenWordPolynomial<C>> univs = this.univariateList();
        ArrayList<GenWordPolynomial<C>> gens = new ArrayList<GenWordPolynomial<C>>(univs.size() + cogens.size());
        for (RingElem c : cogens) {
            gens.add(((GenWordPolynomial)this.getONE()).multiply(c));
        }
        gens.addAll(univs);
        return gens;
    }
}

