/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;

public class Examples {
    public static void main(String[] args) {
        Examples.example7();
        Examples.example7();
    }

    public static void example0() {
        BigInteger z = new BigInteger();
        TermOrder to = new TermOrder();
        String[] vars = new String[]{"x1", "x2", "x3"};
        GenPolynomialRing<BigInteger> ring = new GenPolynomialRing<BigInteger>(z, 3, to, vars);
        System.out.println("ring = " + ring);
        Element pol = ring.parse("3 x1^2 x3^4 + 7 x2^5 - 61");
        System.out.println("pol = " + pol);
        System.out.println("pol = " + ((GenPolynomial)pol).toString(ring.getVars()));
        Element one = ring.parse("1");
        System.out.println("one = " + one);
        System.out.println("one = " + ((GenPolynomial)one).toString(ring.getVars()));
        GenPolynomial<Element> p = ((GenPolynomial)pol).subtract(pol);
        System.out.println("p = " + p);
        System.out.println("p = " + p.toString(ring.getVars()));
        p = ((GenPolynomial)pol).multiply(pol);
        System.out.println("p = " + p);
        System.out.println("p = " + p.toString(ring.getVars()));
    }

    public static void example1() {
        System.out.println("\n\n example 1");
        BigRational cfac = new BigRational();
        System.out.println("cfac = " + cfac);
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(cfac, 7);
        System.out.println("fac = " + fac);
        Element a = fac.random(10);
        System.out.println("a = " + a);
    }

    public static void example2() {
        System.out.println("\n\n example 2");
        BigRational cfac = new BigRational();
        System.out.println("cfac = " + cfac);
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(cfac, 7);
        System.out.println("fac = " + fac);
        GenPolynomialRing<BigRational> gfac = new GenPolynomialRing<BigRational>(fac, 3);
        System.out.println("gfac = " + gfac);
        Element a = gfac.random(10);
        System.out.println("a = " + a);
    }

    public static void example3() {
        System.out.println("\n\n example 3");
        BigRational cfac = new BigRational();
        System.out.println("cfac = " + cfac);
        GenPolynomialRing<BigRational> mfac = new GenPolynomialRing<BigRational>(cfac, 1);
        System.out.println("mfac = " + mfac);
        GenPolynomial modul = ((GenPolynomial)mfac.random(8)).monic();
        System.out.println("modul = " + modul);
        AlgebraicNumberRing fac = new AlgebraicNumberRing(modul);
        System.out.println("fac = " + fac);
        Element a = fac.random(15);
        System.out.println("a = " + a);
    }

    protected static long getPrime() {
        long prime = 2L;
        for (int i = 1; i < 60; ++i) {
            prime *= 2L;
        }
        return prime -= 93L;
    }

    public static void example4() {
        System.out.println("\n\n example 4");
        long prime = Examples.getPrime();
        ModIntegerRing cfac = new ModIntegerRing(prime);
        System.out.println("cfac = " + cfac);
        GenPolynomialRing<ModInteger> mfac = new GenPolynomialRing<ModInteger>(cfac, 1);
        System.out.println("mfac = " + mfac);
        GenPolynomial modul = ((GenPolynomial)mfac.random(8)).monic();
        System.out.println("modul = " + modul);
        AlgebraicNumberRing fac = new AlgebraicNumberRing(modul);
        System.out.println("fac = " + fac);
        Element a = fac.random(12);
        System.out.println("a = " + a);
    }

    public static void example5() {
        System.out.println("\n\n example 5");
        BigRational cfac = new BigRational();
        System.out.println("cfac = " + cfac);
        GenSolvablePolynomialRing<BigRational> sfac = new GenSolvablePolynomialRing<BigRational>(cfac, 6);
        WeylRelations wl = new WeylRelations();
        sfac.addRelations(wl);
        System.out.println("sfac = " + sfac);
        GenPolynomial a = sfac.random(5);
        System.out.println("a = " + a);
        System.out.println("a = " + a.toString(sfac.vars));
        GenSolvablePolynomial<GenPolynomial> b = ((GenSolvablePolynomial)a).multiply(a);
        System.out.println("b = " + b);
        System.out.println("b = " + b.toString(sfac.vars));
        System.out.println("sfac = " + sfac);
    }

    public static void example6() {
        System.out.println("\n\n example 6");
        BigInteger cfac = new BigInteger();
        System.out.println("cfac = " + cfac);
        TermOrder to = new TermOrder(2);
        System.out.println("to   = " + to);
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(cfac, 3, to);
        System.out.println("fac = " + fac);
        fac.setVars(new String[]{"z", "y", "x"});
        System.out.println("fac = " + fac);
        GenPolynomial<BigInteger> x = fac.univariate(0);
        GenPolynomial<BigInteger> y = fac.univariate(1);
        GenPolynomial<BigInteger> z = fac.univariate(2);
        System.out.println("x = " + x);
        System.out.println("x = " + x.toString(fac.vars));
        System.out.println("y = " + y);
        System.out.println("y = " + y.toString(fac.vars));
        System.out.println("z = " + z);
        System.out.println("z = " + z.toString(fac.vars));
        GenPolynomial<GenPolynomial<BigInteger>> p = x.sum((BigInteger)((Object)y)).sum(z).sum((GenPolynomial<BigInteger>)fac.getONE());
        System.out.println("p = " + p);
        System.out.println("p = " + p.toString(fac.vars));
        GenPolynomial<GenPolynomial<RingElem<BigInteger>>> q = p;
        for (int i = 1; i < 20; ++i) {
            q = q.multiply((GenPolynomial<RingElem<BigInteger>>)p);
        }
        System.out.println("q = " + q.length());
        GenPolynomial<GenPolynomial<RingElem<BigInteger>>> q1 = q.sum((GenPolynomial<RingElem<BigInteger>>)fac.getONE());
        long t = System.currentTimeMillis();
        GenPolynomial<GenPolynomial<GenPolynomial<RingElem<BigInteger>>>> q2 = q.multiply((GenPolynomial<RingElem<BigInteger>>)q1);
        t = System.currentTimeMillis() - t;
        System.out.println("q2 = " + q2.length());
        System.out.println("time = " + t + " ms");
    }

    public static void example7() {
        System.out.println("\n\n example 7");
        BigRational cfac = new BigRational();
        System.out.println("cfac = " + cfac);
        TermOrder to = new TermOrder(2);
        System.out.println("to   = " + to);
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(cfac, 3, to);
        System.out.println("fac = " + fac);
        fac.setVars(new String[]{"z", "y", "x"});
        System.out.println("fac = " + fac);
        long mi = 1L;
        GenPolynomial<BigRational> x = fac.univariate(0, mi);
        GenPolynomial<BigRational> y = fac.univariate(1, mi);
        GenPolynomial<BigRational> z = fac.univariate(2, mi);
        System.out.println("x = " + x.toString(fac.vars));
        System.out.println("y = " + y.toString(fac.vars));
        System.out.println("z = " + z.toString(fac.vars));
        GenPolynomial<GenPolynomial<BigRational>> p = x.sum((BigRational)((Object)y)).sum(z).sum((GenPolynomial<BigRational>)fac.getONE());
        System.out.println("p = " + p.toString(fac.vars));
        int mpow = 20;
        System.out.println("mpow = " + mpow);
        GenPolynomial<GenPolynomial<RingElem<BigRational>>> q = p;
        for (int i = 1; i < mpow; ++i) {
            q = q.multiply((GenPolynomial<RingElem<BigRational>>)p);
        }
        System.out.println("len(q) = " + q.length());
        System.out.println("deg(q) = " + q.degree());
        GenPolynomial<GenPolynomial<RingElem<BigRational>>> q1 = q.sum((GenPolynomial<RingElem<BigRational>>)fac.getONE());
        long t = System.currentTimeMillis();
        GenPolynomial<GenPolynomial<GenPolynomial<RingElem<BigRational>>>> q2 = q.multiply((GenPolynomial<RingElem<BigRational>>)q1);
        t = System.currentTimeMillis() - t;
        System.out.println("len(q2)    = " + q2.length());
        System.out.println("deg(q2)    = " + q2.degree());
        System.out.println("LeadEV(q2) = " + q2.leadingExpVector());
        System.out.println("time       = " + t + " ms");
    }

    public static void example8() {
        int n;
        GenPolynomial<BigInteger> x2b;
        int m = 10;
        BigInteger fac = new BigInteger();
        String[] var = new String[]{"x"};
        GenPolynomialRing<BigInteger> ring = new GenPolynomialRing<BigInteger>(fac, 1, var);
        ArrayList<MonoidElem> T = new ArrayList<MonoidElem>(m);
        MonoidElem one = ring.getONE();
        GenPolynomial<BigInteger> x = ring.univariate(0);
        GenPolynomial<BigInteger> x2 = x2b = x.multiply(new BigInteger(2L));
        T.add(one);
        T.add(x);
        for (n = 2; n < m; ++n) {
            GenPolynomial<BigInteger> t = x2.multiply((BigInteger)((Object)((GenPolynomial)T.get(n - 1)))).subtract((BigInteger)((Object)((GenPolynomial)T.get(n - 2))));
            T.add(t);
        }
        for (n = 0; n < m; ++n) {
            System.out.println("T[" + n + "] = " + T.get(n));
        }
    }

    public static void example9() {
        int i;
        int n = 10;
        BigRational fac = new BigRational();
        String[] var = new String[]{"x"};
        GenPolynomialRing<BigRational> ring = new GenPolynomialRing<BigRational>(fac, 1, var);
        ArrayList<MonoidElem> P = new ArrayList<MonoidElem>(n);
        MonoidElem one = ring.getONE();
        GenPolynomial<BigRational> x = ring.univariate(0);
        P.add(one);
        P.add(x);
        for (i = 2; i < n; ++i) {
            BigRational n21 = new BigRational(2 * i - 1);
            GenPolynomial<BigRational> xc = x.multiply(n21);
            GenPolynomial<RingElem<BigRational>> t = xc.multiply((BigRational)((Object)((GenPolynomial)P.get(i - 1))));
            BigRational nn = new BigRational(i - 1);
            xc = ((GenPolynomial)P.get(i - 2)).multiply(nn);
            t = t.subtract((RingElem<BigRational>)xc);
            nn = new BigRational(1L, i);
            t = t.multiply(nn);
            P.add(t);
        }
        for (i = 0; i < n; ++i) {
            System.out.println("P[" + i + "] = " + ((GenPolynomial)P.get(i)).toString(var));
            System.out.println();
        }
    }

    public static void example10() {
        int i;
        int n = 100;
        BigInteger fac = new BigInteger();
        String[] var = new String[]{"x"};
        GenPolynomialRing<BigInteger> ring = new GenPolynomialRing<BigInteger>(fac, 1, var);
        ArrayList<MonoidElem> H = new ArrayList<MonoidElem>(n);
        MonoidElem one = ring.getONE();
        GenPolynomial<BigInteger> x = ring.univariate(0);
        BigInteger n2 = new BigInteger(2L);
        GenPolynomial<BigInteger> x2 = x.multiply(n2);
        H.add(one);
        H.add(x2);
        for (i = 2; i < n; ++i) {
            GenPolynomial<RingElem<BigInteger>> t = x2.multiply((BigInteger)((Object)((GenPolynomial)H.get(i - 1))));
            BigInteger nn = new BigInteger(2 * (i - 1));
            GenPolynomial<BigInteger> xc = ((GenPolynomial)H.get(i - 2)).multiply(nn);
            t = t.subtract((BigInteger)((Object)xc));
            H.add(t);
        }
        for (i = n - 1; i < n; ++i) {
            System.out.println("H[" + i + "] = " + ((GenPolynomial)H.get(i)).toString(var));
            System.out.println();
        }
    }

    public static void example11() {
        int n = 50;
        BigRational fac = new BigRational();
        GenPolynomialRing<BigRational> ring = new GenPolynomialRing<BigRational>(fac, n);
        System.out.println("ring = " + ring + "\n");
        GenPolynomial<BigRational> p = ring.random(5, 3, 6, 0.5f);
        System.out.println("p = " + p + "\n");
        List<GenPolynomial<BigInteger>> dem = TermOrderOptimization.degreeMatrix(p);
        System.out.println("dem = " + dem + "\n");
        ArrayList polys = new ArrayList();
        polys.add(p);
        for (int i = 0; i < 5; ++i) {
            polys.add(ring.random(5, 3, 6, 0.1f));
        }
        System.out.println("polys = " + polys + "\n");
        dem = TermOrderOptimization.degreeMatrix(polys);
        System.out.println("dem = " + dem + "\n");
        List<Integer> perm = TermOrderOptimization.optimalPermutation(dem);
        System.out.println("perm = " + perm + "\n");
        List<GenPolynomial<BigInteger>> pdem = TermOrderOptimization.listPermutation(perm, dem);
        System.out.println("pdem = " + pdem + "\n");
        GenPolynomialRing<BigRational> pring = TermOrderOptimization.permutation(perm, ring);
        System.out.println("ring  = " + ring);
        System.out.println("pring = " + pring + "\n");
        List ppolys = TermOrderOptimization.permutation(perm, pring, polys);
        System.out.println("ppolys = " + ppolys + "\n");
        dem = TermOrderOptimization.degreeMatrix(ppolys);
        perm = TermOrderOptimization.optimalPermutation(dem);
        int i = 0;
        for (Integer j : perm) {
            if (i != j) {
                System.out.println("error = " + i + " != " + j + "\n");
            }
            ++i;
        }
        OptimizedPolynomialList<BigRational> op = TermOrderOptimization.optimizeTermOrder(ring, polys);
        System.out.println("op:\n" + op);
        if (!op.equals(new PolynomialList<BigRational>(pring, ppolys))) {
            System.out.println("error = \n" + op);
        }
    }

    public static void example12() {
        System.out.println("\n\n example 12");
        BigRational t1 = new BigRational();
        System.out.println("t1 = " + t1);
        BigInteger t2 = new BigInteger();
        System.out.println("t2 = " + t2);
        System.out.println("t1.isAssignableFrom(t2) = " + t1.getClass().isAssignableFrom(t2.getClass()));
        System.out.println("t2.isAssignableFrom(t1) = " + t2.getClass().isAssignableFrom(t1.getClass()));
        GenPolynomialRing<BigInteger> t3 = new GenPolynomialRing<BigInteger>(t2, 3);
        System.out.println("t3 = " + t3);
        GenSolvablePolynomialRing<BigInteger> t4 = new GenSolvablePolynomialRing<BigInteger>(t2, 3);
        System.out.println("t4 = " + t4);
        System.out.println("t3.isAssignableFrom(t4) = " + t3.getClass().isAssignableFrom(t4.getClass()));
        System.out.println("t4.isAssignableFrom(t3) = " + t4.getClass().isAssignableFrom(t3.getClass()));
        GenPolynomialRing<BigRational> t5 = new GenPolynomialRing<BigRational>(t1, 3);
        System.out.println("t5 = " + t5);
        System.out.println("t3.isAssignableFrom(t5) = " + t3.getClass().isAssignableFrom(t5.getClass()));
        System.out.println("t5.isAssignableFrom(t3) = " + t5.getClass().isAssignableFrom(t3.getClass()));
    }
}

