/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import edu.jas.kern.TimeExceededException;
import java.util.concurrent.Callable;

public class TimeStatus {
    private static boolean allowTime = false;
    private static long limitTime = Long.MAX_VALUE;
    private static long startTime = System.currentTimeMillis();
    private static Callable<Boolean> callBack = null;

    protected TimeStatus() {
    }

    public static boolean isActive() {
        return allowTime;
    }

    public static void setActive() {
        allowTime = true;
    }

    public static void setNotActive() {
        allowTime = false;
    }

    public static void setLimit(long t) {
        limitTime = t;
    }

    public static void restart() {
        startTime = System.currentTimeMillis();
    }

    public static void setCallBack(Callable<Boolean> cb) {
        callBack = cb;
    }

    public static void checkTime(String msg) {
        if (!allowTime) {
            return;
        }
        if (limitTime == Long.MAX_VALUE) {
            return;
        }
        long tt = System.currentTimeMillis() - startTime - limitTime;
        if (tt <= 0L) {
            return;
        }
        if (callBack != null) {
            try {
                boolean t = callBack.call();
                if (t) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (msg == null) {
            msg = "";
        }
        throw new TimeExceededException(msg + " over time = " + tt);
    }
}

