/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PolyGBUtil {
    private static final Logger logger = Logger.getLogger(PolyGBUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> boolean isResultant(GenPolynomial<C> A, GenPolynomial<C> B, GenPolynomial<C> r) {
        if (r == null || r.isZERO()) {
            return true;
        }
        GroebnerBaseAbstract bb = GBFactory.getImplementation(r.ring.coFac);
        ArrayList F = new ArrayList(2);
        F.add(A);
        F.add(B);
        List G = bb.GB(F);
        GenPolynomial n = bb.red.normalform(G, r);
        return n.isZERO();
    }

    public static <C extends RingElem<C>> GenPolynomial<C> topPseudoRemainder(List<GenPolynomial<C>> A, GenPolynomial<C> P) {
        if (A == null || A.isEmpty()) {
            return P.monic();
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = A.get((int)0).ring;
        if (pfac.nvar <= 1) {
            GenPolynomial<C> R = PolyUtil.baseSparsePseudoRemainder(P, A.get(0));
            return R.monic();
        }
        GenPolynomialRing rfac = pfac.recursive(1);
        GenPolynomial<C> Q = A.get(0);
        GenPolynomial qr = PolyUtil.recursive(rfac, Q);
        GenPolynomial pr = PolyUtil.recursive(rfac, P);
        if (qr.isONE()) {
            return P.ring.getZERO();
        }
        GenPolynomial<GenPolynomial<Object>> rr = qr.degree(0) > 0L ? PolyUtil.recursiveSparsePseudoRemainder(pr, qr) : pr;
        if (rr.degree(0) > 0L) {
            GenPolynomial R = PolyUtil.distribute(pfac, rr);
            return R.monic();
        }
        List<GenPolynomial<C>> zeroDeg = PolyGBUtil.zeroDegrees(A);
        GenPolynomial R = PolyGBUtil.topPseudoRemainder(zeroDeg, rr.leadingBaseCoefficient());
        R = R.extend(pfac, 0, 0L);
        return R.monic();
    }

    public static <C extends RingElem<C>> GenPolynomial<C> topCoefficientPseudoRemainder(List<GenPolynomial<C>> A, GenPolynomial<C> P) {
        if (A == null || A.isEmpty()) {
            return P.monic();
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        GenPolynomialRing pfac1 = A.get((int)0).ring;
        if (pfac1.nvar <= 1) {
            GenPolynomial<C> a = A.get(0);
            GenPolynomialRing rfac = pfac.recursive(pfac.nvar - 1);
            GenPolynomial pr = PolyUtil.recursive(rfac, P);
            GenPolynomial rr = PolyGBUtil.coefficientPseudoRemainderBase(pr, a);
            GenPolynomial R = PolyUtil.distribute(pfac, rr);
            return R.monic();
        }
        GenPolynomialRing rfac1 = pfac1.recursive(1);
        int nv = pfac.nvar - pfac1.nvar;
        GenPolynomialRing rfac = pfac.recursive(1 + nv);
        GenPolynomialRing rfac2 = rfac.recursive(nv);
        if (debug) {
            logger.info((Object)("rfac =" + rfac));
        }
        GenPolynomial pr = PolyUtil.recursive(rfac, P);
        GenPolynomial pr2 = PolyUtil.recursive(rfac2, pr);
        GenPolynomial<C> Q = A.get(0);
        GenPolynomial qr = PolyUtil.recursive(rfac1, Q);
        if (qr.isONE()) {
            return P.ring.getZERO();
        }
        GenPolynomial<GenPolynomial<Object>> rr = qr.degree(0) > 0L ? PolyGBUtil.coefficientPseudoRemainder(pr2, qr) : pr2;
        List<GenPolynomial<C>> zeroDeg = PolyGBUtil.zeroDegrees(A);
        GenPolynomial Rr = PolyUtil.distribute(rfac, rr);
        GenPolynomial R = PolyUtil.distribute(pfac, Rr);
        R = PolyGBUtil.topCoefficientPseudoRemainder(zeroDeg, R);
        return R.monic();
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<GenPolynomial<C>>> coefficientPseudoRemainder(GenPolynomial<GenPolynomial<GenPolynomial<C>>> P, GenPolynomial<GenPolynomial<C>> A) {
        if (A == null || A.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + A);
        }
        if (A.isONE()) {
            return P.ring.getZERO();
        }
        if (P.isZERO() || P.isONE()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        GenPolynomialRing afac = A.ring;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>> r = P;
        GenPolynomial<GenPolynomial<C>> ldcf = P.leadingBaseCoefficient();
        long m = ldcf.degree(0);
        long n = A.degree(0);
        GenPolynomial<C> c = A.leadingBaseCoefficient();
        GenPolynomial<GenPolynomial<C>> cc = ((GenPolynomial)afac.getZERO()).sum(c);
        ExpVector e = A.leadingExpVector();
        for (long i = m; i >= n; --i) {
            if (r.isZERO()) {
                return r;
            }
            GenPolynomial<GenPolynomial<C>> p = r.leadingBaseCoefficient();
            ExpVector g = r.leadingExpVector();
            long k = p.degree(0);
            if (i == k) {
                GenPolynomial<C> pl = p.leadingBaseCoefficient();
                ExpVector f = p.leadingExpVector();
                f = f.subtract(e);
                r = r.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)cc);
                GenPolynomial<GenPolynomial<C>> h = A.multiply(pl, f);
                GenPolynomial<GenPolynomial<GenPolynomial<C>>> hr = new GenPolynomial<GenPolynomial<GenPolynomial<C>>>(pfac, h, g);
                r = r.subtract((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)hr);
                continue;
            }
            r = r.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)cc);
        }
        if (r.degree(0) < P.degree(0)) {
            r = PolyGBUtil.coefficientPseudoRemainder(r, A);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> coefficientPseudoRemainderBase(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<C> A) {
        if (A == null || A.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + A);
        }
        if (A.isONE()) {
            return P.ring.getZERO();
        }
        if (P.isZERO() || P.isONE()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        GenPolynomialRing afac = A.ring;
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        GenPolynomial<C> ldcf = P.leadingBaseCoefficient();
        long m = ldcf.degree(0);
        long n = A.degree(0);
        C c = A.leadingBaseCoefficient();
        GenPolynomial<C> cc = ((GenPolynomial)afac.getZERO()).sum(c);
        ExpVector e = A.leadingExpVector();
        for (long i = m; i >= n; --i) {
            if (r.isZERO()) {
                return r;
            }
            GenPolynomial<C> p = r.leadingBaseCoefficient();
            ExpVector g = r.leadingExpVector();
            long k = p.degree(0);
            if (i == k) {
                C pl = p.leadingBaseCoefficient();
                ExpVector f = p.leadingExpVector();
                f = f.subtract(e);
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)cc);
                GenPolynomial<C> h = A.multiply(pl, f);
                GenPolynomial<GenPolynomial<C>> hr = new GenPolynomial<GenPolynomial<C>>(pfac, h, g);
                r = r.subtract(hr);
                continue;
            }
            r = r.multiply((GenPolynomial<GenPolynomial<C>>)cc);
        }
        if (r.degree(0) < P.degree(0)) {
            r = PolyGBUtil.coefficientPseudoRemainderBase(r, A);
        }
        return r;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> zeroDegrees(List<GenPolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return A;
        }
        GenPolynomialRing pfac = A.get((int)0).ring;
        GenPolynomialRing rfac = pfac.recursive(1);
        ArrayList<GenPolynomial<C>> zeroDeg = new ArrayList<GenPolynomial<C>>(A.size());
        for (int i = 0; i < A.size(); ++i) {
            GenPolynomial<C> q = A.get(i);
            GenPolynomial fr = PolyUtil.recursive(rfac, q);
            if (fr.degree(0) != 0L) continue;
            zeroDeg.add(fr.leadingBaseCoefficient());
        }
        return zeroDeg;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<C>> intersect(GenPolynomialRing<C> pfac, List<GenPolynomial<C>> A, List<GenPolynomial<C>> B) {
        if (A == null || A.isEmpty()) {
            return B;
        }
        if (B == null || B.isEmpty()) {
            return A;
        }
        int s = A.size() + B.size();
        ArrayList c = new ArrayList(s);
        GenPolynomialRing<C> tfac = pfac.extend(1);
        for (GenPolynomial<Object> p : A) {
            p = p.extend(tfac, 0, 1L);
            c.add(p);
        }
        for (GenPolynomial<Object> p : B) {
            GenPolynomial<C> q = p.extend(tfac, 0, 1L);
            GenPolynomial<GenPolynomial<C>> r = p.extend(tfac, 0, 0L);
            p = r.subtract(q);
            c.add(p);
        }
        GroebnerBaseAbstract bb = GBFactory.getImplementation(tfac.coFac);
        logger.warn((Object)"intersect computing GB");
        List G = bb.GB(c);
        if (debug) {
            logger.debug((Object)("intersect GB = " + G));
        }
        List<GenPolynomial<C>> I = PolyUtil.intersect(pfac, G);
        return I;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<C>> intersect(GenSolvablePolynomialRing<C> pfac, List<GenSolvablePolynomial<C>> A, List<GenSolvablePolynomial<C>> B) {
        if (A == null || A.isEmpty()) {
            return B;
        }
        if (B == null || B.isEmpty()) {
            return A;
        }
        int s = A.size() + B.size();
        ArrayList c = new ArrayList(s);
        GenPolynomialRing tfac = pfac.extend(1);
        for (GenSolvablePolynomial<C> genSolvablePolynomial : A) {
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.extend(tfac, 0, 1L);
            c.add(genSolvablePolynomial2);
        }
        for (GenSolvablePolynomial<C> genSolvablePolynomial : B) {
            GenSolvablePolynomial q = (GenSolvablePolynomial)genSolvablePolynomial.extend(tfac, 0, 1L);
            GenSolvablePolynomial r = (GenSolvablePolynomial)genSolvablePolynomial.extend(tfac, 0, 0L);
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)r.subtract(q);
            c.add(genSolvablePolynomial3);
        }
        SolvableGroebnerBaseSeq sbb = new SolvableGroebnerBaseSeq();
        logger.warn((Object)"intersect computing GB");
        List list = sbb.leftGB(c);
        if (debug) {
            logger.debug((Object)("intersect GB = " + list));
        }
        List<GenSolvablePolynomial<C>> I = PolyUtil.intersect(pfac, list);
        return I;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> syzLcm(GenSolvablePolynomialRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d) {
        if (n.isZERO()) {
            return n;
        }
        if (d.isZERO()) {
            return d;
        }
        if (n.isONE()) {
            return d;
        }
        if (d.isONE()) {
            return n;
        }
        ArrayList<GenSolvablePolynomial<C>> A = new ArrayList<GenSolvablePolynomial<C>>(1);
        A.add(n);
        ArrayList<GenSolvablePolynomial<C>> B = new ArrayList<GenSolvablePolynomial<C>>(1);
        B.add(d);
        List<GenSolvablePolynomial<C>> c = PolyGBUtil.intersect(r, A, B);
        GenSolvablePolynomial<C> lcm = null;
        for (GenSolvablePolynomial<C> p : c) {
            if (p == null || p.isZERO()) continue;
            if (lcm == null) {
                lcm = p;
                continue;
            }
            if (lcm.compareTo(p) <= 0) continue;
            lcm = p;
        }
        if (lcm == null) {
            throw new RuntimeException("this cannot happen: lcm == null: " + c);
        }
        return lcm;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> syzGcd(GenSolvablePolynomialRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d) {
        if (n.isZERO()) {
            return d;
        }
        if (d.isZERO()) {
            return n;
        }
        if (n.isONE()) {
            return n;
        }
        if (d.isONE()) {
            return d;
        }
        if (n.totalDegree() > 3L || d.totalDegree() > 3L) {
            logger.warn((Object)("skipping GB computation: degs = " + n.totalDegree() + ", " + d.totalDegree()));
            return r.getONE();
        }
        ArrayList A = new ArrayList(2);
        A.add(n);
        A.add(d);
        SolvableGroebnerBaseSeq sbb = new SolvableGroebnerBaseSeq();
        logger.warn((Object)("syzGcd computing GB: " + A));
        List G = sbb.rightGB(A);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("G = " + G));
        }
        if (G.size() == 1) {
            return G.get(0);
        }
        logger.warn((Object)("gcd not determined, set to 1: " + G));
        return r.getONE();
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] quotientRemainder(GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d) {
        GenSolvablePolynomial[] res = new GenSolvablePolynomial[2];
        if (d.isZERO()) {
            throw new RuntimeException("division by zero: " + n + "/" + d);
        }
        if (n.isZERO()) {
            res[0] = n;
            res[1] = n;
            return res;
        }
        GenSolvablePolynomialRing r = n.ring;
        if (d.isONE()) {
            res[0] = n;
            res[1] = r.getZERO();
            return res;
        }
        ArrayList Q = new ArrayList(1);
        Q.add(r.getZERO());
        ArrayList D = new ArrayList(1);
        D.add(d);
        SolvableReductionSeq sred = new SolvableReductionSeq();
        res[1] = sred.rightNormalform(Q, D, n);
        res[0] = (GenSolvablePolynomial)Q.get(0);
        return res;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] syzGcdCofactors(GenSolvablePolynomialRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d) {
        GenSolvablePolynomial[] res = new GenSolvablePolynomial[]{PolyGBUtil.syzGcd(r, n, d), n, d};
        if (res[0].isONE()) {
            return res;
        }
        GenSolvablePolynomial<C>[] nqr = PolyGBUtil.quotientRemainder(n, res[0]);
        if (!nqr[1].isZERO()) {
            res[0] = r.getONE();
            return res;
        }
        GenSolvablePolynomial<C>[] dqr = PolyGBUtil.quotientRemainder(d, res[0]);
        if (!dqr[1].isZERO()) {
            res[0] = r.getONE();
            return res;
        }
        res[1] = nqr[0];
        res[2] = dqr[0];
        return res;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> syzLcm(GenPolynomialRing<C> r, GenPolynomial<C> n, GenPolynomial<C> d) {
        ArrayList<GenPolynomial<C>> A = new ArrayList<GenPolynomial<C>>(1);
        A.add(n);
        ArrayList<GenPolynomial<C>> B = new ArrayList<GenPolynomial<C>>(1);
        B.add(d);
        List<GenPolynomial<C>> c = PolyGBUtil.intersect(r, A, B);
        if (c.size() != 1) {
            logger.warn((Object)("lcm not uniqe: " + c));
        }
        GenPolynomial<C> lcm = c.get(0);
        return lcm;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> syzGcd(GenPolynomialRing<C> r, GenPolynomial<C> n, GenPolynomial<C> d) {
        if (n.isZERO()) {
            return d;
        }
        if (d.isZERO()) {
            return n;
        }
        if (n.isONE()) {
            return n;
        }
        if (d.isONE()) {
            return d;
        }
        GenPolynomial<GenPolynomial<C>> p = n.multiply(d);
        GenPolynomial<C> lcm = PolyGBUtil.syzLcm(r, n, d);
        GenPolynomial<GenPolynomial<C>> gcd = PolyUtil.basePseudoDivide(p, lcm);
        return gcd;
    }
}

