/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gbufd.MultiplicativeSet;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiplicativeSetSquarefree<C extends GcdRingElem<C>>
extends MultiplicativeSet<C> {
    private static final Logger logger = Logger.getLogger(MultiplicativeSetSquarefree.class);
    protected final SquarefreeAbstract<C> engine;

    public MultiplicativeSetSquarefree(GenPolynomialRing<C> ring) {
        super(ring);
        this.engine = SquarefreeFactory.getImplementation(ring.coFac);
    }

    protected MultiplicativeSetSquarefree(GenPolynomialRing<C> ring, List<GenPolynomial<C>> ms, SquarefreeAbstract<C> eng) {
        super(ring, ms);
        this.engine = eng;
    }

    @Override
    public String toString() {
        return "MultiplicativeSetSquarefree" + this.mset;
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof MultiplicativeSetSquarefree)) {
            return false;
        }
        return super.equals(B);
    }

    @Override
    public MultiplicativeSetSquarefree<C> add(GenPolynomial<C> cc) {
        if (cc == null || cc.isZERO() || cc.isConstant()) {
            return this;
        }
        if (this.ring.coFac.isField()) {
            cc = cc.monic();
        }
        if (this.mset.size() == 0) {
            List<GenPolynomial<C>> list = this.engine.coPrimeSquarefree(cc, this.mset);
            if (this.ring.coFac.isField()) {
                list = PolyUtil.monic(list);
            }
            return new MultiplicativeSetSquarefree<C>(this.ring, list, this.engine);
        }
        GenPolynomial<C> c = this.removeFactors(cc);
        if (c.isConstant()) {
            logger.info((Object)("skipped unit or constant = " + c));
            return this;
        }
        logger.info((Object)("added to squarefree mset = " + c));
        List<GenPolynomial<C>> list = this.engine.coPrimeSquarefree(c, this.mset);
        if (this.ring.coFac.isField()) {
            list = PolyUtil.monic(list);
        }
        return new MultiplicativeSetSquarefree<C>(this.ring, list, this.engine);
    }

    @Override
    public MultiplicativeSetSquarefree<C> replace(List<GenPolynomial<C>> L) {
        MultiplicativeSet ms = new MultiplicativeSetSquarefree<C>(this.ring);
        if (L == null || L.size() == 0) {
            return ms;
        }
        for (GenPolynomial<C> p : L) {
            ms = ms.add((GenPolynomial)p);
        }
        return ms;
    }
}

