/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gbufd.MultiplicativeSet;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiplicativeSetCoPrime<C extends GcdRingElem<C>>
extends MultiplicativeSet<C> {
    private static final Logger logger = Logger.getLogger(MultiplicativeSetCoPrime.class);
    protected final GreatestCommonDivisorAbstract<C> engine;

    public MultiplicativeSetCoPrime(GenPolynomialRing<C> ring) {
        super(ring);
        this.engine = GCDFactory.getProxy(ring.coFac);
    }

    protected MultiplicativeSetCoPrime(GenPolynomialRing<C> ring, List<GenPolynomial<C>> ms, GreatestCommonDivisorAbstract<C> eng) {
        super(ring, ms);
        this.engine = eng;
    }

    @Override
    public String toString() {
        return "MultiplicativeSetCoPrime" + this.mset;
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof MultiplicativeSetCoPrime)) {
            return false;
        }
        return super.equals(B);
    }

    @Override
    public MultiplicativeSetCoPrime<C> add(GenPolynomial<C> cc) {
        if (cc == null || cc.isZERO() || cc.isConstant()) {
            return this;
        }
        if (this.ring.coFac.isField()) {
            cc = cc.monic();
        }
        if (this.mset.size() == 0) {
            List<GenPolynomial<C>> list = this.engine.coPrime(cc, this.mset);
            if (this.ring.coFac.isField()) {
                list = PolyUtil.monic(list);
            }
            return new MultiplicativeSetCoPrime<C>(this.ring, list, this.engine);
        }
        GenPolynomial<C> c = this.removeFactors(cc);
        if (c.isConstant()) {
            logger.info((Object)("skipped unit or constant = " + c));
            return this;
        }
        logger.info((Object)("added to co-prime mset = " + c));
        List<GenPolynomial<C>> list = this.engine.coPrime(c, this.mset);
        if (this.ring.coFac.isField()) {
            list = PolyUtil.monic(list);
        }
        return new MultiplicativeSetCoPrime<C>(this.ring, list, this.engine);
    }

    @Override
    public MultiplicativeSetCoPrime<C> replace(List<GenPolynomial<C>> L) {
        MultiplicativeSet ms = new MultiplicativeSetCoPrime<C>(this.ring);
        if (L == null || L.size() == 0) {
            return ms;
        }
        for (GenPolynomial<C> p : L) {
            ms = ms.add((GenPolynomial)p);
        }
        return ms;
    }
}

