/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBasePseudoSeq<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePseudoSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> red;
    protected final RingFactory<C> cofac;

    public GroebnerBasePseudoSeq(RingFactory<C> rf) {
        this(new PseudoReductionSeq(), rf, new OrderedPairlist());
    }

    public GroebnerBasePseudoSeq(RingFactory<C> rf, PairList<C> pl) {
        this(new PseudoReductionSeq(), rf, pl);
    }

    public GroebnerBasePseudoSeq(PseudoReduction<C> red, RingFactory<C> rf, PairList<C> pl) {
        super(red, pl);
        this.red = red;
        this.cofac = rf;
        this.engine = GCDFactory.getImplementation(rf);
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        List<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>();
        PairList<GenPolynomial<GenPolynomial<C>>> pairlist = null;
        int l = F.size();
        ListIterator<GenPolynomial<C>> it = F.listIterator();
        while (it.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> p = it.next();
            if (((GenPolynomial)p).length() > 0) {
                p = this.engine.basePrimitivePart((GenPolynomial<C>)p);
                if (((GenPolynomial)(p = ((GenPolynomial)p).abs())).isConstant()) {
                    G.clear();
                    G.add((GenPolynomial<C>)p);
                    return G;
                }
                G.add((GenPolynomial<C>)p);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, ((GenPolynomial)p).ring);
                }
                pairlist.put((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        while (pairlist.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> H;
            GenPolynomial S;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if (((GenPolynomial)(H = this.red.normalform(G, S))).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(H) = " + ((GenPolynomial)H).leadingExpVector()));
            }
            H = this.engine.basePrimitivePart((GenPolynomial<C>)H);
            if (((GenPolynomial)(H = ((GenPolynomial)H).abs())).isConstant()) {
                G.clear();
                G.add((GenPolynomial<C>)H);
                return G;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("H = " + H));
            }
            if (((GenPolynomial)H).length() <= 0) continue;
            ++l;
            G.add((GenPolynomial<C>)H);
            pairlist.put((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)H);
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Gp) {
        AbelianGroupElem<GenPolynomial<C>> a;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Gp.size());
        for (GenPolynomial<C> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenPolynomial<C>)G.remove(0);
            if (this.red.isTopReducible((List<GenPolynomial<C>>)G, (GenPolynomial<C>)a) || this.red.isTopReducible(F, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList<GenPolynomial<C>> ff = new ArrayList<GenPolynomial<C>>(G);
                ff.addAll(F);
                if (((GenPolynomial)(a = this.red.normalform((List<GenPolynomial<GenPolynomial<C>>>)ff, (GenPolynomial<GenPolynomial<C>>)a))).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F.add(a);
        }
        G = F;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        int len = G.size();
        for (int i = 0; i < len; ++i) {
            a = (GenPolynomial)G.remove(0);
            a = this.red.normalform((List<GenPolynomial<C>>)G, (GenPolynomial<C>)a);
            a = this.engine.basePrimitivePart((GenPolynomial<C>)a);
            a = ((GenPolynomial)a).abs();
            G.add((GenPolynomial<C>)a);
        }
        return G;
    }
}

