/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBasePseudoRecSeq<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePseudoRecSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<GenPolynomial<C>> red;
    protected final RingFactory<GenPolynomial<C>> cofac;
    protected final RingFactory<C> baseCofac;

    public GroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> rf) {
        this(new PseudoReductionSeq<GenPolynomial<C>>(), rf);
    }

    public GroebnerBasePseudoRecSeq(PseudoReduction<GenPolynomial<C>> red, RingFactory<GenPolynomial<C>> rf) {
        super(red);
        this.red = red;
        this.cofac = rf;
        GenPolynomialRing rp = (GenPolynomialRing)this.cofac;
        this.baseCofac = rp.coFac;
        this.engine = GCDFactory.getProxy(this.baseCofac);
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> GB(int modv, List<GenPolynomial<GenPolynomial<C>>> F) {
        ArrayList<GenPolynomial<GenPolynomial<C>>> G = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        OrderedPairlist pairlist = null;
        int l = F.size();
        ListIterator<GenPolynomial<GenPolynomial<C>>> it = F.listIterator();
        while (it.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> p = it.next();
            if (((GenPolynomial)p).length() > 0) {
                p = this.engine.recursivePrimitivePart((GenPolynomial<GenPolynomial<C>>)p);
                if (((GenPolynomial)(p = ((GenPolynomial)p).abs())).isConstant()) {
                    G.clear();
                    G.add((GenPolynomial<GenPolynomial<C>>)p);
                    return G;
                }
                G.add((GenPolynomial<GenPolynomial<C>>)p);
                if (pairlist == null) {
                    pairlist = new OrderedPairlist(modv, ((GenPolynomial)p).ring);
                }
                pairlist.put(p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        while (pairlist.hasNext()) {
            AbelianGroupElem H;
            GenPolynomial S;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if (((GenPolynomial)(H = this.red.normalform(G, S))).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(H) = " + ((GenPolynomial)H).leadingExpVector()));
            }
            H = this.engine.recursivePrimitivePart(H);
            if (((GenPolynomial)(H = ((GenPolynomial)H).abs())).isConstant()) {
                G.clear();
                G.add((GenPolynomial<GenPolynomial<C>>)H);
                return G;
            }
            if (this.debug) {
                logger.debug((Object)("H = " + H));
            }
            if (((GenPolynomial)H).length() <= 0) continue;
            ++l;
            G.add((GenPolynomial<GenPolynomial<C>>)H);
            pairlist.put(H);
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB((List<GenPolynomial<GenPolynomial<C>>>)G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> minimalGB(List<GenPolynomial<GenPolynomial<C>>> Gp) {
        AbelianGroupElem a;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList G = new ArrayList<GenPolynomial<GenPolynomial<C>>>(Gp.size());
        for (GenPolynomial<GenPolynomial<C>> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenPolynomial)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList ff = new ArrayList(G);
                ff.addAll(F);
                if (((GenPolynomial)(a = this.red.normalform(ff, a))).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F.add(a);
        }
        G = F;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        int len = G.size();
        for (int i = 0; i < len; ++i) {
            a = (GenPolynomial)G.remove(0);
            a = this.red.normalform(G, a);
            a = this.engine.recursivePrimitivePart(a);
            a = ((GenPolynomial)a).abs();
            G.add(a);
        }
        return G;
    }
}

