/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoMiReducer;
import edu.jas.gbufd.PseudoReducer;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBasePseudoParallel<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePseudoParallel.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final int threads;
    protected final transient ThreadPool pool;
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> red;
    protected final RingFactory<C> cofac;

    public GroebnerBasePseudoParallel(int threads, RingFactory<C> rf) {
        this(threads, rf, new PseudoReductionPar());
    }

    public GroebnerBasePseudoParallel(int threads, RingFactory<C> rf, PseudoReduction<C> red) {
        this(threads, rf, red, new ThreadPool(threads));
    }

    public GroebnerBasePseudoParallel(int threads, RingFactory<C> rf, PseudoReduction<C> red, ThreadPool pool) {
        this(threads, rf, red, pool, new OrderedPairlist());
    }

    public GroebnerBasePseudoParallel(int threads, RingFactory<C> rf, PairList<C> pl) {
        this(threads, rf, new PseudoReductionPar(), new ThreadPool(threads), pl);
    }

    public GroebnerBasePseudoParallel(int threads, RingFactory<C> rf, PseudoReduction<C> red, ThreadPool pool, PairList<C> pl) {
        super(red, pl);
        if (!(red instanceof PseudoReductionPar)) {
            logger.warn((Object)"parallel GB should use parallel aware reduction");
        }
        this.red = red;
        this.cofac = rf;
        if (threads < 1) {
            threads = 1;
        }
        this.threads = threads;
        this.engine = GCDFactory.getImplementation(rf);
        this.pool = pool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int s = this.pool.cancel();
        return s;
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        List<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>();
        PairList<GenPolynomial<C>> pairlist = null;
        int l = F.size();
        ListIterator<GenPolynomial<C>> it = F.listIterator();
        while (it.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> p = it.next();
            if (((GenPolynomial)p).length() > 0) {
                p = this.engine.basePrimitivePart((GenPolynomial<C>)p);
                if (((GenPolynomial)(p = ((GenPolynomial)p).abs())).isConstant()) {
                    G.clear();
                    G.add((GenPolynomial<C>)p);
                    return G;
                }
                G.add((GenPolynomial<C>)p);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, ((GenPolynomial)p).ring);
                }
                pairlist.put((GenPolynomial<GenPolynomial<C>>)p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        logger.info((Object)("start " + pairlist));
        Terminator fin = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            PseudoReducer<C> R = new PseudoReducer<C>(fin, G, pairlist, this.engine);
            this.pool.addJob(R);
        }
        fin.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug((Object)("#parallel list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Gp) {
        GenPolynomial<C> a;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Gp.size());
        for (GenPolynomial<C> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenPolynomial<C>> F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenPolynomial<C>)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList<GenPolynomial<C>> ff = new ArrayList<GenPolynomial<C>>(G);
                ff.addAll(F);
                if ((a = this.red.normalform(ff, a)).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F.add(a);
        }
        G = F;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        PseudoMiReducer[] mirs = new PseudoMiReducer[G.size()];
        int i = 0;
        F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenPolynomial)G.remove(0);
            ArrayList R = new ArrayList(G.size() + F.size());
            R.addAll(G);
            R.addAll(F);
            mirs[i] = new PseudoMiReducer(R, a, this.engine);
            this.pool.addJob(mirs[i]);
            ++i;
            F.add(a);
        }
        G = F;
        F = new ArrayList(G.size());
        for (i = 0; i < mirs.length; ++i) {
            a = mirs[i].getNF();
            F.add(a);
        }
        return F;
    }
}

