/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBaseFGLM;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.Monomial;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBaseFGLMExamples
extends TestCase {
    String all = "Zahlbereich | Ordnung    | Elements G | Elements L | bitHeight G | bitHeight L | Deg G | Deg L | Time G | Time FGLM | Time L";
    String grad = "Zahlbereich | Ordnung    | Elements G | bitHeight G | Deg G | Time G | vDim";
    String lex = "Zahlbereich | Ordnung      | Elements L | bitHeight L | Deg L | Time L";
    String fglm = "Zahlbereich | Ordnung      | Elements G | Elements L  | bitHeight G | bitHeight L |  Deg G | Deg L | Time G | Time FGLM";
    String modAll = "Zahlbereich | Ordnung    | Elements G | Elements L | Deg G | Deg L | Time G | Time FGLM | Time L";
    String modGrad = "Zahlbereich | Ordnung      | Elements G | Deg G | Time G";
    String modfglm = "Zahlbereich | Ordnung      | Elements G | Elements L | Deg G | Deg L | Time G | Time FGLM";

    public static void main(String[] args) {
        TestRunner.run((Test)GroebnerBaseFGLMExamples.suite());
    }

    public GroebnerBaseFGLMExamples(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GroebnerBaseFGLMExamples.class);
        return suite;
    }

    protected void setUp() {
        System.out.println("Setup");
    }

    protected void tearDown() {
        System.out.println("Tear Down");
    }

    public void xtestFiveVarsOrder() {
        String polynomials = "(  (v^8*x*y*z), ( w^3*x - 2*v), ( 4*x*y - 2 + y), ( 3*y^5 - 3 + z ), ( 8*y^2*z^2 + x * y^6 )) ";
        String[] order = new String[]{"v", "w", "x", "y", "z"};
        String order2 = this.shuffle(order);
        String ergM13 = this.modAll(order2, polynomials, 13);
        String ergM7 = this.modAll(order2, polynomials, 7);
        System.out.println(this.all);
        System.out.println("Mod 13");
        System.out.println(ergM13);
        System.out.println("Mod 7");
        System.out.println(ergM7);
    }

    public void xtestCAP() {
        String polynomials = "(  (y^2*z + 2*x*y*t - 2*x - z),(-x^3*z + 4*x*y^2*z + 4*x^2*y*t + 2*y^3*t + 4*x^2 - 10*y^2 + 4*x*z - 10*y*t + 2),(2*y*z*t + x*t^2 - x - 2*z),(-x*z^3 + 4*y*z^2*t + 4*x*z*t^2 + 2*y*t^3 + 4*x*z + 4*z^2 - 10*y*t -10*t^2 + 2)) ";
        String orderINV = "(x,y,z,t)";
        String orderL = "(t,z,y,x)";
        String erg_deg = this.grad(orderINV, polynomials);
        System.out.println(this.grad);
        System.out.println(erg_deg);
        String erg1 = this.all(orderINV, polynomials);
        String erg2 = this.all(orderL, polynomials);
        String ergMod1 = this.modAll(orderINV, polynomials, 1831);
        String ergMod2 = this.modAll(orderL, polynomials, 1831);
        System.out.println(this.all);
        System.out.println(erg1);
        System.out.println(erg2);
        System.out.println("\n");
        System.out.println(this.modAll);
        System.out.println(ergMod1);
        System.out.println(ergMod2);
    }

    public void xtestAUX() {
        String polynomials = "(  (a^2*b*c + a*b^2*c + a*b*c^2 + a*b*c + a*b + a*c + b*c),(a^2*b^2*c + a*b^2*c^2 + a^2*b*c + a*b*c + b*c + a + c ),(a^2*b^2*c^2 + a^2*b^2*c + a*b^2*c + a*b*c + a*c + c + 1)) ";
        String orderINV = "(a,b,c)";
        String orderL = "(c,b,a)";
        String erg_deg = this.grad(orderINV, polynomials);
        System.out.println(this.grad);
        System.out.println(erg_deg);
        String erg1 = this.all(orderINV, polynomials);
        String erg2 = this.all(orderL, polynomials);
        String ergMod1 = this.modAll(orderINV, polynomials, 1831);
        String ergMod2 = this.modAll(orderL, polynomials, 1831);
        System.out.println(this.all);
        System.out.println(erg1);
        System.out.println(erg2);
        System.out.println("\n");
        System.out.println(this.modAll);
        System.out.println(ergMod1);
        System.out.println(ergMod2);
    }

    public void testC5() {
        String polynomials = "(  (a + b + c + d + e),(a*b + b*c + c*d + a*e + d*e),(a*b*c + b*c*d + a*b*e + a*d*e + c*d*e),(a*b*c*d + a*b*c*e + a*b*d*e + a*c*d*e + b*c*d*e),(a*b*c*d*e -1)) ";
        String orderINV = "(a,b,c,d,e)";
        String orderL = "(e,d,c,b,a)";
        String erg_deg = this.grad(orderINV, polynomials);
        String erg1 = this.all(orderINV, polynomials);
        String erg2 = this.all(orderL, polynomials);
        String ergMod1 = this.modAll(orderINV, polynomials, 1831);
        String ergMod2 = this.modAll(orderL, polynomials, 1831);
        System.out.println(this.grad);
        System.out.println(erg_deg);
        System.out.println("");
        System.out.println(this.all);
        System.out.println(erg1);
        System.out.println(erg2);
        System.out.println("\n");
        System.out.println(this.modAll);
        System.out.println(ergMod1);
        System.out.println(ergMod2);
    }

    public void xtestModC5() {
        String polynomials = "(  (a + b + c + d + e),(a*b + b*c + c*d + a*e + d*e),(a*b*c + b*c*d + a*b*e + a*d*e + c*d*e),(b*c*d + a*b*c*e + a*b*d*e + a*c*d*e + b*c*d*e),(a*b*c*d*e -1)) ";
        String orderINV = "(a,b,c,d,e)";
        String orderL = "(e,d,c,b,a)";
        String erg_deg = this.grad(orderL, polynomials);
        System.out.println(this.grad);
        System.out.println(erg_deg);
    }

    public void xtestC6() {
        String polynomials = "(  (a + b + c + d + e + f),(a*b + b*c + c*d + d*e + e*f + a*f),(a*b*c + b*c*d + c*d*e + d*e*f + a*e*f + a*b*f),(a*b*c*d + b*c*d*e + c*d*e*f + a*d*e*f + a*b*e*f + a*b*c*f),(a*b*c*d*e + b*c*d*e*f + a*c*d*e*f + a*b*d*e*f + a*b*c*e*f + a*b*c*d*f),(a*b*c*d*e*f - 1)) ";
        String orderINV = "(a,b,c,d,e,f)";
        String orderL = "(f,e,d,c,b,a)";
    }

    public void xtestIsaac() {
        String polynomials = "(  (8*w^2 + 5*w*x - 4*w*y + 2*w*z + 3*w + 5*x^2 + 2*x*y - 7*x*z - 7*x + 7*y^2 -8*y*z - 7*y + 7*z^2 - 8*z + 8),(3*w^2 - 5*w*x - 3*w*y - 6*w*z + 9*w + 4*x^2 + 2*x*y - 2*x*z + 7*x + 9*y^2 + 6*y*z + 5*y + 7*z^2 + 7*z + 5),(-2*w^2 + 9*w*x + 9*w*y - 7*w*z - 4*w + 8*x^2 + 9*x*y - 3*x*z + 8*x + 6*y^2 - 7*y*z + 4*y - 6*z^2 + 8*z + 2),(7*w^2 + 5*w*x + 3*w*y - 5*w*z - 5*w + 2*x^2 + 9*x*y - 7*x*z + 4*x -4*y^2 - 5*y*z + 6*y - 4*z^2 - 9*z + 2)) ";
        String orderINV = "(w,x,y,z)";
        String orderL = "(z,y,x,w)";
        String erg_deg = this.grad(orderL, polynomials);
        System.out.println(this.grad);
        System.out.println(erg_deg);
    }

    public void xtestNiermann() {
        String polynomials = "(  (x^2 + x*y^2*z - 2*x*y + y^4 + y^2 + z^2),(-x^3*y^2 + x*y^2*z + x*y*z^3 - 2*x*y + y^4),(-2*x^2*y + x*y^4 + y*z^4 - 3)) ";
        String orderINV = "(x,y,z)";
        String orderL = "(z,y,x)";
        String erg_deg = this.grad(orderINV, polynomials);
        System.out.println(this.grad);
        System.out.println(erg_deg);
        String ergm1 = this.modfglm(orderINV, polynomials, 1831);
        String ergm2 = this.modfglm(orderL, polynomials, 2147464751);
        System.out.println(this.modfglm);
        System.out.println(ergm1);
        System.out.println(ergm2);
    }

    public void ytestWalkS7() {
        String polynomials = "(  (2*g*b + 2*f*c + 2*e*d + a^2 + a),(2*g*c + 2*f*d + e^2 + 2*b*a + b),(2*g*d + 2*f*e + 2*c*a + c + b^2),(2*g*e + f^2 + 2*d*a + d + 2*c*b),(2*g*f + 2*e*a + e + 2*d*b + c^2),(g^2 + 2*f*a + f + 2*e*b + 2*d*c),(2*g*a + g + 2*f*b + 2*e*c + d^2)) ";
        String orderINV = "(a,b,c,d,e,f,g)";
        String orderL = "(g,f,e,d,c,b,a)";
        String erg2 = this.fglm(orderL, polynomials);
        System.out.println(this.fglm);
        System.out.println(erg2);
    }

    public void ytestCassouMod1() {
        String polynomials = "(  (15*a^4*b*c^2 + 6*a^4*b^3 + 21*a^4*b^2*c - 144*a^2*b - 8*a^2*b^2*d - 28*a^2*b*c*d - 648*a^2*c + 36*c^2*d + 9*a^4*c^3 - 120),(30*b^3*a^4*c - 32*c*d^2*b - 720*c*a^2*b - 24*b^3*a^2*d - 432*b^2*a^2 + 576*d*b - 576*c*d + 16*b*a^2*c^2*d + 16*c^2*d^2 + 16*d^2*b^2 + 9*b^4*a^4 + 5184 + 39*c^2*a^4*b^2 + 18*c^3*a^4*b - 432*c^2*a^2 + 24*c^3*a^2*d - 16*b^2*a^2*c*d - 240*b),(216*c*a^2*b - 162*c^2*a^2 - 81*b^2*a^2 + 5184 + 1008*d*b - 1008*c*d + 15*b^2*a^2*c*d - 15*b^3*a^2*d - 80*c*d^2*b + 40*c^2*d^2 + 40*d^2*b^2),(261 + 4*c*a^2*b - 3*c^2*a^2 - 4*b^2*a^2 + 22*d*b - 22*c*d)) ";
        String orderINV = "(a,b,c,d)";
        String orderL = "(d,c,b,a)";
        String ergm1 = this.modfglm(orderL, polynomials, 1831);
        String ergm2 = this.modfglm(orderINV, polynomials, 1831);
        System.out.println(this.modfglm);
        System.out.println(ergm1);
        System.out.println(ergm2);
    }

    public void ytestOmdi1() {
        String polynomials = "(  (a + c + v + 2*x - 1),(a*b + c*u + 2*v*w + 2*x*y + 2*x*z -2/3),(a*b^2 + c*u^2 + 2*v*w^2 + 2*x*y^2 + 2*x*z^2 - 2/5),(a*b^3 + c*u^3 + 2*v*w^3 + 2*x*y^3 + 2*x*z^3 - 2/7),(a*b^4 + c*u^4 + 2*v*w^4 + 2*x*y^4 + 2*x*z^4 - 2/9),(v*w^2 + 2*x*y*z - 1/9),(v*w^4 + 2*x*y^2*z^2 - 1/25),(v*w^3 + 2*x*y*z^2 + x*y^2*z - 1/15),(v*w^4 + x*y*z^3 + x*y^3*z -1/21)) ";
        String orderINV = "(a,b,c,u,v,w,x,y,z)";
        String orderL = "(z,y,x,w,v,u,c,b,a)";
        String erg_deg = this.grad(orderL, polynomials);
        System.out.println(this.grad);
        System.out.println(erg_deg);
    }

    public void ytestLamm1() {
        String polynomials = "(  (45*x^8 + 3*x^7 + 39*x^6 + 30*x^5 + 13*x^4 + 41*x^3 + 5*x^2 + 46*x + 7),(49*x^7*y + 35*x*y^7 + 37*x*y^6 + 9*y^7 + 4*x^6 + 6*y^6 + 27*x^3*y^2 + 20*x*y^4 + 31*x^4 + 33*x^2*y + 24*x^2 + 49*y + 43)) ";
        String orderINV = "(x,y)";
        String orderL = "(y,x)";
        String erg_deg = this.grad(orderINV, polynomials);
        System.out.println(this.grad);
        System.out.println(erg_deg);
        String erg1 = this.all(orderINV, polynomials);
        String erg2 = this.all(orderL, polynomials);
        String ergMod1 = this.modAll(orderINV, polynomials, 1831);
        String ergMod2 = this.modAll(orderL, polynomials, 1831);
        System.out.println(this.all);
        System.out.println(erg1);
        System.out.println(erg2);
        System.out.println("\n");
        System.out.println(this.modAll);
        System.out.println(ergMod1);
        System.out.println(ergMod2);
    }

    public void xtestEquilibrium() {
        String polynomials = "(  (y^4 - 20/7*z^2),(z^2*x^4 + 7/10*z*x^4 + 7/48*x^4 - 50/27*z^2 - 35/27*z - 49/216),(x^5*y^3 + 7/5*z^4*y^3 + 609/1000 *z^3*y^3 + 49/1250*z^2*y^3 - 27391/800000*z*y^3 - 1029/160000*y^3 + 3/7*z^5*x*y^2 +3/5*z^6*x*y^2 + 63/200*z^3*x*y^2 + 147/2000*z^2*x*y^2 + 4137/800000*z*x*y^2 - 7/20*z^4*x^2*y - 77/125*z^3*x^2*y- 23863/60000*z^2*x^2*y - 1078/9375*z*x^2*y - 24353/1920000*x^2*y - 3/20*z^4*x^3 - 21/100*z^3*x^3- 91/800*z^2*x^3 - 5887/200000*z*x^3 - 343/128000*x^3)) ";
        String order = "(x,y,z)";
        String ergOnlyG_1 = this.grad(order, polynomials);
        System.out.println(this.grad);
        System.out.println(ergOnlyG_1);
    }

    public void xtestTrinks2() {
        String polynomials = "(  (45*p + 35*s - 165*b - 36),(35*p + 40*z + 25*t - 27*s),(15*w + 25*p*s + 30*z - 18*t - 165*b^2),(-9*w + 15*p*t + 20*z*s),(w*p + 2*z*t - 11*b^3),(99*w - 11*s*b + 3*b^2),(b^2 + 33/50*b + 2673/10000)) ";
        String order1 = "(b,s,t,z,p,w)";
        String order2 = "(s,b,t,z,p,w)";
        String order3 = "(s,t,b,z,p,w)";
        String order4 = "(s,t,z,p,b,w)";
        String order5 = "(s,t,z,p,w,b)";
        String order6 = "(s,z,p,w,b,t)";
        String order7 = "(p,w,b,t,s,z)";
        String order8 = "(z,w,b,s,t,p)";
        String order9 = "(t,z,p,w,b,s)";
        String order10 = "(z,p,w,b,s,t)";
        String order11 = "(p,w,b,s,t,z)";
        String order12 = "(w,b,s,t,z,p)";
        String erg_1 = this.all(order1, polynomials);
        String erg_2 = this.all(order2, polynomials);
        String erg_3 = this.all(order3, polynomials);
        String erg_4 = this.all(order4, polynomials);
        String erg_5 = this.all(order5, polynomials);
        String erg_6 = this.all(order6, polynomials);
        String erg_7 = this.all(order7, polynomials);
        String erg_8 = this.all(order8, polynomials);
        String erg_9 = this.all(order9, polynomials);
        String erg_10 = this.all(order10, polynomials);
        String erg_11 = this.all(order11, polynomials);
        String erg_12 = this.all(order12, polynomials);
        System.out.println(this.all);
        System.out.println(erg_1);
        System.out.println(erg_2);
        System.out.println(erg_3);
        System.out.println(erg_4);
        System.out.println(erg_5);
        System.out.println(erg_6);
        System.out.println(erg_7);
        System.out.println(erg_8);
        System.out.println(erg_9);
        System.out.println(erg_10);
        System.out.println(erg_11);
        System.out.println(erg_12);
    }

    public void xtestHairerRungeKutta_1() {
        String polynomials = "(  (a-f),(b-h-g),(e+d+c-1),(d*a+c*b-1/2),(d*a^2+c*b^2-1/3),(c*g*a-1/6)) ";
        String[] order = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        String order1 = this.shuffle(order);
        String order2 = this.shuffle(order);
        String order3 = this.shuffle(order);
        String order4 = this.shuffle(order);
        String order5 = this.shuffle(order);
        String ergOnlyG_1 = this.grad(order1, polynomials);
        System.out.println(this.grad);
        System.out.println(ergOnlyG_1);
        String ergOnlyL_1 = this.lex(order1, polynomials);
        String ergOnlyL_2 = this.lex(order2, polynomials);
        String ergOnlyL_3 = this.lex(order3, polynomials);
        String ergOnlyL_4 = this.lex(order4, polynomials);
        String ergOnlyL_5 = this.lex(order5, polynomials);
        System.out.println(this.lex);
        System.out.println(ergOnlyL_1);
        System.out.println(ergOnlyL_2);
        System.out.println(ergOnlyL_3);
        System.out.println(ergOnlyL_4);
        System.out.println(ergOnlyL_5);
    }

    public String all(String order, String polynomials) {
        BigRational coeff = new BigRational();
        GroebnerBaseAbstract<BigRational> gb = GBFactory.getImplementation(coeff);
        String polynomials_Grad = order + " G " + polynomials;
        String polynomials_Lex = order + " L " + polynomials;
        StringReader sourceG = new StringReader(polynomials_Grad);
        GenPolynomialTokenizer parserG = new GenPolynomialTokenizer(sourceG);
        PolynomialList G = null;
        StringReader sourceL = new StringReader(polynomials_Lex);
        GenPolynomialTokenizer parserL = new GenPolynomialTokenizer(sourceL);
        PolynomialList L = null;
        try {
            G = parserG.nextPolynomialSet();
            L = parserL.nextPolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "fail";
        }
        System.out.println("Input " + G);
        System.out.println("Input " + L);
        long buchberger_Lex = System.currentTimeMillis();
        List GL = gb.GB(L.list);
        buchberger_Lex = System.currentTimeMillis() - buchberger_Lex;
        long buchberger_Grad = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> GG = gb.GB(G.list);
        buchberger_Grad = System.currentTimeMillis() - buchberger_Grad;
        GroebnerBaseFGLM<BigRational> IdealObjectFGLM = new GroebnerBaseFGLM<BigRational>();
        long tconv = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> resultFGLM = IdealObjectFGLM.convGroebnerToLex(GG);
        tconv = System.currentTimeMillis() - tconv;
        OrderedPolynomialList o1 = new OrderedPolynomialList(GG.get((int)0).ring, GG);
        OrderedPolynomialList o2 = new OrderedPolynomialList(resultFGLM.get((int)0).ring, resultFGLM);
        OrderedPolynomialList o3 = new OrderedPolynomialList(GL.get((int)0).ring, GL);
        int grad_numberOfElements = GG.size();
        int lex_numberOfElements = resultFGLM.size();
        long grad_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GG);
        long lex_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GL);
        int grad_height = this.bitHeight(GG);
        int lex_height = this.bitHeight(resultFGLM);
        System.out.println("Order of Variables: " + order);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + o1);
        System.out.println("Groebnerbase FGML (INVLEX) computed from Buchberger (IGRLEX) " + o2);
        System.out.println("Groebnerbase Buchberger (INVLEX) " + o3);
        String erg = "BigRational |" + order + " |" + grad_numberOfElements + "          |" + lex_numberOfElements + "          |" + grad_height + "   |" + lex_height + "           |" + grad_maxPolyGrad + "      |" + lex_maxPolyGrad + "    |" + buchberger_Grad + "      |" + tconv + "       |" + buchberger_Lex;
        GroebnerBaseFGLMExamples.assertEquals(o2, o3);
        return erg;
    }

    public String fglm(String order, String polynomials) {
        BigRational coeff = new BigRational();
        GroebnerBaseAbstract<BigRational> gb = GBFactory.getImplementation(coeff);
        String polynomials_Grad = order + " G " + polynomials;
        StringReader sourceG = new StringReader(polynomials_Grad);
        GenPolynomialTokenizer parserG = new GenPolynomialTokenizer(sourceG);
        PolynomialList G = null;
        try {
            G = parserG.nextPolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "fail";
        }
        System.out.println("Input " + G);
        long buchberger_Grad = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> GG = gb.GB(G.list);
        buchberger_Grad = System.currentTimeMillis() - buchberger_Grad;
        GroebnerBaseFGLM<BigRational> IdealObjectGrad = new GroebnerBaseFGLM<BigRational>();
        long tconv = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> resultFGLM = IdealObjectGrad.convGroebnerToLex(GG);
        tconv = System.currentTimeMillis() - tconv;
        OrderedPolynomialList o1 = new OrderedPolynomialList(GG.get((int)0).ring, GG);
        OrderedPolynomialList o2 = new OrderedPolynomialList(resultFGLM.get((int)0).ring, resultFGLM);
        int grad_numberOfElements = GG.size();
        int lex_numberOfElements = resultFGLM.size();
        long grad_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GG);
        long lex_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(resultFGLM);
        int grad_height = this.bitHeight(GG);
        int lex_height = this.bitHeight(resultFGLM);
        System.out.println("Order of Variables: " + order);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + o1);
        System.out.println("Groebnerbase FGML (INVLEX) computed from Buchberger (IGRLEX) " + o2);
        String erg = "BigRational |" + order + " |" + grad_numberOfElements + "         |" + lex_numberOfElements + "  |" + grad_height + "   |" + lex_height + "           |" + grad_maxPolyGrad + "      |" + lex_maxPolyGrad + "    |" + buchberger_Grad + "      |" + tconv;
        return erg;
    }

    public String grad(String order, String polynomials) {
        BigRational coeff = new BigRational();
        GroebnerBaseAbstract<BigRational> gb = GBFactory.getImplementation(coeff);
        String polynomials_Grad = order + " G " + polynomials;
        StringReader sourceG = new StringReader(polynomials_Grad);
        GenPolynomialTokenizer parserG = new GenPolynomialTokenizer(sourceG);
        PolynomialList G = null;
        try {
            G = parserG.nextPolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "fail";
        }
        System.out.println("Input " + G);
        long buchberger_Grad = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> GG = gb.GB(G.list);
        buchberger_Grad = System.currentTimeMillis() - buchberger_Grad;
        OrderedPolynomialList o1 = new OrderedPolynomialList(GG.get((int)0).ring, GG);
        GroebnerBaseFGLM<BigRational> IdealObjectGrad = new GroebnerBaseFGLM<BigRational>();
        long grad_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GG);
        List reducedTerms = IdealObjectGrad.redTerms(GG);
        OrderedPolynomialList o4 = new OrderedPolynomialList(reducedTerms.get((int)0).ring, reducedTerms);
        int grad_numberOfReducedElements = reducedTerms.size();
        int grad_numberOfElements = GG.size();
        int grad_height = this.bitHeight(GG);
        System.out.println("Order of Variables: " + order);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + o1);
        System.out.println("Reduced Terms" + o4);
        String erg = "BigRational |" + order + " |" + grad_numberOfElements + "    |" + grad_height + "    |" + grad_maxPolyGrad + "    |" + buchberger_Grad + "    |" + grad_numberOfReducedElements;
        return erg;
    }

    public String lex(String order, String polynomials) {
        BigRational coeff = new BigRational();
        GroebnerBaseAbstract<BigRational> gb = GBFactory.getImplementation(coeff);
        String polynomials_Lex = order + " L " + polynomials;
        StringReader sourceL = new StringReader(polynomials_Lex);
        GenPolynomialTokenizer parserL = new GenPolynomialTokenizer(sourceL);
        PolynomialList L = null;
        try {
            L = parserL.nextPolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "fail";
        }
        System.out.println("Input " + L);
        long buchberger_Lex = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> GL = gb.GB(L.list);
        buchberger_Lex = System.currentTimeMillis() - buchberger_Lex;
        OrderedPolynomialList o3 = new OrderedPolynomialList(GL.get((int)0).ring, GL);
        int lex_numberOfElements = GL.size();
        long lex_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GL);
        int lexHeigth = this.bitHeight(GL);
        System.out.println("Order of Variables: " + order);
        System.out.println("Groebnerbase Buchberger (INVLEX) " + o3);
        String erg = "BigRational" + order + "|" + lex_numberOfElements + "     |" + lexHeigth + "    |" + lex_maxPolyGrad + "    |" + buchberger_Lex;
        return erg;
    }

    public String modAll(String order, String polynomials, Integer m) {
        ModIntegerRing ring = new ModIntegerRing(m.intValue());
        GroebnerBaseAbstract<ModInteger> gb = GBFactory.getImplementation(ring);
        String polynomials_Grad = "Mod " + ring.modul + " " + order + " G " + polynomials;
        String polynomials_Lex = "Mod " + ring.modul + " " + order + " L " + polynomials;
        StringReader sourceG = new StringReader(polynomials_Grad);
        GenPolynomialTokenizer parserG = new GenPolynomialTokenizer(sourceG);
        PolynomialList G = null;
        StringReader sourceL = new StringReader(polynomials_Lex);
        GenPolynomialTokenizer parserL = new GenPolynomialTokenizer(sourceL);
        PolynomialList L = null;
        try {
            G = parserG.nextPolynomialSet();
            L = parserL.nextPolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "fail";
        }
        System.out.println("G= " + G);
        System.out.println("L= " + L);
        long buchberger_Lex = System.currentTimeMillis();
        List GL = gb.GB(L.list);
        buchberger_Lex = System.currentTimeMillis() - buchberger_Lex;
        long buchberger_Grad = System.currentTimeMillis();
        List GG = gb.GB(G.list);
        buchberger_Grad = System.currentTimeMillis() - buchberger_Grad;
        GroebnerBaseFGLM IdealObjectFGLM = new GroebnerBaseFGLM();
        long tconv = System.currentTimeMillis();
        List resultFGLM = IdealObjectFGLM.convGroebnerToLex(GG);
        tconv = System.currentTimeMillis() - tconv;
        OrderedPolynomialList o1 = new OrderedPolynomialList(GG.get((int)0).ring, GG);
        OrderedPolynomialList o2 = new OrderedPolynomialList(resultFGLM.get((int)0).ring, resultFGLM);
        List resultBuchberger = GL;
        OrderedPolynomialList o3 = new OrderedPolynomialList(resultBuchberger.get((int)0).ring, resultBuchberger);
        int grad_numberOfElements = GG.size();
        int lex_numberOfElements = resultFGLM.size();
        long grad_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GG);
        long lex_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GL);
        System.out.println("Order of Variables: " + order);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + o1);
        System.out.println("Groebnerbase FGML (INVLEX) computed from Buchberger (IGRLEX) " + o2);
        System.out.println("Groebnerbase Buchberger (INVLEX) " + o3);
        String erg = "Mod " + m + "    |" + order + " |" + grad_numberOfElements + "          |" + lex_numberOfElements + "          |" + grad_maxPolyGrad + "    |" + lex_maxPolyGrad + "    |" + buchberger_Grad + "     |" + tconv + "    |" + buchberger_Lex;
        GroebnerBaseFGLMExamples.assertEquals(o2, o3);
        return erg;
    }

    public String modGrad(String order, String polynomials, Integer m) {
        ModIntegerRing ring = new ModIntegerRing(m.intValue());
        GroebnerBaseAbstract<ModInteger> gb = GBFactory.getImplementation(ring);
        String polynomials_Grad = "Mod " + ring.modul + " " + order + " G " + polynomials;
        StringReader sourceG = new StringReader(polynomials_Grad);
        GenPolynomialTokenizer parserG = new GenPolynomialTokenizer(sourceG);
        PolynomialList G = null;
        try {
            G = parserG.nextPolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "fail";
        }
        System.out.println("G= " + G);
        long buchberger_Grad = System.currentTimeMillis();
        List GG = gb.GB(G.list);
        buchberger_Grad = System.currentTimeMillis() - buchberger_Grad;
        OrderedPolynomialList o1 = new OrderedPolynomialList(GG.get((int)0).ring, GG);
        int grad_numberOfElements = GG.size();
        long grad_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GG);
        System.out.println("Order of Variables: " + order);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + o1);
        String erg = "Mod " + m + "    |" + order + " |" + grad_numberOfElements + "           |" + grad_maxPolyGrad + "    |" + buchberger_Grad;
        return erg;
    }

    public String modfglm(String order, String polynomials, Integer m) {
        ModIntegerRing ring = new ModIntegerRing(m.intValue());
        GroebnerBaseAbstract<ModInteger> gb = GBFactory.getImplementation(ring);
        String polynomials_Grad = "Mod " + ring.modul + " " + order + " G " + polynomials;
        StringReader sourceG = new StringReader(polynomials_Grad);
        GenPolynomialTokenizer parserG = new GenPolynomialTokenizer(sourceG);
        PolynomialList G = null;
        try {
            G = parserG.nextPolynomialSet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "fail";
        }
        System.out.println("G= " + G);
        long buchberger_Grad = System.currentTimeMillis();
        List GG = gb.GB(G.list);
        buchberger_Grad = System.currentTimeMillis() - buchberger_Grad;
        GroebnerBaseFGLM IdealObjectFGLM = new GroebnerBaseFGLM();
        long tconv = System.currentTimeMillis();
        List resultFGLM = IdealObjectFGLM.convGroebnerToLex(GG);
        tconv = System.currentTimeMillis() - tconv;
        OrderedPolynomialList o1 = new OrderedPolynomialList(GG.get((int)0).ring, GG);
        OrderedPolynomialList o2 = new OrderedPolynomialList(resultFGLM.get((int)0).ring, resultFGLM);
        int grad_numberOfElements = GG.size();
        int lex_numberOfElements = resultFGLM.size();
        long grad_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(GG);
        long lex_maxPolyGrad = PolyUtil.totalDegreeLeadingTerm(resultFGLM);
        System.out.println("Order of Variables: " + order);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + o1);
        System.out.println("Groebnerbase FGML (INVLEX) computed from Buchberger (IGRLEX) " + o2);
        String erg = "Mod " + m + "    |" + order + " |" + grad_numberOfElements + "         |" + lex_numberOfElements + "           |" + grad_maxPolyGrad + "    |" + lex_maxPolyGrad + "    |" + buchberger_Grad + "     |" + tconv;
        return erg;
    }

    public String shuffle(String[] tempOrder) {
        Collections.shuffle(Arrays.asList(tempOrder));
        StringBuffer ret = new StringBuffer("(");
        ret.append(ExpVector.varsToString(tempOrder));
        ret.append(")");
        return ret.toString();
    }

    public int bitHeight(List<GenPolynomial<BigRational>> list) {
        BigInteger denom = BigInteger.ONE;
        BigInteger num = BigInteger.ONE;
        for (GenPolynomial<BigRational> g : list) {
            for (Monomial<BigRational> monomial : g) {
                BigRational bi = monomial.coefficient();
                BigInteger i = bi.denominator().abs();
                BigInteger j = bi.numerator().abs();
                if (i.compareTo(denom) > 0) {
                    denom = i;
                }
                if (j.compareTo(num) <= 0) continue;
                num = j;
            }
        }
        int erg = denom.compareTo(num) > 0 ? denom.bitLength() : num.bitLength();
        return erg;
    }
}

