/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gbmod.QuotSolvablePolynomialRing;
import edu.jas.gbmod.SolvableQuotient;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.GcdRingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class QuotSolvablePolynomial<C extends GcdRingElem<C>>
extends GenSolvablePolynomial<SolvableQuotient<C>> {
    public final QuotSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(QuotSolvablePolynomial.class);
    private final boolean debug = logger.isDebugEnabled();

    public QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> r) {
        super(r);
        this.ring = r;
    }

    public QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> r, SolvableQuotient<C> c, ExpVector e) {
        this(r);
        if (c != null && !c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> r, SolvableQuotient<C> c) {
        this(r, c, r.evzero);
    }

    public QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> r, GenSolvablePolynomial<SolvableQuotient<C>> S) {
        this(r, S.getMap());
    }

    protected QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> r, SortedMap<ExpVector, SolvableQuotient<C>> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public QuotSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public QuotSolvablePolynomial<C> copy() {
        return new QuotSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof QuotSolvablePolynomial)) {
            return false;
        }
        return super.equals(B);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(QuotSolvablePolynomial<C> Bp) {
        if (Bp == null || Bp.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (Bp.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return Bp;
        }
        assert (this.ring.nvar == Bp.ring.nvar);
        if (this.debug) {
            logger.debug((Object)("ring = " + this.ring));
        }
        ExpVector Z = this.ring.evzero;
        GenSolvablePolynomial Dp = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial zero = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        SolvableQuotient one = (SolvableQuotient)this.ring.getONECoefficient();
        Object C1 = null;
        Object C2 = null;
        SortedMap A = this.val;
        SortedMap B = Bp.val;
        Set Bk = B.entrySet();
        for (Map.Entry y : A.entrySet()) {
            SolvableQuotient a = (SolvableQuotient)y.getValue();
            ExpVector e = (ExpVector)y.getKey();
            if (this.debug) {
                logger.info((Object)("e = " + e + ", a = " + a));
            }
            int[] ep = e.dependencyOnVariables();
            int el1 = this.ring.nvar + 1;
            if (ep.length > 0) {
                el1 = ep[0];
            }
            for (Map.Entry x : Bk) {
                SolvableQuotient b = (SolvableQuotient)x.getValue();
                ExpVector f = (ExpVector)x.getKey();
                if (this.debug) {
                    logger.info((Object)("f = " + f + ", b = " + b));
                }
                int[] fp = f.dependencyOnVariables();
                int fl1 = 0;
                if (fp.length > 0) {
                    fl1 = fp[fp.length - 1];
                }
                int fl1s = this.ring.nvar + 1 - fl1;
                QuotSolvablePolynomial Cps = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
                if (this.ring.polCoeff.coeffTable.isEmpty() || b.isConstant() || e.isZERO()) {
                    Cps = new QuotSolvablePolynomial(this.ring, b, e);
                    if (this.debug) {
                        logger.info((Object)("symmetric coeff: b = " + b + ", e = " + e));
                    }
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric coeff: b = " + b + ", e = " + e));
                    }
                    if (b.den.isONE()) {
                        RecSolvablePolynomial rsp1 = new RecSolvablePolynomial(this.ring.polCoeff, e);
                        RecSolvablePolynomial rsp2 = new RecSolvablePolynomial(this.ring.polCoeff, b.num);
                        RecSolvablePolynomial rsp3 = rsp1.multiply(rsp2);
                        QuotSolvablePolynomial<C> rsp = this.ring.fromPolyCoefficients(rsp3);
                        Cps = rsp;
                    } else {
                        if (this.debug) {
                            logger.info((Object)("coeff-num: Cps = " + Cps + ", num = " + b.num + ", den = " + b.den));
                        }
                        QuotSolvablePolynomial qv = Cps = new QuotSolvablePolynomial<C>(this.ring, b.ring.getONE(), e);
                        SolvableQuotient qden = new SolvableQuotient(b.ring, b.den);
                        QuotSolvablePolynomial<QuotSolvablePolynomial<C>> v = qv.multiply(qden);
                        QuotSolvablePolynomial<C> vl = qv.multiplyLeft(qden);
                        QuotSolvablePolynomial vr = (QuotSolvablePolynomial)v.subtract(vl);
                        SolvableQuotient qdeni = new SolvableQuotient(b.ring, b.ring.ring.getONE(), b.den);
                        QuotSolvablePolynomial rq = vr.multiply(qdeni);
                        QuotSolvablePolynomial qp = (QuotSolvablePolynomial)qv.subtract(rq);
                        qp = qp.multiplyLeft(qdeni);
                        Cps = qp;
                        if (!b.num.isONE()) {
                            SolvableQuotient qnum = new SolvableQuotient(b.ring, b.num);
                            Cps = Cps.multiply(qnum);
                        }
                    }
                }
                if (this.debug) {
                    logger.info((Object)("coeff-den: Cps = " + Cps));
                }
                GenSolvablePolynomial Dps = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
                QuotSolvablePolynomial<C> Ds = null;
                if (this.ring.table.isEmpty() || Cps.isConstant() || f.isZERO()) {
                    if (this.debug) {
                        logger.info((Object)("symmetric poly: b = " + b + ", e = " + e));
                    }
                    ExpVector g = e.sum(f);
                    Ds = Cps.isConstant() ? new QuotSolvablePolynomial<C>(this.ring, (SolvableQuotient)Cps.leadingBaseCoefficient(), g) : this.shift(Cps, f);
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric poly: Cps = " + Cps + ", f = " + f));
                    }
                    for (Map.Entry z : Cps.val.entrySet()) {
                        int gl1s;
                        SolvableQuotient c = (SolvableQuotient)z.getValue();
                        ExpVector g = (ExpVector)z.getKey();
                        if (this.debug) {
                            logger.info((Object)("g = " + g + ", c = " + c));
                        }
                        int[] gp = g.dependencyOnVariables();
                        int gl1 = this.ring.nvar + 1;
                        if (gp.length > 0) {
                            gl1 = gp[0];
                        }
                        if ((gl1s = this.ring.nvar + 1 - gl1) <= fl1s) {
                            ExpVector h = g.sum(f);
                            if (this.debug) {
                                logger.info((Object)("disjoint poly: g = " + g + ", f = " + f + ", h = " + h));
                            }
                            Ds = (QuotSolvablePolynomial<C>)zero.sum(one, h);
                        } else {
                            QuotSolvablePolynomial<C> D1;
                            QuotSolvablePolynomial<C> D2;
                            ExpVector g1 = g.subst(gl1, 0L);
                            ExpVector g2 = Z.subst(gl1, g.getVal(gl1));
                            ExpVector f1 = f.subst(fl1, 0L);
                            ExpVector f2 = Z.subst(fl1, f.getVal(fl1));
                            if (this.debug) {
                                logger.info((Object)("poly, g1 = " + g1 + ", f1 = " + f1 + ", Dps = " + Dps));
                                logger.info((Object)("poly, g2 = " + g2 + ", f2 = " + f2));
                            }
                            TableRelation rel = this.ring.table.lookup(g2, f2);
                            if (this.debug) {
                                logger.info((Object)("poly, g  = " + g + ", f  = " + f + ", rel = " + rel));
                            }
                            Ds = new QuotSolvablePolynomial<C>(this.ring, rel.p);
                            if (rel.f != null) {
                                D2 = new QuotSolvablePolynomial<C>(this.ring, one, rel.f);
                                Ds = Ds.multiply(D2);
                                ExpVector g4 = rel.e == null ? g2 : g2.subtract(rel.e);
                                this.ring.table.update(g4, f2, Ds);
                            }
                            if (rel.e != null) {
                                D1 = new QuotSolvablePolynomial<C>(this.ring, one, rel.e);
                                Ds = D1.multiply(Ds);
                                this.ring.table.update(g2, f2, Ds);
                            }
                            if (!f1.isZERO()) {
                                D2 = new QuotSolvablePolynomial<C>(this.ring, one, f1);
                                Ds = Ds.multiply(D2);
                            }
                            if (!g1.isZERO()) {
                                D1 = new QuotSolvablePolynomial<C>(this.ring, one, g1);
                                Ds = D1.multiply(Ds);
                            }
                        }
                        Ds = Ds.multiplyLeft(c);
                        Dps = (QuotSolvablePolynomial)Dps.sum(Ds);
                    }
                    Ds = Dps;
                }
                Ds = Ds.multiplyLeft(a);
                if (this.debug) {
                    logger.debug((Object)("Ds = " + Ds));
                }
                Dp = (QuotSolvablePolynomial)Dp.sum(Ds);
            }
        }
        return Dp;
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(QuotSolvablePolynomial<C> S, QuotSolvablePolynomial<C> T) {
        if (S.isZERO() || T.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (S.isONE()) {
            return this.multiply(T);
        }
        if (T.isONE()) {
            return S.multiply(this);
        }
        return S.multiply(this).multiply(T);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(SolvableQuotient<C> b) {
        QuotSolvablePolynomial<C> Cp = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (b.isONE()) {
            return this;
        }
        Cp = new QuotSolvablePolynomial<C>(this.ring, b, this.ring.evzero);
        return this.multiply(Cp);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(SolvableQuotient<C> b, SolvableQuotient<C> c) {
        QuotSolvablePolynomial<C> Cp = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (c == null || c.isZERO()) {
            return Cp;
        }
        if (b.isONE() && c.isONE()) {
            return this;
        }
        Cp = new QuotSolvablePolynomial<C>(this.ring, b, this.ring.evzero);
        QuotSolvablePolynomial<C> Dp = new QuotSolvablePolynomial<C>(this.ring, c, this.ring.evzero);
        return this.multiply(Cp, Dp);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        SolvableQuotient b = (SolvableQuotient)this.ring.getONECoefficient();
        return this.multiply(b, e);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(ExpVector e, ExpVector f) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (f == null || f.isZERO()) {
            return this;
        }
        SolvableQuotient b = (SolvableQuotient)this.ring.getONECoefficient();
        return this.multiply(b, e, b, f);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(SolvableQuotient<C> b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (b.isONE() && e.isZERO()) {
            return this;
        }
        QuotSolvablePolynomial<C> Cp = new QuotSolvablePolynomial<C>(this.ring, b, e);
        return this.multiply(Cp);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(SolvableQuotient<C> b, ExpVector e, SolvableQuotient<C> c, ExpVector f) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (b.isONE() && e.isZERO() && c.isONE() && f.isZERO()) {
            return this;
        }
        QuotSolvablePolynomial<C> Cp = new QuotSolvablePolynomial<C>(this.ring, b, e);
        QuotSolvablePolynomial<C> Dp = new QuotSolvablePolynomial<C>(this.ring, c, f);
        return this.multiply(Cp, Dp);
    }

    @Override
    public QuotSolvablePolynomial<C> multiplyLeft(SolvableQuotient<C> b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        QuotSolvablePolynomial<C> Cp = new QuotSolvablePolynomial<C>(this.ring, b, e);
        return Cp.multiply(this);
    }

    @Override
    public QuotSolvablePolynomial<C> multiplyLeft(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        SolvableQuotient b = (SolvableQuotient)this.ring.getONECoefficient();
        QuotSolvablePolynomial<C> Cp = new QuotSolvablePolynomial<C>(this.ring, b, e);
        return Cp.multiply(this);
    }

    @Override
    public QuotSolvablePolynomial<C> multiplyLeft(SolvableQuotient<C> b) {
        GenSolvablePolynomial Cp = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((QuotSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            SolvableQuotient a = (SolvableQuotient)y.getValue();
            SolvableQuotient<SolvableQuotient> c = b.multiply(a);
            if (c.isZERO()) continue;
            Cm.put(e, c);
        }
        return Cp;
    }

    @Override
    public QuotSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, SolvableQuotient<C>> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(m.getValue(), m.getKey());
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(Map.Entry<ExpVector, SolvableQuotient<C>> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiply(m.getValue(), m.getKey());
    }

    protected QuotSolvablePolynomial<C> shift(QuotSolvablePolynomial<C> B, ExpVector f) {
        GenSolvablePolynomial C = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        if (B == null || B.isZERO()) {
            return C;
        }
        if (f == null || f.isZERO()) {
            return B;
        }
        SortedMap Cm = ((QuotSolvablePolynomial)C).val;
        SortedMap Bm = B.val;
        for (Map.Entry y : Bm.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            SolvableQuotient a = (SolvableQuotient)y.getValue();
            ExpVector d = e.sum(f);
            if (a.isZERO()) continue;
            Cm.put(d, a);
        }
        return C;
    }
}

