/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import java.util.List;

public class SolvableExtendedGB<C extends RingElem<C>> {
    public final List<GenSolvablePolynomial<C>> F;
    public final List<GenSolvablePolynomial<C>> G;
    public final List<List<GenSolvablePolynomial<C>>> F2G;
    public final List<List<GenSolvablePolynomial<C>>> G2F;
    public final GenSolvablePolynomialRing<C> ring;

    public SolvableExtendedGB(List<GenSolvablePolynomial<C>> F, List<GenSolvablePolynomial<C>> G, List<List<GenSolvablePolynomial<C>>> F2G, List<List<GenSolvablePolynomial<C>>> G2F) {
        this.F = F;
        this.G = G;
        this.F2G = F2G;
        this.G2F = G2F;
        GenSolvablePolynomialRing r = null;
        if (G != null) {
            for (GenSolvablePolynomial<C> p : G) {
                if (p == null) continue;
                r = p.ring;
                break;
            }
            if (r != null && r.getVars() == null) {
                r.setVars(r.newVars("y"));
            }
        }
        this.ring = r;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("SolvableExtendedGB: \n\n");
        PolynomialList<C> P = new PolynomialList<C>(this.ring, this.F);
        s.append("F = " + P + "\n\n");
        P = new PolynomialList<C>(this.ring, this.G);
        s.append("G = " + P + "\n\n");
        ModuleList<C> M = new ModuleList<C>(this.ring, this.F2G);
        s.append("F2G = " + M + "\n\n");
        M = new ModuleList<C>(this.ring, this.G2F);
        s.append("G2F = " + M + "\n");
        return s.toString();
    }
}

