/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.log4j.Logger;

class LeftSolvableReducer<C extends RingElem<C>>
implements Runnable {
    private final List<GenSolvablePolynomial<C>> G;
    private final PairList<C> pairlist;
    private final Terminator pool;
    private final SolvableReductionPar<C> sred;
    private static final Logger logger = Logger.getLogger(LeftSolvableReducer.class);
    private static final boolean debug = logger.isDebugEnabled();

    LeftSolvableReducer(Terminator fin, List<GenSolvablePolynomial<C>> G, PairList<C> L) {
        this.pool = fin;
        this.G = G;
        this.pairlist = L;
        this.sred = new SolvableReductionPar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean set = false;
        int reduction = 0;
        int sleeps = 0;
        while (this.pairlist.hasNext() || this.pool.hasJobs()) {
            List<GenSolvablePolynomial<C>> list;
            GenSolvablePolynomial S;
            Pair<C> pair;
            while (!this.pairlist.hasNext()) {
                this.pool.beIdle();
                set = true;
                try {
                    if (++sleeps % 10 == 0) {
                        logger.info((Object)" reducer is sleeping");
                    } else {
                        logger.debug((Object)"r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.pool.allIdle();
                    logger.info((Object)("shutdown " + this.pool + " after: " + e));
                    break;
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.pool.allIdle();
                    logger.info((Object)("shutdown after .isInterrupted(): " + this.pool));
                    break;
                }
                if (this.pool.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.pool.hasJobs()) break;
            if (set) {
                this.pool.notIdle();
                set = false;
            }
            if ((pair = this.pairlist.removeNext()) == null) continue;
            if (debug) {
                logger.debug((Object)("pi = " + pair.pi));
                logger.debug((Object)("pj = " + pair.pj));
            }
            if ((S = this.sred.leftSPolynomial((GenSolvablePolynomial)pair.pi, (GenSolvablePolynomial)pair.pj)).isZERO()) continue;
            if (debug) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            GenPolynomial H = this.sred.leftNormalform(this.G, S);
            ++reduction;
            if (H.isZERO()) continue;
            if (debug) {
                logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if ((H = ((GenSolvablePolynomial)H).monic()).isONE()) {
                this.pairlist.putOne();
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add((GenSolvablePolynomial<C>)H);
                }
                this.pool.allIdle();
                return;
            }
            if (debug) {
                logger.debug((Object)("H = " + H));
            }
            list = this.G;
            synchronized (list) {
                this.G.add((GenSolvablePolynomial<C>)H);
            }
            this.pairlist.put(H);
        }
        logger.info((Object)("terminated, done " + reduction + " reductions"));
    }
}

