/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.HybridReducerReceiver;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

class HybridReducerServer<C extends RingElem<C>>
implements Runnable {
    public static final Logger logger = Logger.getLogger(HybridReducerServer.class);
    public final boolean debug = logger.isDebugEnabled();
    private final Terminator finner;
    private final ChannelFactory cf;
    private TaggedSocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final PairList<C> pairlist;
    private final int threadsPerNode;
    public final Integer pairTag = GroebnerBaseDistributedHybrid.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybrid.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybrid.ackTag;

    HybridReducerServer(int tpn, Terminator fin, ChannelFactory cf, DistHashTable<Integer, GenPolynomial<C>> dl, PairList<C> L) {
        this.threadsPerNode = tpn;
        this.finner = fin;
        this.cf = cf;
        this.theList = dl;
        this.pairlist = L;
    }

    @Override
    public void run() {
        HybridReducerReceiver<C> receiver;
        AtomicInteger active;
        SocketChannel channel;
        block21: {
            logger.info((Object)("reducer server running with " + this.cf));
            channel = null;
            try {
                channel = this.cf.getChannel();
                this.pairChannel = new TaggedSocketChannel(channel);
                this.pairChannel.init();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"get pair channel interrupted");
                e.printStackTrace();
                return;
            }
            if (this.debug) {
                logger.info((Object)("pairChannel   = " + this.pairChannel));
            }
            this.finner.initIdle(this.threadsPerNode);
            active = new AtomicInteger(0);
            receiver = new HybridReducerReceiver<C>(this.threadsPerNode, this.finner, active, this.pairChannel, this.theList, this.pairlist);
            receiver.start();
            boolean goon = true;
            int red = 0;
            int sleeps = 0;
            while (goon) {
                logger.debug((Object)"receive request");
                Object req = null;
                try {
                    req = this.pairChannel.receive(this.pairTag);
                }
                catch (InterruptedException e) {
                    goon = false;
                    e.printStackTrace();
                }
                catch (IOException e) {
                    goon = false;
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    goon = false;
                    e.printStackTrace();
                }
                logger.info((Object)("received request, req = " + req));
                if (req == null) {
                    goon = false;
                    break;
                }
                if (!(req instanceof GBTransportMessReq)) {
                    goon = false;
                    break;
                }
                logger.info((Object)"find pair");
                while (!this.pairlist.hasNext()) {
                    if (!this.finner.hasJobs() && !this.pairlist.hasNext()) {
                        goon = false;
                        break;
                    }
                    try {
                        ++sleeps;
                        logger.info((Object)("waiting for reducers, remaining = " + this.finner.getJobs()));
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        goon = false;
                        break;
                    }
                }
                if (!this.pairlist.hasNext() && !this.finner.hasJobs()) {
                    logger.info((Object)"termination detection: no pairs and no jobs left");
                    goon = false;
                    break;
                }
                this.finner.notIdle();
                Pair<C> pair = this.pairlist.removeNext();
                if (this.debug) {
                    logger.info((Object)("active count = " + active.get()));
                    logger.info((Object)("send pair = " + pair));
                }
                GBTransportMess msg = null;
                msg = pair != null ? new GBTransportMessPairIndex(pair) : new GBTransportMess();
                try {
                    ++red;
                    this.pairChannel.send(this.pairTag, msg);
                    int a = active.getAndIncrement();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    goon = false;
                    break;
                }
            }
            logger.info((Object)("terminated, send " + red + " reduction pairs"));
            logger.debug((Object)"send end");
            try {
                for (int i = 0; i < this.threadsPerNode; ++i) {
                    this.pairChannel.send(this.pairTag, new GBTransportMessEnd());
                }
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block21;
                e.printStackTrace();
            }
        }
        receiver.terminate();
        int d = active.get();
        logger.info((Object)("remaining active tasks = " + d));
        this.pairChannel.close();
        logger.info((Object)"redServ pairChannel.close()");
        this.finner.release();
        channel.close();
        logger.info((Object)"redServ channel.close()");
    }
}

