/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairComparator;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CriticalPairList<C extends RingElem<C>>
extends OrderedPairlist<C> {
    protected final SortedSet<CriticalPair<C>> pairlist;
    protected int recordCount;
    private static final Logger logger = Logger.getLogger(CriticalPairList.class);

    public CriticalPairList() {
        this.pairlist = null;
    }

    public CriticalPairList(GenPolynomialRing<C> r) {
        this(0, r);
    }

    public CriticalPairList(int m, GenPolynomialRing<C> r) {
        super(m, r);
        CriticalPairComparator cpc = new CriticalPairComparator(this.ring.tord);
        this.pairlist = new TreeSet(cpc);
        this.recordCount = 0;
    }

    @Override
    public PairList<C> create(GenPolynomialRing<C> r) {
        return new CriticalPairList<C>(r);
    }

    @Override
    public PairList<C> create(int m, GenPolynomialRing<C> r) {
        return new CriticalPairList<C>(m, r);
    }

    @Override
    public synchronized int put(GenPolynomial<C> p) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector e = p.leadingExpVector();
        int len = this.P.size();
        for (int j = 0; j < len; ++j) {
            GenPolynomial pj = (GenPolynomial)this.P.get(j);
            ExpVector f = pj.leadingExpVector();
            if (this.moduleVars > 0 && !this.reduction.moduleCriterion(this.moduleVars, e, f)) continue;
            ExpVector g = e.lcm(f);
            CriticalPair<C> pair = new CriticalPair<C>(g, pj, p, j, len);
            this.pairlist.add(pair);
        }
        this.P.add(p);
        BitSet redi = new BitSet();
        redi.set(0, len);
        this.red.add(redi);
        if (this.recordCount < len) {
            this.recordCount = len;
        }
        return len;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    @Override
    public Pair<C> removeNext() {
        CriticalPair<C> cp = this.getNext();
        if (cp == null) {
            return null;
        }
        return new Pair(cp.pi, cp.pj, cp.i, cp.j);
    }

    public synchronized CriticalPair<C> getNext() {
        if (this.oneInGB) {
            return null;
        }
        CriticalPair pair = null;
        Iterator ip = this.pairlist.iterator();
        boolean c = false;
        while (!c && ip.hasNext()) {
            pair = (CriticalPair)ip.next();
            if (pair.getInReduction() || pair.getReductum() != null) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("" + pair));
            }
            if (c = this.useCriterion4 ? this.reduction.criterion4(pair.pi, pair.pj, pair.e) : true) {
                c = this.criterion3(pair.i, pair.j, pair.e);
            }
            ((BitSet)this.red.get(pair.j)).clear(pair.i);
            if (c) continue;
            pair.setReductum(this.ring.getZERO());
        }
        if (!c) {
            pair = null;
        } else {
            ++this.remCount;
            pair.setInReduction();
        }
        return pair;
    }

    public int record(CriticalPair<C> pair, GenPolynomial<C> p) {
        if (p == null) {
            p = this.ring.getZERO();
        }
        pair.setReductum((GenPolynomial<C>)p);
        if (!((GenPolynomial)p).isZERO() && !((GenPolynomial)p).isONE()) {
            ++this.recordCount;
            return this.recordCount;
        }
        return -1;
    }

    public int update(CriticalPair<C> pair, GenPolynomial<C> p) {
        int c;
        if (p == null) {
            p = this.ring.getZERO();
        }
        pair.setReductum((GenPolynomial<C>)p);
        if (!((GenPolynomial)p).isZERO() && !((GenPolynomial)p).isONE()) {
            ++this.recordCount;
        }
        if ((c = this.update()) < 0) {
            System.out.println("c < 0");
        }
        if (!((GenPolynomial)p).isZERO() && !((GenPolynomial)p).isONE()) {
            return this.recordCount;
        }
        return -1;
    }

    public synchronized int update() {
        CriticalPair<C> pair;
        GenPolynomial<C> p;
        int num = 0;
        if (this.oneInGB) {
            return num;
        }
        while (this.pairlist.size() > 0 && (p = (pair = this.pairlist.first()).getReductum()) != null) {
            this.pairlist.remove(pair);
            ++num;
            if (p.isZERO()) continue;
            if (p.isONE()) {
                this.putOne();
                continue;
            }
            this.put(p);
        }
        return num;
    }

    public synchronized List<CriticalPair<C>> inWork() {
        ArrayList<CriticalPair<C>> iw = new ArrayList<CriticalPair<C>>();
        if (this.oneInGB) {
            return iw;
        }
        for (CriticalPair criticalPair : this.pairlist) {
            if (!criticalPair.getInReduction()) continue;
            iw.add(criticalPair);
        }
        return iw;
    }

    public synchronized int updateMany() {
        CriticalPair pair2;
        int num = 0;
        if (this.oneInGB) {
            return num;
        }
        ArrayList<CriticalPair> rem = new ArrayList<CriticalPair>();
        Iterator i$ = this.pairlist.iterator();
        while (i$.hasNext() && (pair2 = (CriticalPair)i$.next()).getReductum() != null) {
            rem.add(pair2);
            ++num;
        }
        for (CriticalPair pair2 : rem) {
            this.pairlist.remove(pair2);
            GenPolynomial p = pair2.getReductum();
            if (p.isZERO()) continue;
            if (p.isONE()) {
                this.putOne();
                continue;
            }
            this.put(p);
        }
        return num;
    }

    @Override
    public synchronized int putOne() {
        super.putOne();
        this.pairlist.clear();
        return 0;
    }
}

