/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisor;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class GreatestCommonDivisorAbstract<C extends GcdRingElem<C>>
implements GreatestCommonDivisor<C> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    final SolvableSyzygyAbstract<C> syz = new SolvableSyzygyAbstract();

    public String toString() {
        return this.getClass().getName();
    }

    public C baseContent(GenSolvablePolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (P.isZERO()) {
            return (C)((GcdRingElem)P.ring.getZEROCoefficient());
        }
        AbelianGroupElem d = null;
        for (GcdRingElem c : P.getMap().values()) {
            if (!(d = d == null ? c : d.gcd(c)).isONE()) continue;
            return (C)d;
        }
        if (d.signum() < 0) {
            d = (GcdRingElem)d.negate();
        }
        return (C)d;
    }

    public GenSolvablePolynomial<C> basePrimitivePart(GenSolvablePolynomial<C> P) {
        GenPolynomial p;
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (P.isZERO()) {
            return P;
        }
        C d = this.baseContent(P);
        if (d.isONE()) {
            return P;
        }
        GenSolvablePolynomial pp = (GenSolvablePolynomial)P.divide(d);
        if (this.debug && !((GenSolvablePolynomial)(p = pp.multiply((RingElem)d))).equals(P)) {
            throw new ArithmeticException("pp(p)*cont(p) != p: ");
        }
        return pp;
    }

    public abstract GenSolvablePolynomial<C> baseGcd(GenSolvablePolynomial<C> var1, GenSolvablePolynomial<C> var2);

    public GenSolvablePolynomial<C> recursiveContent(GenSolvablePolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (P.isZERO()) {
            return (GenSolvablePolynomial)P.ring.getZEROCoefficient();
        }
        GenSolvablePolynomial<C> d = null;
        for (GenPolynomial cp : P.getMap().values()) {
            GenSolvablePolynomial c = (GenSolvablePolynomial)cp;
            if (!(d = d == null ? c : this.gcd(d, c)).isONE()) continue;
            return d;
        }
        return (GenSolvablePolynomial)d.abs();
    }

    public GenSolvablePolynomial<GenPolynomial<C>> recursivePrimitivePart(GenSolvablePolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenSolvablePolynomial<C> d = this.recursiveContent(P);
        if (d.isONE()) {
            return P;
        }
        if (this.debug) {
            logger.info((Object)("content(P) = " + d));
        }
        GenSolvablePolynomial<GenPolynomial<C>> pp = FDUtil.recursiveDivide(P, d);
        return pp;
    }

    public C baseRecursiveContent(GenSolvablePolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (P.isZERO()) {
            GenSolvablePolynomialRing cf = (GenSolvablePolynomialRing)P.ring.coFac;
            return (C)((GcdRingElem)cf.coFac.getZERO());
        }
        AbelianGroupElem d = null;
        for (GenPolynomial cp : P.getMap().values()) {
            GenSolvablePolynomial c = (GenSolvablePolynomial)cp;
            C cc = this.baseContent(c);
            if (!(d = d == null ? cc : this.gcd(d, cc)).isONE()) continue;
            return (C)d;
        }
        if (d.signum() < 0) {
            d = (GcdRingElem)d.negate();
        }
        return (C)d;
    }

    public GenSolvablePolynomial<GenPolynomial<C>> baseRecursivePrimitivePart(GenSolvablePolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (P.isZERO()) {
            return P;
        }
        C d = this.baseRecursiveContent(P);
        if (d.isONE()) {
            return P;
        }
        GenSolvablePolynomial pp = (GenSolvablePolynomial)PolyUtil.baseRecursiveDivide(P, d);
        return pp;
    }

    public GenSolvablePolynomial<GenPolynomial<C>> recursiveGcd(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        GenSolvablePolynomialRing dfac;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar <= 1) {
            return this.recursiveUnivariateGcd(P, S);
        }
        GenSolvablePolynomialRing rfac = P.ring;
        if (rfac instanceof RecSolvablePolynomialRing) {
            RecSolvablePolynomialRing rf = (RecSolvablePolynomialRing)rfac;
            dfac = RecSolvablePolynomialRing.distribute(rf);
        } else {
            GenSolvablePolynomialRing df = rfac;
            dfac = df.distribute();
        }
        GenSolvablePolynomial Pd = (GenSolvablePolynomial)PolyUtil.distribute(dfac, P);
        GenSolvablePolynomial Sd = (GenSolvablePolynomial)PolyUtil.distribute(dfac, S);
        GenSolvablePolynomial<C> Dd = this.gcd(Pd, Sd);
        GenSolvablePolynomial C = (GenSolvablePolynomial)PolyUtil.recursive(rfac, Dd);
        return C;
    }

    public abstract GenSolvablePolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> var1, GenSolvablePolynomial<GenPolynomial<C>> var2);

    @Override
    public GenSolvablePolynomial<C> content(GenSolvablePolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        GenSolvablePolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            throw new IllegalArgumentException("use baseContent() for univariate polynomials");
        }
        GenPolynomialRing rfac = pfac.recursive(1);
        RecSolvablePolynomial Pr = (RecSolvablePolynomial)PolyUtil.recursive(rfac, P);
        GenSolvablePolynomial<C> D = this.recursiveContent(Pr);
        return D;
    }

    @Override
    public GenSolvablePolynomial<C> primitivePart(GenSolvablePolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenSolvablePolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.basePrimitivePart(P);
        }
        GenPolynomialRing rfac = pfac.recursive(1);
        RecSolvablePolynomial Pr = (RecSolvablePolynomial)PolyUtil.recursive(rfac, P);
        GenSolvablePolynomial<GenPolynomial<C>> PP = this.recursivePrimitivePart(Pr);
        GenSolvablePolynomial D = (GenSolvablePolynomial)PolyUtil.distribute(pfac, PP);
        return D;
    }

    public GenSolvablePolynomial<C> divide(GenSolvablePolynomial<C> a, C b) {
        if (b == null || b.isZERO()) {
            throw new IllegalArgumentException("division by zero");
        }
        if (a == null || a.isZERO()) {
            return a;
        }
        return (GenSolvablePolynomial)a.divide(b);
    }

    public C gcd(C a, C b) {
        if (b == null || b.isZERO()) {
            return a;
        }
        if (a == null || a.isZERO()) {
            return b;
        }
        return (C)((GcdRingElem)a.gcd(b));
    }

    @Override
    public GenSolvablePolynomial<C> gcd(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        GenSolvablePolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            GenSolvablePolynomial<C> T = this.baseGcd(P, S);
            return T;
        }
        GenPolynomialRing rfac = pfac.recursive(1);
        RecSolvablePolynomial Pr = (RecSolvablePolynomial)PolyUtil.recursive(rfac, P);
        RecSolvablePolynomial Sr = (RecSolvablePolynomial)PolyUtil.recursive(rfac, S);
        GenSolvablePolynomial<GenPolynomial<C>> Dr = this.recursiveUnivariateGcd(Pr, Sr);
        GenSolvablePolynomial D = (GenSolvablePolynomial)PolyUtil.distribute(pfac, Dr);
        return D;
    }

    @Override
    public GenSolvablePolynomial<C> lcm(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        GenSolvablePolynomial<C>[] oc = this.leftOreCond(P, S);
        return oc[0].multiply(P);
    }

    public GenSolvablePolynomial<C> gcd(List<GenSolvablePolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            throw new IllegalArgumentException("A may not be empty");
        }
        GenSolvablePolynomial<C> g = A.get(0);
        for (int i = 1; i < A.size(); ++i) {
            GenSolvablePolynomial<C> f = A.get(i);
            g = this.gcd(g, f);
        }
        return g;
    }

    @Override
    public List<GenSolvablePolynomial<C>> coPrime(List<GenSolvablePolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return A;
        }
        List<GenSolvablePolynomial<C>> B = new ArrayList<GenSolvablePolynomial<C>>(A.size());
        GenSolvablePolynomial a = A.get(0);
        if (!a.isZERO() && !a.isConstant()) {
            for (int i = 1; i < A.size(); ++i) {
                GenSolvablePolynomial<C> b = A.get(i);
                GenSolvablePolynomial g = (GenSolvablePolynomial)this.gcd(a, b).abs();
                if (!g.isONE()) {
                    a = FDUtil.basePseudoQuotient(a, g);
                    b = FDUtil.basePseudoQuotient(b, g);
                    GenSolvablePolynomial gp = this.gcd(a, g);
                    while (!gp.isONE()) {
                        a = FDUtil.basePseudoQuotient(a, gp);
                        g = FDUtil.basePseudoQuotient(g, gp);
                        B.add(g);
                        g = gp;
                        gp = this.gcd(a, gp);
                    }
                    if (!g.isZERO() && !g.isConstant()) {
                        B.add(g);
                    }
                }
                if (b.isZERO() || b.isConstant()) continue;
                B.add(b);
            }
        } else {
            B.addAll(A.subList(1, A.size()));
        }
        B = this.coPrime(B);
        if (!a.isZERO() && !a.isConstant()) {
            a = (GenSolvablePolynomial)a.abs();
            B.add(a);
        }
        return B;
    }

    public List<GenSolvablePolynomial<C>> coPrimeRec(List<GenSolvablePolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return A;
        }
        List<GenSolvablePolynomial<C>> B = new ArrayList<GenSolvablePolynomial<C>>();
        for (GenSolvablePolynomial<C> a : A) {
            B = this.coPrime(a, B);
        }
        return B;
    }

    public List<GenSolvablePolynomial<C>> coPrime(GenSolvablePolynomial<C> a, List<GenSolvablePolynomial<C>> P) {
        if (a == null || a.isZERO() || a.isConstant()) {
            return P;
        }
        ArrayList<GenSolvablePolynomial<C>> B = new ArrayList<GenSolvablePolynomial<C>>(P.size() + 1);
        for (int i = 0; i < P.size(); ++i) {
            GenSolvablePolynomial<C> b = P.get(i);
            GenSolvablePolynomial<C> g = this.gcd(a, b);
            if (!g.isONE()) {
                a = FDUtil.basePseudoQuotient(a, g);
                b = FDUtil.basePseudoQuotient(b, g);
                GenSolvablePolynomial<C> gp = this.gcd(a, g);
                while (!gp.isONE()) {
                    a = FDUtil.basePseudoQuotient(a, gp);
                    if (!(g = FDUtil.basePseudoQuotient(g, gp)).isZERO() && !g.isConstant()) {
                        B.add(g);
                    }
                    g = gp;
                    gp = this.gcd(a, gp);
                }
                gp = this.gcd(b, g);
                while (!gp.isONE()) {
                    b = FDUtil.basePseudoQuotient(b, gp);
                    if (!(g = FDUtil.basePseudoQuotient(g, gp)).isZERO() && !g.isConstant()) {
                        B.add(g);
                    }
                    g = gp;
                    gp = this.gcd(b, gp);
                }
                if (!g.isZERO() && !g.isConstant()) {
                    B.add(g);
                }
            }
            if (b.isZERO() || b.isConstant()) continue;
            B.add(b);
        }
        if (!a.isZERO() && !a.isConstant()) {
            B.add(a);
        }
        return B;
    }

    @Override
    public boolean isCoPrime(List<GenSolvablePolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return true;
        }
        if (A.size() == 1) {
            return true;
        }
        for (int i = 0; i < A.size(); ++i) {
            GenSolvablePolynomial<C> a = A.get(i);
            for (int j = i + 1; j < A.size(); ++j) {
                GenSolvablePolynomial<C> b = A.get(j);
                GenSolvablePolynomial<C> g = this.gcd(a, b);
                if (g.isONE()) continue;
                System.out.println("not co-prime, a: " + a);
                System.out.println("not co-prime, b: " + b);
                System.out.println("not co-prime, g: " + g);
                return false;
            }
        }
        return true;
    }

    public boolean isCoPrime(List<GenSolvablePolynomial<C>> P, List<GenSolvablePolynomial<C>> A) {
        if (!this.isCoPrime(P)) {
            return false;
        }
        if (A == null || A.isEmpty()) {
            return true;
        }
        for (GenSolvablePolynomial<C> q : A) {
            if (q.isZERO() || q.isConstant()) continue;
            boolean divides = false;
            for (GenSolvablePolynomial<C> p : P) {
                GenSolvablePolynomial<C> a = FDUtil.baseSparsePseudoRemainder(q, p);
                if (!a.isZERO()) continue;
                divides = true;
                break;
            }
            if (divides) continue;
            System.out.println("no divisor for: " + q);
            return false;
        }
        return true;
    }

    public GenSolvablePolynomial<C>[] baseExtendedGcd(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        GenSolvablePolynomial<C>[] hegcd = this.baseHalfExtendedGcd(P, S);
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[3];
        ret[0] = hegcd[0];
        ret[1] = hegcd[1];
        GenSolvablePolynomial x = (GenSolvablePolynomial)hegcd[0].subtract(hegcd[1].multiply(P));
        GenSolvablePolynomial<C>[] qr = FDUtil.basePseudoQuotientRemainder(x, S);
        ret[2] = qr[0];
        return ret;
    }

    public GenSolvablePolynomial<C>[] baseHalfExtendedGcd(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[]{null, null};
        if (S == null || S.isZERO()) {
            ret[0] = P;
            ret[1] = P.ring.getONE();
            return ret;
        }
        if (P == null || P.isZERO()) {
            ret[0] = S;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        if (P.ring.nvar != 1) {
            throw new IllegalArgumentException("for univariate polynomials only " + P.ring);
        }
        GenPolynomial q = P;
        GenSolvablePolynomial<C> r = S;
        GenPolynomial c1 = ((GenSolvablePolynomial)P.ring.getONE()).copy();
        GenPolynomial d1 = ((GenSolvablePolynomial)P.ring.getZERO()).copy();
        while (!r.isZERO()) {
            GenSolvablePolynomial<C>[] qr = FDUtil.basePseudoQuotientRemainder(q, r);
            q = qr[0];
            GenSolvablePolynomial x = (GenSolvablePolynomial)c1.subtract(q.multiply(d1));
            c1 = d1;
            d1 = x;
            q = r;
            r = qr[1];
        }
        GcdRingElem g = (GcdRingElem)q.leadingBaseCoefficient();
        if (g.isUnit()) {
            GcdRingElem h = (GcdRingElem)g.inverse();
            q = q.multiply(h);
            c1 = ((GenSolvablePolynomial)c1).multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        return ret;
    }

    public GenSolvablePolynomial<C>[] baseGcdDiophant(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S, GenSolvablePolynomial<C> c) {
        GenSolvablePolynomial y;
        GenSolvablePolynomial<C>[] egcd = this.baseExtendedGcd(P, S);
        GenSolvablePolynomial<C> g = egcd[0];
        GenSolvablePolynomial<Object>[] qr = FDUtil.basePseudoQuotientRemainder(c, g);
        if (!qr[1].isZERO()) {
            throw new ArithmeticException("not solvable, r = " + qr[1] + ", c = " + c + ", g = " + g);
        }
        GenSolvablePolynomial<C> q = qr[0];
        GenSolvablePolynomial<Object> a = egcd[1].multiply(q);
        GenSolvablePolynomial b = egcd[2].multiply(q);
        if (!a.isZERO() && a.degree(0) >= S.degree(0)) {
            qr = FDUtil.basePseudoQuotientRemainder(a, S);
            a = qr[1];
            b = (GenSolvablePolynomial)b.sum(P.multiply(qr[0]));
        }
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[]{a, b};
        if (this.debug && !(y = (GenSolvablePolynomial)ret[0].multiply(P).sum(ret[1].multiply(S))).equals(c)) {
            System.out.println("P  = " + P);
            System.out.println("S  = " + S);
            System.out.println("c  = " + c);
            System.out.println("a  = " + a);
            System.out.println("b  = " + b);
            System.out.println("y  = " + y);
            throw new ArithmeticException("not diophant, x = " + y.subtract(c));
        }
        return ret;
    }

    public C[] leftOreCond(C a, C b) {
        if (a == null || a.isZERO() || b == null || b.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        Object[] oc = new GcdRingElem[2];
        if (a instanceof GenSolvablePolynomial && b instanceof GenSolvablePolynomial) {
            GenSolvablePolynomial ap = (GenSolvablePolynomial)a;
            GenSolvablePolynomial bp = (GenSolvablePolynomial)b;
            GenSolvablePolynomial<C>[] ocp = this.leftOreCond(ap, bp);
            oc[0] = (GcdRingElem)((Object)ocp[0]);
            oc[1] = (GcdRingElem)((Object)ocp[1]);
            return oc;
        }
        RingFactory rf = (RingFactory)a.factory();
        if (a.equals(b)) {
            oc[0] = (GcdRingElem)rf.getONE();
            oc[1] = (GcdRingElem)rf.getONE();
            return oc;
        }
        if (rf.isCommutative()) {
            logger.info((Object)("left Ore condition on coefficients, commutative case: " + a + ", " + b));
            GcdRingElem gcd = (GcdRingElem)a.gcd(b);
            GcdRingElem p = (GcdRingElem)a.multiply(b);
            GcdRingElem lcm = p.divide(gcd);
            oc[0] = (GcdRingElem)lcm.divide(a);
            oc[1] = (GcdRingElem)lcm.divide(b);
            logger.info((Object)("Ore multiple: " + lcm + ", " + Arrays.toString(oc)));
            return oc;
        }
        throw new UnsupportedOperationException("leftOreCond not implemented for " + rf.toScript());
    }

    public GenSolvablePolynomial<C>[] leftOreCond(GenSolvablePolynomial<C> a, GenSolvablePolynomial<C> b) {
        if (a == null || a.isZERO() || b == null || b.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        GenSolvablePolynomialRing pfac = a.ring;
        Object[] oc = new GenSolvablePolynomial[2];
        if (a.equals(b)) {
            oc[0] = pfac.getONE();
            oc[1] = pfac.getONE();
            return oc;
        }
        if (pfac.isCommutative()) {
            logger.info((Object)("left Ore condition, polynomial commutative case: " + a + ", " + b));
            edu.jas.ufd.GreatestCommonDivisorAbstract<C> cgcd = GCDFactory.getImplementation(pfac.coFac);
            GenSolvablePolynomial lcm = (GenSolvablePolynomial)cgcd.lcm(a, b);
            oc[0] = (GenSolvablePolynomial)PolyUtil.basePseudoDivide(lcm, a);
            oc[1] = (GenSolvablePolynomial)PolyUtil.basePseudoDivide(lcm, b);
            logger.info((Object)("Ore multiple: " + lcm + ", " + Arrays.toString(oc)));
            return oc;
        }
        oc = this.syz.leftOreCond(a, b);
        return oc;
    }
}

