/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.ProductRing;
import edu.jas.structure.Element;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RegularRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Product<C extends RingElem<C>>
implements RegularRingElem<Product<C>> {
    private static final Logger logger = Logger.getLogger(Product.class);
    public final ProductRing<C> ring;
    public final SortedMap<Integer, C> val;
    protected int isunit = -1;

    public Product(ProductRing<C> r) {
        this(r, new TreeMap(), 0);
    }

    public Product(ProductRing<C> r, SortedMap<Integer, C> a) {
        this(r, a, -1);
    }

    public Product(ProductRing<C> r, SortedMap<Integer, C> a, int u) {
        this.ring = r;
        this.val = a;
        this.isunit = u;
    }

    public C get(int i) {
        return (C)((RingElem)this.val.get(i));
    }

    @Override
    public ProductRing<C> factory() {
        return this.ring;
    }

    @Override
    public Product<C> copy() {
        return new Product<C>(this.ring, this.val, this.isunit);
    }

    @Override
    public boolean isZERO() {
        return this.val.size() == 0;
    }

    @Override
    public boolean isONE() {
        if (this.val.size() != this.ring.length()) {
            return false;
        }
        for (RingElem e : this.val.values()) {
            if (e.isONE()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFull() {
        return this.val.size() == this.ring.length();
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.isZERO()) {
            this.isunit = 0;
            return false;
        }
        for (RingElem e : this.val.values()) {
            if (e.isUnit()) continue;
            this.isunit = 0;
            return false;
        }
        this.isunit = 1;
        return true;
    }

    @Override
    public boolean isIdempotent() {
        for (RingElem e : this.val.values()) {
            if (e.isONE()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.val.toString();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer("( ");
        boolean first = true;
        for (Integer i : this.val.keySet()) {
            RingElem v = (RingElem)this.val.get(i);
            if (first) {
                first = false;
            } else if (v.signum() < 0) {
                s.append(" - ");
                v = (RingElem)v.negate();
            } else {
                s.append(" + ");
            }
            if (!v.isONE()) {
                s.append(v.toScript() + "*");
            }
            s.append("pg" + i);
        }
        s.append(" )");
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((ProductRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Product<C> b) {
        if (!this.ring.equals(b.ring)) {
            logger.info((Object)("other ring " + b.ring));
            throw new IllegalArgumentException("rings not comparable " + this);
        }
        SortedMap<Integer, C> v = b.val;
        Iterator<Map.Entry<Integer, C>> ti = this.val.entrySet().iterator();
        Iterator<Map.Entry<Integer, C>> bi = v.entrySet().iterator();
        while (ti.hasNext() && bi.hasNext()) {
            Map.Entry<Integer, C> te = ti.next();
            Map.Entry<Integer, C> be = bi.next();
            int s = te.getKey().compareTo(be.getKey());
            if (s != 0) {
                return s;
            }
            s = ((RingElem)te.getValue()).compareTo((Element)be.getValue());
            if (s == 0) continue;
            return s;
        }
        if (ti.hasNext()) {
            return -1;
        }
        if (bi.hasNext()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Product)) {
            return false;
        }
        Product a = null;
        try {
            a = (Product)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return 0 == this.compareTo(a);
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.val.hashCode();
        return h;
    }

    public Product<C> extend(int i, int j) {
        RingFactory<RingElem> rf = this.ring.getFactory(j);
        TreeMap<Integer, C> elem = new TreeMap<Integer, C>(this.val);
        RingElem v = (RingElem)this.val.get(i);
        RingElem w = rf.copy(v);
        if (!w.isZERO()) {
            elem.put(j, w);
        }
        return new Product<C>(this.ring, elem, this.isunit);
    }

    @Override
    public Product<C> abs() {
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        for (Integer i : this.val.keySet()) {
            RingElem v = (RingElem)((RingElem)this.val.get(i)).abs();
            elem.put(i, v);
        }
        return new Product<C>(this.ring, elem, this.isunit);
    }

    @Override
    public Product<C> sum(Product<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        TreeMap<Integer, C> elem = new TreeMap<Integer, C>(this.val);
        SortedMap<Integer, C> sel = S.val;
        for (Map.Entry<Integer, C> is : sel.entrySet()) {
            Integer i = is.getKey();
            RingElem x = (RingElem)elem.get(i);
            RingElem y = (RingElem)is.getValue();
            if (x != null) {
                if (!(x = x.sum(y)).isZERO()) {
                    elem.put(i, x);
                    continue;
                }
                elem.remove(i);
                continue;
            }
            elem.put(i, y);
        }
        return new Product<C>(this.ring, elem);
    }

    @Override
    public Product<C> negate() {
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        for (Integer i : this.val.keySet()) {
            RingElem v = (RingElem)((RingElem)this.val.get(i)).negate();
            elem.put(i, v);
        }
        return new Product<C>(this.ring, elem, this.isunit);
    }

    @Override
    public int signum() {
        if (this.val.size() == 0) {
            return 0;
        }
        RingElem v = (RingElem)this.val.get(this.val.firstKey());
        return v.signum();
    }

    @Override
    public Product<C> subtract(Product<C> S) {
        return this.sum((Product<C>)S.negate());
    }

    @Override
    public Product<C> inverse() {
        if (this.isZERO()) {
            return this;
        }
        int isu = 0;
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        for (Integer i : this.val.keySet()) {
            RingElem x = (RingElem)this.val.get(i);
            try {
                x = (RingElem)x.inverse();
            }
            catch (NotInvertibleException e) {
                x = null;
            }
            if (x == null || x.isZERO()) continue;
            elem.put(i, x);
            isu = 1;
        }
        return new Product<C>(this.ring, elem, isu);
    }

    @Override
    public Product<C> idempotent() {
        if (this.isZERO()) {
            return this;
        }
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        for (Integer i : this.val.keySet()) {
            RingFactory<C> f = this.ring.getFactory(i);
            RingElem x = (RingElem)f.getONE();
            elem.put(i, x);
        }
        return new Product<C>(this.ring, elem, 1);
    }

    @Override
    public Product<C> idemComplement() {
        if (this.isZERO()) {
            return this.ring.getONE();
        }
        int isu = 0;
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem v = (RingElem)this.val.get(i);
            if (v != null) continue;
            RingFactory<C> f = this.ring.getFactory(i);
            RingElem x = (RingElem)f.getONE();
            elem.put(i, x);
            isu = 1;
        }
        return new Product<C>(this.ring, elem, isu);
    }

    @Override
    public Product<C> idempotentAnd(Product<C> S) {
        if (this.isZERO() && S.isZERO()) {
            return this;
        }
        int isu = 0;
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem v = (RingElem)this.val.get(i);
            RingElem w = (RingElem)S.val.get(i);
            if (v == null || w == null) continue;
            RingFactory<C> f = this.ring.getFactory(i);
            RingElem x = (RingElem)f.getONE();
            elem.put(i, x);
            isu = 1;
        }
        return new Product<C>(this.ring, elem, isu);
    }

    @Override
    public Product<C> idempotentOr(Product<C> S) {
        if (this.isZERO() && S.isZERO()) {
            return this;
        }
        int isu = 0;
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem v = (RingElem)this.val.get(i);
            RingElem w = (RingElem)S.val.get(i);
            if (v == null && w == null) continue;
            RingFactory<C> f = this.ring.getFactory(i);
            RingElem x = (RingElem)f.getONE();
            elem.put(i, x);
            isu = 1;
        }
        return new Product<C>(this.ring, elem, isu);
    }

    @Override
    public Product<C> fillIdempotent(Product<C> S) {
        if (S.isZERO()) {
            return this;
        }
        TreeMap<Integer, C> elem = new TreeMap<Integer, C>(this.val);
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem w;
            RingElem v = (RingElem)elem.get(i);
            if (v != null || (w = (RingElem)S.val.get(i)) == null) continue;
            RingFactory<C> f = this.ring.getFactory(i);
            RingElem x = (RingElem)f.getONE();
            elem.put(i, x);
        }
        return new Product<C>(this.ring, elem, this.isunit);
    }

    @Override
    public Product<C> fillOne() {
        if (this.isFull()) {
            return this;
        }
        if (this.isZERO()) {
            return this.ring.getONE();
        }
        TreeMap<Integer, C> elem = new TreeMap<Integer, C>(this.val);
        for (int i = 0; i < this.ring.length(); ++i) {
            RingElem v = (RingElem)elem.get(i);
            if (v != null) continue;
            RingFactory<C> f = this.ring.getFactory(i);
            RingElem x = (RingElem)f.getONE();
            elem.put(i, x);
        }
        return new Product<C>(this.ring, elem, this.isunit);
    }

    @Override
    public Product<C> divide(Product<C> S) {
        if (S == null) {
            return this.ring.getZERO();
        }
        if (S.isZERO()) {
            return S;
        }
        if (this.isZERO()) {
            return this;
        }
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        SortedMap<Integer, C> sel = S.val;
        for (Integer i : this.val.keySet()) {
            RingElem y = (RingElem)sel.get(i);
            if (y == null) continue;
            RingElem x = (RingElem)this.val.get(i);
            try {
                x = x.divide(y);
            }
            catch (NotInvertibleException e) {
                System.out.println("product divide error: x = " + x + ", y = " + y);
                x = null;
            }
            if (x == null || x.isZERO()) continue;
            elem.put(i, x);
        }
        return new Product<C>(this.ring, elem);
    }

    @Override
    public Product<C> remainder(Product<C> S) {
        if (S == null) {
            return this;
        }
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        SortedMap<Integer, C> sel = S.val;
        for (Integer i : this.val.keySet()) {
            RingElem y = (RingElem)sel.get(i);
            if (y == null) continue;
            RingElem x = (RingElem)this.val.get(i);
            if ((x = x.remainder(y)) == null || x.isZERO()) continue;
            elem.put(i, x);
        }
        return new Product<C>(this.ring, elem);
    }

    public Product<C>[] quotientRemainder(Product<C> S) {
        return new Product[]{this.divide(S), this.remainder(S)};
    }

    @Override
    public Product<C> multiply(Product<C> S) {
        if (S == null) {
            return this.ring.getZERO();
        }
        if (S.isZERO()) {
            return S;
        }
        if (this.isZERO()) {
            return this;
        }
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        SortedMap<Integer, C> sel = S.val;
        for (Integer i : this.val.keySet()) {
            RingElem y = (RingElem)sel.get(i);
            if (y == null) continue;
            RingElem x = (RingElem)this.val.get(i);
            if ((x = x.multiply(y)) == null || x.isZERO()) continue;
            elem.put(i, x);
        }
        return new Product<C>(this.ring, elem);
    }

    @Override
    public Product<C> multiply(C c) {
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        for (Integer i : this.val.keySet()) {
            RingElem v = (RingElem)((RingElem)this.val.get(i)).multiply(c);
            if (v == null || v.isZERO()) continue;
            elem.put(i, v);
        }
        return new Product<C>(this.ring, elem);
    }

    @Override
    public Product<C> gcd(Product<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        TreeMap<Integer, C> elem = new TreeMap<Integer, C>(this.val);
        SortedMap<Integer, C> sel = S.val;
        for (Map.Entry<Integer, C> is : sel.entrySet()) {
            Integer i = is.getKey();
            RingElem x = (RingElem)elem.get(i);
            RingElem y = (RingElem)is.getValue();
            if (x != null) {
                if ((x = x.gcd(y)) != null && !x.isZERO()) {
                    elem.put(i, x);
                    continue;
                }
                elem.remove(i);
                continue;
            }
            elem.put(i, y);
        }
        return new Product<C>(this.ring, elem);
    }

    public Product<C>[] egcd(Product<C> S) {
        Product[] ret = new Product[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        TreeMap<Integer, C> elem = new TreeMap<Integer, C>(this.val);
        SortedMap<Integer, C> elem1 = ((Product)this.idempotent()).val;
        TreeMap elem2 = new TreeMap();
        SortedMap<Integer, C> sel = S.val;
        for (Map.Entry<Integer, C> is : sel.entrySet()) {
            Integer i = is.getKey();
            RingElem x = (RingElem)elem.get(i);
            RingElem y = (RingElem)is.getValue();
            if (x != null) {
                RingElem[] g = x.egcd(y);
                if (!g[0].isZERO()) {
                    elem.put(i, g[0]);
                    elem1.put(i, g[1]);
                    elem2.put(i, g[2]);
                    continue;
                }
                elem.remove(i);
                continue;
            }
            elem.put(i, y);
            elem2.put(i, this.ring.getFactory(i).getONE());
        }
        ret[0] = new Product<C>(this.ring, elem);
        ret[1] = new Product<C>(this.ring, elem1);
        ret[2] = new Product<C>(this.ring, elem2);
        return ret;
    }
}

