/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigRational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class BigDecimal
implements GcdRingElem<BigDecimal>,
RingFactory<BigDecimal> {
    public final java.math.BigDecimal val;
    private static final Random random = new Random();
    public static final MathContext DEFAULT_CONTEXT = MathContext.DECIMAL128;
    public static final int DEFAULT_PRECISION = DEFAULT_CONTEXT.getPrecision();
    public final MathContext context;
    public static final BigDecimal ZERO = new BigDecimal(java.math.BigDecimal.ZERO);
    public static final BigDecimal ONE = new BigDecimal(java.math.BigDecimal.ONE);

    public BigDecimal(java.math.BigDecimal a) {
        this(a, DEFAULT_CONTEXT);
    }

    public BigDecimal(java.math.BigDecimal a, MathContext mc) {
        this.val = a;
        this.context = mc;
    }

    public BigDecimal(long a) {
        this(a, DEFAULT_CONTEXT);
    }

    public BigDecimal(long a, MathContext mc) {
        this(new java.math.BigDecimal(String.valueOf(a)), mc);
    }

    public BigDecimal(double a) {
        this(a, DEFAULT_CONTEXT);
    }

    public BigDecimal(double a, MathContext mc) {
        this(new java.math.BigDecimal(a), mc);
    }

    public BigDecimal(BigInteger a) {
        this(a, DEFAULT_CONTEXT);
    }

    public BigDecimal(BigInteger a, MathContext mc) {
        this(new java.math.BigDecimal(a), mc);
    }

    public BigDecimal(BigRational a) {
        this(a, DEFAULT_CONTEXT);
    }

    public BigDecimal(BigRational a, MathContext mc) {
        this(new java.math.BigDecimal(a.num, mc).divide(new java.math.BigDecimal(a.den, mc), mc), mc);
    }

    public BigDecimal(String s) {
        this(s, DEFAULT_CONTEXT);
    }

    public BigDecimal(String s, MathContext mc) {
        this(new java.math.BigDecimal(s.trim()), mc);
    }

    public BigDecimal() {
        this(java.math.BigDecimal.ZERO, DEFAULT_CONTEXT);
    }

    public BigDecimal factory() {
        return this;
    }

    @Override
    public List<BigDecimal> generators() {
        ArrayList<BigDecimal> g = new ArrayList<BigDecimal>(1);
        g.add(this.getONE());
        return g;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigDecimal copy() {
        return new BigDecimal(this.val, this.context);
    }

    @Override
    public BigDecimal copy(BigDecimal c) {
        return new BigDecimal(c.val, c.context);
    }

    @Override
    public BigDecimal getZERO() {
        return ZERO;
    }

    @Override
    public BigDecimal getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal fromInteger(BigInteger a) {
        return new BigDecimal(new java.math.BigDecimal(a), this.context);
    }

    public static BigDecimal valueOf(java.math.BigDecimal a) {
        return new BigDecimal(a, DEFAULT_CONTEXT);
    }

    @Override
    public BigDecimal fromInteger(long a) {
        return new BigDecimal(a, this.context);
    }

    public static BigDecimal valueOf(long a) {
        return new BigDecimal(a, DEFAULT_CONTEXT);
    }

    @Override
    public boolean isZERO() {
        return this.val.compareTo(java.math.BigDecimal.ZERO) == 0;
    }

    @Override
    public boolean isONE() {
        return this.val.compareTo(java.math.BigDecimal.ONE) == 0;
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    public String toString() {
        return this.val.toString();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        return "DD()";
    }

    @Override
    public int compareTo(BigDecimal b) {
        java.math.BigDecimal s = this.val.subtract(b.val, this.context);
        java.math.BigDecimal u1 = this.val.ulp();
        java.math.BigDecimal u2 = b.val.ulp();
        int u = Math.min(u1.scale(), u2.scale());
        java.math.BigDecimal eps = u <= 0 ? u1.max(u2) : u1.min(u2);
        int t = s.abs().compareTo(eps);
        if (t < 1) {
            return 0;
        }
        return s.signum();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bi = (BigDecimal)b;
        return this.val.equals(bi.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public BigDecimal abs() {
        return new BigDecimal(this.val.abs(), this.context);
    }

    @Override
    public BigDecimal negate() {
        return new BigDecimal(this.val.negate(), this.context);
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public BigDecimal subtract(BigDecimal S) {
        return new BigDecimal(this.val.subtract(S.val, this.context));
    }

    @Override
    public BigDecimal divide(BigDecimal S) {
        return new BigDecimal(this.val.divide(S.val, this.context));
    }

    @Override
    public BigDecimal inverse() {
        return ONE.divide(this);
    }

    @Override
    public BigDecimal remainder(BigDecimal S) {
        return new BigDecimal(this.val.remainder(S.val, this.context));
    }

    public BigDecimal[] quotientRemainder(BigDecimal S) {
        BigDecimal[] qr = new BigDecimal[2];
        java.math.BigDecimal[] C = this.val.divideAndRemainder(S.val, this.context);
        qr[0] = new BigDecimal(C[0]);
        qr[1] = new BigDecimal(C[1]);
        return qr;
    }

    @Deprecated
    public BigDecimal[] divideAndRemainder(BigDecimal S) {
        return this.quotientRemainder(S);
    }

    @Override
    public BigDecimal gcd(BigDecimal S) {
        throw new UnsupportedOperationException("BigDecimal.gcd() not implemented");
    }

    public BigDecimal[] egcd(BigDecimal S) {
        throw new UnsupportedOperationException("BigDecimal.egcd() not implemented");
    }

    @Override
    public BigDecimal random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigDecimal random(int n, Random rnd) {
        return this.random(n, 100, rnd);
    }

    public BigDecimal random(int n, int e) {
        return this.random(n, e, random);
    }

    public BigDecimal random(int n, int e, Random rnd) {
        BigInteger r = new BigInteger(n, rnd);
        if (rnd.nextBoolean()) {
            r = r.negate();
        }
        int scale = rnd.nextInt(e);
        if (rnd.nextBoolean()) {
            scale = -scale;
        }
        java.math.BigDecimal d = new java.math.BigDecimal(r, scale, this.context);
        return new BigDecimal(d, this.context);
    }

    @Override
    public BigDecimal multiply(BigDecimal S) {
        return new BigDecimal(this.val.multiply(S.val, this.context));
    }

    @Override
    public BigDecimal sum(BigDecimal S) {
        return new BigDecimal(this.val.add(S.val, this.context));
    }

    @Override
    public BigDecimal parse(String s) {
        return new BigDecimal(s, this.context);
    }

    @Override
    public BigDecimal parse(Reader r) {
        return this.parse(StringUtil.nextString(r));
    }
}

