/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigRational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public final class BigComplex
implements StarRingElem<BigComplex>,
GcdRingElem<BigComplex>,
RingFactory<BigComplex> {
    public final BigRational re;
    public final BigRational im;
    private static final Random random = new Random();
    private static final Logger logger = Logger.getLogger(BigComplex.class);
    public static final BigComplex ZERO = new BigComplex();
    public static final BigComplex ONE = new BigComplex(BigRational.ONE);
    public static final BigComplex I = new BigComplex(BigRational.ZERO, BigRational.ONE);

    public BigComplex(BigRational r, BigRational i) {
        this.re = r;
        this.im = i;
    }

    public BigComplex(BigRational r) {
        this(r, BigRational.ZERO);
    }

    public BigComplex(long r) {
        this(new BigRational(r), BigRational.ZERO);
    }

    public BigComplex() {
        this(BigRational.ZERO);
    }

    public BigComplex(String s) throws NumberFormatException {
        if (s == null || s.length() == 0) {
            this.re = BigRational.ZERO;
            this.im = BigRational.ZERO;
            return;
        }
        int i = (s = s.trim()).indexOf("i");
        if (i < 0) {
            this.re = new BigRational(s);
            this.im = BigRational.ZERO;
            return;
        }
        String sr = "";
        if (i > 0) {
            sr = s.substring(0, i);
        }
        String si = "";
        if (i < s.length()) {
            si = s.substring(i + 1, s.length());
        }
        this.re = new BigRational(sr.trim());
        this.im = new BigRational(si.trim());
    }

    public BigComplex factory() {
        return this;
    }

    @Override
    public List<BigComplex> generators() {
        ArrayList<BigComplex> g = new ArrayList<BigComplex>(2);
        g.add(this.getONE());
        g.add(this.getIMAG());
        return g;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigComplex copy() {
        return new BigComplex(this.re, this.im);
    }

    @Override
    public BigComplex copy(BigComplex c) {
        return new BigComplex(c.re, c.im);
    }

    @Override
    public BigComplex getZERO() {
        return ZERO;
    }

    @Override
    public BigComplex getONE() {
        return ONE;
    }

    public BigComplex getIMAG() {
        return I;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigComplex fromInteger(BigInteger a) {
        return new BigComplex(new BigRational(a));
    }

    @Override
    public BigComplex fromInteger(long a) {
        return new BigComplex(new BigRational(a));
    }

    public BigRational getRe() {
        return this.re;
    }

    public BigRational getIm() {
        return this.im;
    }

    public String toString() {
        String s = "" + this.re;
        int i = this.im.compareTo(BigRational.ZERO);
        if (i == 0) {
            return s;
        }
        s = s + "i" + this.im;
        return s;
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        boolean iz = this.im.isZERO();
        if (iz) {
            s.append(this.re.toScript());
            return s.toString();
        }
        boolean rz = this.re.isZERO();
        if (rz) {
            if (!this.im.isONE()) {
                if (this.im.signum() > 0) {
                    s.append(this.im.toScript() + "*");
                } else {
                    s.append("-");
                    BigRational ii = this.im.negate();
                    if (!ii.isONE()) {
                        s.append(ii.toScript() + "*");
                    }
                }
            }
        } else {
            s.append(this.re.toScript());
            if (this.im.signum() > 0) {
                s.append("+");
                if (!this.im.isONE()) {
                    s.append(this.im.toScript() + "*");
                }
            } else {
                s.append("-");
                BigRational ii = this.im.negate();
                if (!ii.isONE()) {
                    s.append(ii.toScript() + "*");
                }
            }
        }
        s.append("I");
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return "CC()";
    }

    public static boolean isCZERO(BigComplex A) {
        if (A == null) {
            return false;
        }
        return A.isZERO();
    }

    @Override
    public boolean isZERO() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ZERO);
    }

    public static boolean isCONE(BigComplex A) {
        if (A == null) {
            return false;
        }
        return A.isONE();
    }

    @Override
    public boolean isONE() {
        return this.re.equals(BigRational.ONE) && this.im.equals(BigRational.ZERO);
    }

    public boolean isIMAG() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ONE);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof BigComplex)) {
            return false;
        }
        BigComplex bc = (BigComplex)b;
        return this.re.equals(bc.re) && this.im.equals(bc.im);
    }

    @Override
    public int hashCode() {
        return 37 * this.re.hashCode() + this.im.hashCode();
    }

    @Override
    public int compareTo(BigComplex b) {
        int s = this.re.compareTo(b.re);
        if (s != 0) {
            return s;
        }
        return this.im.compareTo(b.im);
    }

    @Override
    public int signum() {
        int s = this.re.signum();
        if (s != 0) {
            return s;
        }
        return this.im.signum();
    }

    @Override
    public BigComplex sum(BigComplex B) {
        return new BigComplex(this.re.sum(B.re), this.im.sum(B.im));
    }

    public static BigComplex CSUM(BigComplex A, BigComplex B) {
        if (A == null) {
            return null;
        }
        return A.sum(B);
    }

    public static BigComplex CDIF(BigComplex A, BigComplex B) {
        if (A == null) {
            return null;
        }
        return A.subtract(B);
    }

    @Override
    public BigComplex subtract(BigComplex B) {
        return new BigComplex(this.re.subtract(B.re), this.im.subtract(B.im));
    }

    public static BigComplex CNEG(BigComplex A) {
        if (A == null) {
            return null;
        }
        return A.negate();
    }

    @Override
    public BigComplex negate() {
        return new BigComplex(this.re.negate(), this.im.negate());
    }

    public static BigComplex CCON(BigComplex A) {
        if (A == null) {
            return null;
        }
        return A.conjugate();
    }

    @Override
    public BigComplex conjugate() {
        return new BigComplex(this.re, this.im.negate());
    }

    @Override
    public BigComplex norm() {
        BigRational v = this.re.multiply(this.re);
        v = v.sum(this.im.multiply(this.im));
        return new BigComplex(v);
    }

    @Override
    public BigComplex abs() {
        BigComplex n = this.norm();
        logger.error((Object)"abs() square root missing");
        return n;
    }

    public static BigRational CABS(BigComplex A) {
        if (A == null) {
            return null;
        }
        return A.abs().re;
    }

    public static BigComplex CPROD(BigComplex A, BigComplex B) {
        if (A == null) {
            return null;
        }
        return A.multiply(B);
    }

    @Override
    public BigComplex multiply(BigComplex B) {
        return new BigComplex(this.re.multiply(B.re).subtract(this.im.multiply(B.im)), this.re.multiply(B.im).sum(this.im.multiply(B.re)));
    }

    public static BigComplex CINV(BigComplex A) {
        if (A == null) {
            return null;
        }
        return A.inverse();
    }

    @Override
    public BigComplex inverse() {
        BigRational a = this.norm().re.inverse();
        return new BigComplex(this.re.multiply(a), this.im.multiply(a.negate()));
    }

    @Override
    public BigComplex remainder(BigComplex S) {
        if (S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public static BigComplex CQ(BigComplex A, BigComplex B) {
        if (A == null) {
            return null;
        }
        return A.divide(B);
    }

    @Override
    public BigComplex divide(BigComplex B) {
        return this.multiply(B.inverse());
    }

    public BigComplex[] quotientRemainder(BigComplex S) {
        return new BigComplex[]{this.divide(S), ZERO};
    }

    @Override
    public BigComplex random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigComplex random(int n, Random rnd) {
        BigRational r = BigRational.ONE.random(n, rnd);
        BigRational i = BigRational.ONE.random(n, rnd);
        return new BigComplex(r, i);
    }

    public static BigComplex CRAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public BigComplex parse(String s) {
        return new BigComplex(s);
    }

    @Override
    public BigComplex parse(Reader r) {
        return this.parse(StringUtil.nextString(r));
    }

    @Override
    public BigComplex gcd(BigComplex S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        return ONE;
    }

    public BigComplex[] egcd(BigComplex S) {
        BigComplex[] ret = new BigComplex[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        BigComplex half = new BigComplex(new BigRational(1L, 2L));
        ret[0] = ONE;
        ret[1] = this.inverse().multiply(half);
        ret[2] = S.inverse().multiply(half);
        return ret;
    }
}

