/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueSolvablePolynomialRing;
import edu.jas.application.SolvableResidue;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.GcdRingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class ResidueSolvablePolynomial<C extends GcdRingElem<C>>
extends GenSolvablePolynomial<SolvableResidue<C>> {
    public final ResidueSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(ResidueSolvablePolynomial.class);
    private final boolean debug = logger.isDebugEnabled();

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> r) {
        super(r);
        this.ring = r;
    }

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> r, ExpVector e) {
        this(r);
        this.val.put(e, this.ring.getONECoefficient());
    }

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> r, SolvableResidue<C> c, ExpVector e) {
        this(r);
        if (c != null && !c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> r, SolvableResidue<C> c) {
        this(r, c, r.evzero);
    }

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> r, GenSolvablePolynomial<SolvableResidue<C>> S) {
        this(r, S.getMap());
    }

    protected ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> r, SortedMap<ExpVector, SolvableResidue<C>> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public ResidueSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public ResidueSolvablePolynomial<C> copy() {
        return new ResidueSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ResidueSolvablePolynomial)) {
            return false;
        }
        return super.equals(B);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(ResidueSolvablePolynomial<C> Bp) {
        if (Bp == null || Bp.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == Bp.ring.nvar);
        if (this.debug) {
            logger.debug((Object)("ring = " + this.ring));
        }
        ExpVector Z = this.ring.evzero;
        GenSolvablePolynomial Dp = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial zero = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        SolvableResidue one = (SolvableResidue)this.ring.getONECoefficient();
        Object C1 = null;
        Object C2 = null;
        SortedMap A = this.val;
        SortedMap B = Bp.val;
        Set Bk = B.entrySet();
        for (Map.Entry y : A.entrySet()) {
            SolvableResidue a = (SolvableResidue)y.getValue();
            ExpVector e = (ExpVector)y.getKey();
            if (this.debug) {
                logger.info((Object)("e = " + e + ", a = " + a));
            }
            int[] ep = e.dependencyOnVariables();
            int el1 = this.ring.nvar + 1;
            if (ep.length > 0) {
                el1 = ep[0];
            }
            for (Map.Entry x : Bk) {
                SolvableResidue b = (SolvableResidue)x.getValue();
                ExpVector f = (ExpVector)x.getKey();
                if (this.debug) {
                    logger.info((Object)("f = " + f + ", b = " + b));
                }
                int[] fp = f.dependencyOnVariables();
                int fl1 = 0;
                if (fp.length > 0) {
                    fl1 = fp[fp.length - 1];
                }
                int fl1s = this.ring.nvar + 1 - fl1;
                ResidueSolvablePolynomial<C> Cps = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
                Object Cs = null;
                if (this.ring.polCoeff.coeffTable.isEmpty() || b.isConstant() || e.isZERO()) {
                    Cps = new ResidueSolvablePolynomial<C>(this.ring, b, e);
                    if (this.debug) {
                        logger.info((Object)("symmetric coeff: b = " + b + ", e = " + e));
                    }
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric coeff: b = " + b + ", e = " + e));
                    }
                    RecSolvablePolynomial rsp1 = new RecSolvablePolynomial(this.ring.polCoeff, e);
                    RecSolvablePolynomial rsp2 = new RecSolvablePolynomial(this.ring.polCoeff, b.val);
                    RecSolvablePolynomial rsp3 = rsp1.multiply(rsp2);
                    Cps = this.ring.fromPolyCoefficients(rsp3);
                }
                if (this.debug) {
                    logger.info((Object)("coeff-poly: Cps = " + Cps));
                }
                GenSolvablePolynomial Dps = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
                ResidueSolvablePolynomial<C> Ds = null;
                if (this.ring.table.isEmpty() || Cps.isConstant() || f.isZERO()) {
                    if (this.debug) {
                        logger.info((Object)("symmetric poly: b = " + b + ", e = " + e));
                    }
                    ExpVector g = e.sum(f);
                    Ds = Cps.isConstant() ? new ResidueSolvablePolynomial<C>(this.ring, (SolvableResidue)Cps.leadingBaseCoefficient(), g) : this.shift(Cps, f);
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric poly: Cps = " + Cps + ", f = " + f));
                    }
                    for (Map.Entry z : Cps.val.entrySet()) {
                        int gl1s;
                        SolvableResidue c = (SolvableResidue)z.getValue();
                        ExpVector g = (ExpVector)z.getKey();
                        if (this.debug) {
                            logger.info((Object)("g = " + g + ", c = " + c));
                        }
                        int[] gp = g.dependencyOnVariables();
                        int gl1 = this.ring.nvar + 1;
                        if (gp.length > 0) {
                            gl1 = gp[0];
                        }
                        if ((gl1s = this.ring.nvar + 1 - gl1) <= fl1s) {
                            ExpVector h = g.sum(f);
                            if (this.debug) {
                                logger.info((Object)("disjoint poly: g = " + g + ", f = " + f + ", h = " + h));
                            }
                            Ds = (ResidueSolvablePolynomial<C>)zero.sum(one, h);
                        } else {
                            ResidueSolvablePolynomial<C> D1;
                            ResidueSolvablePolynomial<C> D2;
                            ExpVector g1 = g.subst(gl1, 0L);
                            ExpVector g2 = Z.subst(gl1, g.getVal(gl1));
                            ExpVector f1 = f.subst(fl1, 0L);
                            ExpVector f2 = Z.subst(fl1, f.getVal(fl1));
                            if (this.debug) {
                                logger.info((Object)("poly, g1 = " + g1 + ", f1 = " + f1 + ", Dps = " + Dps));
                            }
                            if (this.debug) {
                                logger.info((Object)("poly, g2 = " + g2 + ", f2 = " + f2));
                            }
                            TableRelation rel = this.ring.table.lookup(g2, f2);
                            if (this.debug) {
                                logger.info((Object)("poly, g  = " + g + ", f  = " + f + ", rel = " + rel));
                            }
                            Ds = new ResidueSolvablePolynomial<C>(this.ring, rel.p);
                            if (rel.f != null) {
                                D2 = new ResidueSolvablePolynomial<C>(this.ring, one, rel.f);
                                Ds = Ds.multiply(D2);
                                ExpVector g4 = rel.e == null ? g2 : g2.subtract(rel.e);
                                this.ring.table.update(g4, f2, Ds);
                            }
                            if (rel.e != null) {
                                D1 = new ResidueSolvablePolynomial<C>(this.ring, one, rel.e);
                                Ds = D1.multiply(Ds);
                                this.ring.table.update(g2, f2, Ds);
                            }
                            if (!f1.isZERO()) {
                                D2 = new ResidueSolvablePolynomial<C>(this.ring, one, f1);
                                Ds = Ds.multiply(D2);
                            }
                            if (!g1.isZERO()) {
                                D1 = new ResidueSolvablePolynomial<C>(this.ring, one, g1);
                                Ds = D1.multiply(Ds);
                            }
                        }
                        Ds = Ds.multiplyLeft(c);
                        Dps = (ResidueSolvablePolynomial)Dps.sum(Ds);
                    }
                    Ds = Dps;
                }
                Ds = Ds.multiplyLeft(a);
                if (this.debug) {
                    logger.debug((Object)("Ds = " + Ds));
                }
                Dp = (ResidueSolvablePolynomial)Dp.sum(Ds);
            }
        }
        return Dp;
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(ResidueSolvablePolynomial<C> S, ResidueSolvablePolynomial<C> T) {
        if (S.isZERO() || T.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (S.isONE()) {
            return this.multiply(T);
        }
        if (T.isONE()) {
            return S.multiply(this);
        }
        return S.multiply(this).multiply(T);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(SolvableResidue<C> b) {
        ResidueSolvablePolynomial<C> Cp = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        Cp = new ResidueSolvablePolynomial<C>(this.ring, b, this.ring.evzero);
        return this.multiply(Cp);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(SolvableResidue<C> b, SolvableResidue<C> c) {
        GenSolvablePolynomial Cp = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (c == null || c.isZERO()) {
            return Cp;
        }
        ResidueSolvablePolynomial<C> Cb = new ResidueSolvablePolynomial<C>(this.ring, b, this.ring.evzero);
        ResidueSolvablePolynomial<C> Cc = new ResidueSolvablePolynomial<C>(this.ring, c, this.ring.evzero);
        return Cb.multiply(this).multiply(Cc);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        SolvableResidue b = (SolvableResidue)this.ring.getONECoefficient();
        return this.multiply(b, e);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(ExpVector e, ExpVector f) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (f == null || f.isZERO()) {
            return this;
        }
        SolvableResidue b = (SolvableResidue)this.ring.getONECoefficient();
        return this.multiply(b, e, b, f);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(SolvableResidue<C> b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvablePolynomial<C> Cp = new ResidueSolvablePolynomial<C>(this.ring, b, e);
        return this.multiply(Cp);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(SolvableResidue<C> b, ExpVector e, SolvableResidue<C> c, ExpVector f) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvablePolynomial<C> Cp = new ResidueSolvablePolynomial<C>(this.ring, b, e);
        ResidueSolvablePolynomial<C> Dp = new ResidueSolvablePolynomial<C>(this.ring, c, f);
        return this.multiply(Cp, Dp);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiplyLeft(SolvableResidue<C> b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvablePolynomial<C> Cp = new ResidueSolvablePolynomial<C>(this.ring, b, e);
        return Cp.multiply(this);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiplyLeft(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        SolvableResidue b = (SolvableResidue)this.ring.getONECoefficient();
        ResidueSolvablePolynomial<C> Cp = new ResidueSolvablePolynomial<C>(this.ring, b, e);
        return Cp.multiply(this);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiplyLeft(SolvableResidue<C> b) {
        GenSolvablePolynomial Cp = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((ResidueSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            SolvableResidue a = (SolvableResidue)y.getValue();
            SolvableResidue<SolvableResidue> c = b.multiply(a);
            if (c.isZERO()) continue;
            Cm.put(e, c);
        }
        return Cp;
    }

    @Override
    public ResidueSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, SolvableResidue<C>> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(m.getValue(), m.getKey());
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(Map.Entry<ExpVector, SolvableResidue<C>> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiply(m.getValue(), m.getKey());
    }

    protected ResidueSolvablePolynomial<C> shift(ResidueSolvablePolynomial<C> B, ExpVector f) {
        GenSolvablePolynomial C = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        if (B == null || B.isZERO()) {
            return C;
        }
        if (f == null || f.isZERO()) {
            return B;
        }
        SortedMap Cm = ((ResidueSolvablePolynomial)C).val;
        SortedMap Bm = B.val;
        for (Map.Entry y : Bm.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            SolvableResidue a = (SolvableResidue)y.getValue();
            ExpVector d = e.sum(f);
            if (a.isZERO()) continue;
            Cm.put(d, a);
        }
        return C;
    }
}

