/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.QLRSolvablePolynomial;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class QLRSolvablePolynomialRing<C extends GcdRingElem<C> & QuotPair<GenPolynomial<D>>, D extends GcdRingElem<D>>
extends GenSolvablePolynomialRing<C> {
    private static final Logger logger = Logger.getLogger(QLRSolvablePolynomialRing.class);
    public final RecSolvablePolynomialRing<D> polCoeff;
    public final QLRSolvablePolynomial<C, D> ZERO;
    public final QLRSolvablePolynomial<C, D> ONE;
    public final QuotPairFactory<GenPolynomial<D>, C> qpfac;

    public QLRSolvablePolynomialRing(RingFactory<C> cf, int n) {
        this(cf, n, new TermOrder(), null, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, int n, RelationTable<C> rt) {
        this(cf, n, new TermOrder(), null, rt);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t) {
        this(cf, n, t, null, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t, RelationTable<C> rt) {
        this(cf, n, t, null, rt);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v) {
        this(cf, n, t, v, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, TermOrder t, String[] v) {
        this(cf, v.length, t, v, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, String[] v) {
        this(cf, v.length, new TermOrder(), v, null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, GenSolvablePolynomialRing o) {
        this(cf, o.nvar, o.tord, o.getVars(), null);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, QLRSolvablePolynomialRing o) {
        this(cf, (GenSolvablePolynomialRing)o);
    }

    public QLRSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v, RelationTable<C> rt) {
        super(cf, n, t, v, rt);
        this.qpfac = (QuotPairFactory)((Object)cf);
        RingFactory cfring = this.qpfac.pairFactory();
        this.polCoeff = new RecSolvablePolynomialRing(cfring, n, t, v);
        if (this.table.size() > 0) {
            ExpVector e = null;
            ExpVector f = null;
            GenSolvablePolynomial p = null;
            this.polCoeff.table.update(e, f, p);
        }
        this.ZERO = new QLRSolvablePolynomial(this);
        GcdRingElem coeff = (GcdRingElem)this.coFac.getONE();
        this.ONE = new QLRSolvablePolynomial(this, coeff, this.evzero);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = PrettyPrint.isTrue() ? res + "\n" + this.polCoeff.coeffTable.toString(this.vars) : res + ", #rel = " + this.table.size() + " + " + this.polCoeff.coeffTable.size();
        return res;
    }

    @Override
    public String toScript() {
        String rel;
        StringBuffer s = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("SolvPolyRing.new(");
                break;
            }
            default: {
                s.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            s.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            s.append(this.coFac.toScript().trim());
        }
        s.append(",\"" + this.varsToString() + "\",");
        String to = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            to = "PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            to = "PolyRing.grad";
        }
        s.append(to);
        if (this.table.size() > 0) {
            rel = this.table.toScript();
            s.append(",rel=");
            s.append(rel);
        }
        if (this.polCoeff.coeffTable.size() > 0) {
            rel = this.polCoeff.coeffTable.toScript();
            s.append(",coeffrel=");
            s.append(rel);
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof QLRSolvablePolynomialRing)) {
            return false;
        }
        QLRSolvablePolynomialRing oring = null;
        try {
            oring = (QLRSolvablePolynomialRing)other;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (oring == null) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.polCoeff.coeffTable.equals(oring.polCoeff.coeffTable);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 37 * h + this.table.hashCode();
        h = 37 * h + this.polCoeff.coeffTable.hashCode();
        return h;
    }

    @Override
    public QLRSolvablePolynomial<C, D> getZERO() {
        return this.ZERO;
    }

    @Override
    public QLRSolvablePolynomial<C, D> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.polCoeff.isCommutative()) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        List gens = this.generators();
        int ngen = gens.size();
        for (int i = 0; i < ngen; ++i) {
            QLRSolvablePolynomial Xi = (QLRSolvablePolynomial)gens.get(i);
            for (int j = i + 1; j < ngen; ++j) {
                QLRSolvablePolynomial Xj = (QLRSolvablePolynomial)gens.get(j);
                for (int k = j + 1; k < ngen; ++k) {
                    QLRSolvablePolynomial q;
                    QLRSolvablePolynomial p;
                    QLRSolvablePolynomial Xk = (QLRSolvablePolynomial)gens.get(k);
                    try {
                        p = Xk.multiply(Xj).multiply(Xi);
                        q = Xk.multiply(Xj.multiply(Xi));
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    if (p.equals(q)) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Xk = " + Xk + ", Xj = " + Xj + ", Xi = " + Xi));
                        logger.info((Object)("p = ( Xk * Xj ) * Xi = " + p));
                        logger.info((Object)("q = Xk * ( Xj * Xi ) = " + q));
                        logger.info((Object)("q-p = " + p.subtract(q)));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public QLRSolvablePolynomial<C, D> fromInteger(long a) {
        return new QLRSolvablePolynomial(this, (GcdRingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public QLRSolvablePolynomial<C, D> fromInteger(BigInteger a) {
        return new QLRSolvablePolynomial(this, (GcdRingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public QLRSolvablePolynomial<C, D> random(int n) {
        return this.random(n, random);
    }

    @Override
    public QLRSolvablePolynomial<C, D> random(int n, Random rnd) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, rnd);
        }
        return this.random(5, n, 3, 0.3f, rnd);
    }

    @Override
    public QLRSolvablePolynomial<C, D> random(int k, int l, int d, float q) {
        return this.random(k, l, d, q, random);
    }

    @Override
    public QLRSolvablePolynomial<C, D> random(int k, int l, int d, float q, Random rnd) {
        GenSolvablePolynomial r = this.getZERO();
        for (int i = 0; i < l; ++i) {
            ExpVector e = ExpVector.EVRAND(this.nvar, d, q, rnd);
            GcdRingElem a = (GcdRingElem)this.coFac.random(k, rnd);
            r = (QLRSolvablePolynomial)r.sum(a, e);
        }
        return r;
    }

    @Override
    public QLRSolvablePolynomial<C, D> copy(QLRSolvablePolynomial<C, D> c) {
        return new QLRSolvablePolynomial(this, c.getMap());
    }

    @Override
    public QLRSolvablePolynomial<C, D> parse(String s) {
        return this.parse(new StringReader(s));
    }

    @Override
    public QLRSolvablePolynomial<C, D> parse(Reader r) {
        GenPolynomialTokenizer pt = new GenPolynomialTokenizer(this, r);
        QLRSolvablePolynomial p = null;
        try {
            GenSolvablePolynomial s = pt.nextSolvablePolynomial();
            p = new QLRSolvablePolynomial(this, s);
        }
        catch (IOException e) {
            logger.error((Object)(e.toString() + " parse " + this));
            p = this.ZERO;
        }
        return p;
    }

    @Override
    public QLRSolvablePolynomial<C, D> univariate(int i) {
        return (QLRSolvablePolynomial)super.univariate(i);
    }

    @Override
    public QLRSolvablePolynomial<C, D> univariate(int i, long e) {
        return (QLRSolvablePolynomial)super.univariate(i, e);
    }

    @Override
    public QLRSolvablePolynomial<C, D> univariate(int modv, int i, long e) {
        return (QLRSolvablePolynomial)super.univariate(modv, i, e);
    }

    public List<QLRSolvablePolynomial<C, D>> recUnivariateList() {
        return this.univariateList(0, 1L);
    }

    public List<QLRSolvablePolynomial<C, D>> recUnivariateList(int modv) {
        return this.univariateList(modv, 1L);
    }

    public List<QLRSolvablePolynomial<C, D>> recUnivariateList(int modv, long e) {
        ArrayList<QLRSolvablePolynomial<C, D>> pols = new ArrayList<QLRSolvablePolynomial<C, D>>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            GenSolvablePolynomial p = this.univariate(modv, nm - 1 - i, e);
            pols.add((QLRSolvablePolynomial<C, D>)p);
        }
        return pols;
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> extend(int i) {
        GenPolynomialRing pfac = super.extend(i);
        QLRSolvablePolynomialRing spfac = new QLRSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.table.extend(this.table);
        spfac.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return spfac;
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> contract(int i) {
        GenPolynomialRing pfac = super.contract(i);
        QLRSolvablePolynomialRing spfac = new QLRSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.table.contract(this.table);
        spfac.polCoeff.coeffTable.contract(this.polCoeff.coeffTable);
        return spfac;
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> reverse() {
        return this.reverse(false);
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> reverse(boolean partial) {
        GenPolynomialRing pfac = super.reverse(partial);
        QLRSolvablePolynomialRing spfac = new QLRSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.partial = partial;
        spfac.table.reverse(this.table);
        spfac.polCoeff.coeffTable.reverse(this.polCoeff.coeffTable);
        return spfac;
    }

    public QLRSolvablePolynomial<C, D> fromPolyCoefficients(GenSolvablePolynomial<GenPolynomial<D>> A) {
        GenSolvablePolynomial B = ((QLRSolvablePolynomial)this.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        for (Map.Entry y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenSolvablePolynomial a = (GenSolvablePolynomial)y.getValue();
            GcdRingElem p = (GcdRingElem)this.qpfac.create(a);
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }

    public RecSolvablePolynomial<D> toPolyCoefficients(QLRSolvablePolynomial<C, D> A) {
        GenSolvablePolynomial B = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        for (Map.Entry y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            if (!((GenPolynomial)((QuotPair)((Object)a)).denominator()).isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + a);
            }
            GenPolynomial p = (GenPolynomial)((QuotPair)((Object)a)).numerator();
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }

    public RecSolvablePolynomial<D> toPolyCoefficients(GenPolynomial<C> A) {
        GenSolvablePolynomial B = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            if (!((GenPolynomial)((QuotPair)((Object)a)).denominator()).isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + a);
            }
            GenPolynomial p = (GenPolynomial)((QuotPair)((Object)a)).numerator();
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }
}

