/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CPair;
import edu.jas.application.CReductionSeq;
import edu.jas.application.ColorPolynomial;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class OrderedCPairlist<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(OrderedCPairlist.class);
    protected final GenPolynomialRing<GenPolynomial<C>> ring;
    protected final List<ColorPolynomial<C>> P;
    protected final SortedMap<ExpVector, LinkedList<CPair<C>>> pairlist;
    protected final List<BitSet> red;
    protected final CReductionSeq<C> reduction;
    protected boolean oneInGB = false;
    protected boolean useCriterion4 = false;
    protected int putCount;
    protected int remCount;
    protected final int moduleVars;

    public OrderedCPairlist(GenPolynomialRing<GenPolynomial<C>> r) {
        this(0, r);
    }

    public OrderedCPairlist(int m, GenPolynomialRing<GenPolynomial<C>> r) {
        this.moduleVars = m;
        this.ring = r;
        this.P = new ArrayList<ColorPolynomial<C>>();
        this.pairlist = new TreeMap<ExpVector, LinkedList<CPair<C>>>(this.ring.tord.getAscendComparator());
        this.red = new ArrayList<BitSet>();
        this.putCount = 0;
        this.remCount = 0;
        if (this.ring instanceof GenSolvablePolynomialRing) {
            this.useCriterion4 = false;
        }
        RingFactory rf = this.ring.coFac;
        GenPolynomialRing cf = (GenPolynomialRing)rf;
        this.reduction = new CReductionSeq(cf.coFac);
    }

    private OrderedCPairlist(int m, GenPolynomialRing<GenPolynomial<C>> ring, List<ColorPolynomial<C>> P, SortedMap<ExpVector, LinkedList<CPair<C>>> pl, List<BitSet> red, CReductionSeq<C> cred, int pc, int rc) {
        this.moduleVars = m;
        this.ring = ring;
        this.P = P;
        this.pairlist = pl;
        this.red = red;
        this.reduction = cred;
        this.putCount = pc;
        this.remCount = rc;
    }

    public synchronized OrderedCPairlist<C> copy() {
        return new OrderedCPairlist<C>(this.moduleVars, this.ring, new ArrayList<ColorPolynomial<C>>(this.P), this.clonePairlist(), this.cloneBitSet(), this.reduction, this.putCount, this.remCount);
    }

    private SortedMap<ExpVector, LinkedList<CPair<C>>> clonePairlist() {
        TreeMap<ExpVector, LinkedList<CPair<C>>> pl = new TreeMap<ExpVector, LinkedList<CPair<C>>>(this.ring.tord.getAscendComparator());
        for (Map.Entry<ExpVector, LinkedList<CPair<C>>> m : this.pairlist.entrySet()) {
            ExpVector e = m.getKey();
            LinkedList<CPair<C>> l = m.getValue();
            l = new LinkedList<CPair<C>>(l);
            pl.put(e, l);
        }
        return pl;
    }

    public int pairCount() {
        int c = 0;
        for (Map.Entry<ExpVector, LinkedList<CPair<C>>> m : this.pairlist.entrySet()) {
            LinkedList<CPair<C>> l = m.getValue();
            c += l.size();
        }
        return c;
    }

    private List<BitSet> cloneBitSet() {
        ArrayList<BitSet> r = new ArrayList<BitSet>(this.red.size());
        for (BitSet b : this.red) {
            BitSet n = (BitSet)b.clone();
            r.add(n);
        }
        return r;
    }

    public int bitCount() {
        int c = 0;
        for (BitSet b : this.red) {
            c += b.cardinality();
        }
        return c;
    }

    public String toString() {
        int b;
        int p = this.pairCount();
        if (p != (b = this.bitCount())) {
            return "OrderedCPairlist( pairCount=" + p + ", bitCount=" + b + ", putCount=" + this.putCount + ", remCount=" + this.remCount + " )";
        }
        return "OrderedCPairlist( pairCount=" + p + ", putCount=" + this.putCount + ", remCount=" + this.remCount + " )";
    }

    public boolean equals(Object ob) {
        OrderedCPairlist c = null;
        try {
            c = (OrderedCPairlist)ob;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (c == null) {
            return false;
        }
        boolean t = this.getList().equals(c.getList());
        if (!t) {
            return t;
        }
        boolean bl = t = this.pairCount() == c.pairCount();
        if (!t) {
            return t;
        }
        return true;
    }

    public int hashCode() {
        int h = this.getList().hashCode();
        h <<= 7;
        return h += this.pairCount();
    }

    public synchronized int put(ColorPolynomial<C> p) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector e = p.leadingExpVector();
        int l = this.P.size();
        for (int j = 0; j < l; ++j) {
            ColorPolynomial<C> pj = this.P.get(j);
            ExpVector f = pj.leadingExpVector();
            if (this.moduleVars > 0 && e.invLexCompareTo(f, 0, this.moduleVars) != 0) continue;
            ExpVector g = e.lcm(f);
            CPair<C> pair = new CPair<C>(pj, p, j, l);
            LinkedList<CPair<C>> xl = (LinkedList<CPair<C>>)this.pairlist.get(g);
            if (xl == null) {
                xl = new LinkedList<CPair<C>>();
            }
            xl.addFirst(pair);
            this.pairlist.put(g, xl);
        }
        this.P.add(p);
        BitSet redi = new BitSet();
        redi.set(0, l);
        this.red.add(redi);
        return this.P.size() - 1;
    }

    public synchronized CPair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<ExpVector, LinkedList<CPair<C>>>> ip = this.pairlist.entrySet().iterator();
        CPair<C> pair = null;
        boolean c = false;
        while (!c && ip.hasNext()) {
            Map.Entry<ExpVector, LinkedList<CPair<C>>> me = ip.next();
            ExpVector g = me.getKey();
            LinkedList<CPair<C>> xl = me.getValue();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("g  = " + g));
            }
            pair = null;
            while (!c && xl.size() > 0) {
                pair = xl.removeFirst();
                int i = pair.i;
                int j = pair.j;
                c = true;
                this.red.get(j).clear(i);
            }
            if (xl.size() != 0) continue;
            ip.remove();
        }
        if (!c) {
            pair = null;
        } else {
            ++this.remCount;
        }
        return pair;
    }

    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    public List<ColorPolynomial<C>> getList() {
        return this.P;
    }

    public synchronized int putCount() {
        return this.putCount;
    }

    public synchronized int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(ColorPolynomial<C> one) {
        ++this.putCount;
        if (one == null) {
            return this.P.size() - 1;
        }
        if (!one.isONE()) {
            return this.P.size() - 1;
        }
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add(one);
        this.red.clear();
        return this.P.size() - 1;
    }

    public boolean criterion3(int i, int j, ExpVector eij) {
        boolean s = this.red.get(j).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        for (int k = 0; k < this.P.size(); ++k) {
            ColorPolynomial<C> A;
            ExpVector ek;
            boolean m;
            if (i == k || j == k || !(m = eij.multipleOf(ek = (A = this.P.get(k)).leadingExpVector()))) continue;
            if (k < i) {
                s = this.red.get(i).get(k) || this.red.get(j).get(k);
            } else if (i < k && k < j) {
                s = this.red.get(k).get(i) || this.red.get(j).get(k);
            } else if (j < k) {
                boolean bl = s = this.red.get(k).get(i) || this.red.get(k).get(j);
            }
            if (s) continue;
            return s;
        }
        return true;
    }
}

