/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.FactorRealReal;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorAlgebraic;
import edu.jas.ufd.FactorComplex;
import edu.jas.ufd.FactorQuotient;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufdroot.FactorRealAlgebraic;
import org.apache.log4j.Logger;

public class FactorFactory
extends edu.jas.ufd.FactorFactory {
    private static final Logger logger = Logger.getLogger(FactorFactory.class);

    protected FactorFactory() {
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<AlgebraicNumber<C>> getImplementation(AlgebraicNumberRing<C> fac) {
        return new FactorAlgebraic<C>(fac, FactorFactory.getImplementation(fac.ring.coFac));
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Complex<C>> getImplementation(ComplexRing<C> fac) {
        return new FactorComplex<C>(fac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac) {
        return new FactorQuotient<C>(fac, FactorFactory.getImplementation(fac.ring.coFac));
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(GenPolynomialRing<C> fac) {
        return FactorFactory.getImplementation(fac.coFac);
    }

    public static <C extends GcdRingElem<C> & Rational> FactorAbstract<edu.jas.root.RealAlgebraicNumber<C>> getImplementation(edu.jas.root.RealAlgebraicRing<C> fac) {
        return new FactorRealAlgebraic<C>(fac, FactorFactory.getImplementation(fac.algebraic));
    }

    public static <C extends GcdRingElem<C> & Rational> FactorAbstract<RealAlgebraicNumber<C>> getImplementation(RealAlgebraicRing<C> fac) {
        edu.jas.root.RealAlgebraicRing rar = fac.realRing;
        return new FactorRealReal<C>(fac, FactorFactory.getImplementation(rar));
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(RingFactory<C> fac) {
        logger.info((Object)("app factor factory = " + fac.getClass().getName()));
        FactorAbstract ufd = null;
        RealAlgebraicRing rrfac = null;
        edu.jas.root.RealAlgebraicRing rfac = null;
        AlgebraicNumberRing afac = null;
        ComplexRing cfac = null;
        QuotientRing qfac = null;
        GenPolynomialRing pfac = null;
        RingFactory<C> ofac = fac;
        if (ofac instanceof RealAlgebraicRing) {
            rrfac = (RealAlgebraicRing)ofac;
            ufd = new FactorRealReal(rrfac, FactorFactory.getImplementation(rrfac.realRing));
        } else if (ofac instanceof edu.jas.root.RealAlgebraicRing) {
            rfac = (edu.jas.root.RealAlgebraicRing)ofac;
            ufd = new FactorRealAlgebraic(rfac, FactorFactory.getImplementation(rfac.algebraic));
        } else if (ofac instanceof ComplexRing) {
            cfac = (ComplexRing)ofac;
            afac = cfac.algebraicRing();
            ufd = new FactorComplex<C>(cfac, FactorFactory.getImplementation(afac));
        } else if (ofac instanceof AlgebraicNumberRing) {
            afac = (AlgebraicNumberRing)ofac;
            ufd = new FactorAlgebraic(afac, FactorFactory.getImplementation(afac.ring.coFac));
        } else if (ofac instanceof QuotientRing) {
            qfac = (QuotientRing)ofac;
            ufd = new FactorQuotient(qfac, FactorFactory.getImplementation(qfac.ring.coFac));
        } else if (ofac instanceof GenPolynomialRing) {
            pfac = (GenPolynomialRing)ofac;
            ufd = FactorFactory.getImplementation(pfac.coFac);
        } else {
            ufd = edu.jas.ufd.FactorFactory.getImplementation(fac);
        }
        return ufd;
    }
}

