/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import javax.swing.SwingWorker;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.logging.CommonLogger;
import kcl.waterloo.xml.GJEncoder;
import kcl.waterloo.xml.Separator;

public class GJDecoder {
    private static Class defaultVectorClass = GJDefaults.getDataClass();
    private static LinkedHashMap<String, Object> defaultMap = GJDefaults.getMap();
    private static boolean updateMessage = false;
    private static final CommonLogger logger = new CommonLogger(GJDecoder.class);
    private static String fileToLoad = "";
    private static final ExceptionListener exHandler = new ExceptionListener(){

        @Override
        public void exceptionThrown(Exception excptn) {
            if (excptn.toString().contains("java.lang.NullPointerException")) {
                logger.warn("NullPointerException: This may reflect a change in the defaults table between Waterloo versions.");
                logger.warn("Attempting to continue with standard defaults instead of those from file.");
                GJDefaults.setMap(defaultMap);
            } else if (excptn.toString().contains("GJGraph.setCurrentMousePosition")) {
                if (updateMessage) {
                    logger.warn("setCurrentMousePosition: GJGraph.setCurrentMousePosition now private (Alpha3)");
                    logger.warn(fileToLoad.concat(" read OK, but it should be re-saved to update it"));
                    updateMessage = false;
                }
            } else if (excptn.toString().contains("GJDoubleDataVector.setParentPlot")) {
                if (updateMessage) {
                    logger.warn(fileToLoad.concat(" read OK, but it should be re-saved to update it"));
                    updateMessage = false;
                }
            } else if (excptn.toString().contains(".setAxis(GJDataVectorInterface$AXIS)")) {
                if (updateMessage) {
                    logger.warn(fileToLoad.concat(" read OK, but it should be re-saved to update it"));
                    updateMessage = false;
                }
            } else {
                logger.error(excptn.getMessage());
            }
        }
    };

    protected static LinkedHashMap<String, Object> getDefaultMap() {
        return defaultMap;
    }

    private GJDecoder() {
    }

    static InputStream createInputStream(String fileName) {
        block5: {
            try {
                int dotPos = fileName.lastIndexOf(".");
                String extension = fileName.substring(dotPos);
                FileInputStream input = new FileInputStream(fileName);
                BufferedInputStream buffer = new BufferedInputStream(input);
                fileToLoad = fileName;
                if (extension.equalsIgnoreCase(".gz")) {
                    try {
                        return new GZIPInputStream(buffer);
                    }
                    catch (IOException ex) {
                        logger.error(ex.getMessage());
                        break block5;
                    }
                }
                return buffer;
            }
            catch (FileNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return null;
    }

    public static Object load(String fileName) {
        fileToLoad = fileName;
        return GJDecoder.load(fileName, GJDecoder.createInputStream(fileName));
    }

    public static Object load(final String fileName, final InputStream stream) {
        fileToLoad = fileName.isEmpty() ? "Unknown source" : fileName;
        updateMessage = true;
        SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object doInBackground() throws Exception {
                GJDefaults gJDefaults = GJDefaults.getInstance();
                synchronized (gJDefaults) {
                    defaultVectorClass = GJDefaults.getDataClass();
                    defaultMap = GJDefaults.getMap();
                    GJDefaults.setDeserializing(true);
                    Thread.currentThread().setContextClassLoader(GJDecoder.class.getClassLoader());
                    XMLDecoder d = new XMLDecoder(stream);
                    d.setOwner(GJDefaults.getInstance());
                    GJDefaults.setDataClass(null);
                    d.setExceptionListener(exHandler);
                    Object thisObject = d.readObject();
                    thisObject = d.readObject();
                    Long majorVersion = (Long)d.readObject();
                    Long minorVersion = (Long)d.readObject();
                    thisObject = d.readObject();
                    String Version2 = (String)d.readObject();
                    GJDefaults fileDefaults = (GJDefaults)d.readObject();
                    if (majorVersion.compareTo(GJEncoder.Header.majorVersion) > 0) {
                        logger.warn(fileName.concat(" was written with a more recent version of the Waterloo"));
                    } else if (majorVersion.compareTo(GJEncoder.Header.majorVersion) == 0 && minorVersion.compareTo(GJEncoder.Header.minorVersion) > 0) {
                        logger.warn(fileName.concat(" was written with a more recent version of the Waterloo"));
                    }
                    LinkedHashMap<String, Object> map = null;
                    thisObject = d.readObject();
                    if (thisObject instanceof Separator) {
                        thisObject = GJDecoder.compoundLoader(d);
                        ArrayList arrayList = (ArrayList)thisObject;
                        map = new LinkedHashMap<String, Object>();
                        ArrayList list = new ArrayList(arrayList.subList(0, arrayList.size() - 1));
                        map.put("Graphics", list);
                        map.put("ExceptionLog", arrayList.get(arrayList.size() - 1));
                    } else if (thisObject instanceof LinkedHashMap) {
                        map = (LinkedHashMap<String, Object>)thisObject;
                        thisObject = d.readObject();
                        map.put("Graphics", thisObject);
                        ((Component)thisObject).setPreferredSize((Dimension)map.get("Dimension"));
                        map.put("ExceptionLog", d.readObject());
                    }
                    GJDecoder.doClose(d);
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        logger.error(ex.getMessage());
                    }
                    if (map == null) {
                        return thisObject;
                    }
                    return map;
                }
            }
        };
        worker.execute();
        try {
            return worker.get(50L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            logger.error(ex.getMessage());
        }
        catch (ExecutionException ex) {
            logger.error(ex.getMessage());
        }
        catch (TimeoutException ex) {
            logger.error(ex.getMessage());
        }
        return null;
    }

    private static void doClose(XMLDecoder d) {
        GJDefaults.setDataClass(defaultVectorClass);
        GJDefaults.setMap(GJDecoder.getDefaultMap());
        GJDefaults.setDeserializing(false);
        d.close();
    }

    private static Object compoundLoader(XMLDecoder d) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (true) {
            Object thisObject;
            try {
                thisObject = d.readObject();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return list;
            }
            if (thisObject instanceof GJAbstractGraphContainer) {
                list.add(thisObject);
                continue;
            }
            if (thisObject instanceof LinkedHashMap) {
                list.add(thisObject);
                continue;
            }
            if (!(thisObject instanceof ArrayList)) continue;
            list.add(thisObject);
        }
    }
}

