/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JPanel;

public class GJGradientPanel
extends JPanel
implements Serializable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private int Anchor;
    private float Repeats;
    private Color Color1 = Color.lightGray;
    private Color Color2 = Color.gray;
    private GradientPaint Gradient;
    private Dimension lastPaintedDimension;

    public GJGradientPanel() {
        this(1);
    }

    public GJGradientPanel(int a) {
        this.Anchor = a;
        this.Repeats = 1.0f;
        this.updateGradient();
        this.addPropertyChangeListener(this);
    }

    public void setBackground(GradientPaint p) {
        this.Color1 = p.getColor1();
        this.Color2 = p.getColor2();
        this.Gradient = p;
        this.firePropertyChange("Gradient", null, null);
    }

    public float getRepeats() {
        return this.Repeats;
    }

    public void setRepeats(float r) {
        float old = this.Repeats;
        this.Repeats = r;
        this.updateGradient();
        this.firePropertyChange("Repeats", old, this.Repeats);
    }

    public int getAnchor() {
        return this.Anchor;
    }

    public void setAnchor(int anchor) {
        int old = this.Anchor;
        if (anchor == 1 || anchor == 5 || anchor == 7 || anchor == 3 || anchor == 2 || anchor == 8) {
            this.Anchor = anchor;
            this.firePropertyChange("Anchor", old, this.Anchor);
        }
    }

    public Color getColor1() {
        return this.Color1;
    }

    public void setColor1(Color c) {
        Color old = this.Color1;
        this.Color1 = c;
        this.firePropertyChange("Color1", old, this.Color1);
    }

    public Color getColor2() {
        return this.Color2;
    }

    public void setColor2(Color c) {
        Color old = this.Color2;
        this.Color2 = c;
        this.firePropertyChange("Color1", old, this.Color1);
    }

    private Point getPoint1() {
        if (this.Anchor == 1) {
            return new Point(this.getWidth() / 2, 0);
        }
        if (this.Anchor == 5) {
            return new Point(this.getWidth() / 2, this.getHeight());
        }
        if (this.Anchor == 7) {
            return new Point(0, this.getHeight() / 2);
        }
        if (this.Anchor == 3) {
            return new Point(this.getWidth(), this.getHeight() / 2);
        }
        if (this.Anchor == 8) {
            return new Point(0, 0);
        }
        if (this.Anchor == 2) {
            return new Point(this.getWidth(), 0);
        }
        return null;
    }

    private Point getPoint2() {
        if (this.Anchor == 1) {
            return new Point(this.getWidth() / 2, this.getHeight());
        }
        if (this.Anchor == 5) {
            return new Point(this.getWidth() / 2, 0);
        }
        if (this.Anchor == 7) {
            return new Point(this.getWidth(), this.getHeight() / 2);
        }
        if (this.Anchor == 3) {
            return new Point(0, this.getHeight() / 2);
        }
        if (this.Anchor == 8) {
            return new Point(this.getWidth(), this.getHeight());
        }
        if (this.Anchor == 2) {
            return new Point(0, this.getHeight());
        }
        return null;
    }

    private void updateGradient() {
        Point point1 = this.getPoint1();
        Point point2 = this.getPoint2();
        if (this.Repeats != 1.0f) {
            if (this.Anchor == 1) {
                point2 = new Point((int)point2.getX(), (int)(point2.getY() / (double)this.Repeats));
            } else if (this.Anchor == 7) {
                point2 = new Point((int)(point2.getX() / (double)this.Repeats), (int)point2.getY());
            } else if (this.Anchor == 5) {
                point1 = new Point((int)point1.getX(), (int)(point1.getY() / (double)this.Repeats));
            } else if (this.Anchor == 3) {
                point1 = new Point((int)(point1.getX() / (double)this.Repeats), (int)point1.getY());
            } else if (this.Anchor == 8) {
                point2 = new Point((int)(point2.getX() / (double)this.Repeats), (int)(point2.getY() / (double)this.Repeats));
            } else if (this.Anchor == 2) {
                point2 = new Point((int)(point1.getX() - point1.getX() / (double)this.Repeats), (int)(point2.getY() / (double)this.Repeats));
            }
        }
        this.Gradient = new GradientPaint(point1, this.Color1, point2, this.Color2, true);
        this.lastPaintedDimension = this.getSize();
    }

    private boolean isValidGradient() {
        return this.lastPaintedDimension == this.getSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isOpaque()) {
            super.paintComponent(g);
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (!this.isValidGradient()) {
            this.updateGradient();
        }
        super.paintComponent(g);
        g2d.setPaint(this.Gradient);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.updateGradient();
        this.repaint();
    }
}

