/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;

public final class GJStairs
extends GJAbstractPlot {
    private static final long serialVersionUID = 1L;

    public GJStairs() {
    }

    public GJStairs(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        return GJAbstractPlot.createInstance(new GJStairs());
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        double[] xposition = this.getParentGraph().xPositionToPixeli(this.getXDataValues());
        double[] yposition = this.getParentGraph().yPositionToPixeli(this.getYDataValues());
        super.paintPlot(g2);
        this.getScreenDataArray().clear();
        int N = this.getMultiplexLength();
        for (int idx = 0; idx < N; ++idx) {
            Path2D.Double path = new Path2D.Double();
            int idx2 = idx;
            while (Double.isNaN(yposition[idx2])) {
                idx2 += N;
            }
            ((Path2D)path).moveTo(xposition[idx2], yposition[idx2]);
            for (int i = idx2; i < xposition.length - 1; i += N) {
                if (Double.isNaN(xposition[i]) || Double.isNaN(yposition[i]) || Double.isInfinite(xposition[i]) || Double.isInfinite(yposition[i])) continue;
                ((Path2D)path).lineTo(xposition[i + 1], yposition[i]);
                ((Path2D)path).lineTo(xposition[i + 1], yposition[i + 1]);
            }
            if (!(Double.isNaN(xposition[xposition.length - 1]) || Double.isNaN(yposition[yposition.length - 1]) || Double.isInfinite(xposition[xposition.length - 1]) || Double.isInfinite(yposition[yposition.length - 1]))) {
                ((Path2D)path).lineTo(xposition[xposition.length - 1], yposition[yposition.length - 1]);
            }
            g2.setPaint((Paint)this.getVisualModel().getLineColor().get(idx));
            g2.setStroke((Stroke)this.getVisualModel().getLineStroke().get(idx));
            g2.draw(path);
            this.getScreenDataArray().add(path);
        }
    }
}

