/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJRoi;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.math.ArrayUtils;

public class GJColorBar
extends GJRoi
implements ActionListener {
    private GJPlotInterface parentPlot;
    private JPopupMenu popup;
    private ORIENTATION orientation = ORIENTATION.VERTICAL;
    private String[] labels = null;
    private LABELPOSITION labelPosition = LABELPOSITION.BORDER;
    private int labelInterval = 1;

    public GJColorBar() {
        this.setBorder(null);
        this.removeIcons();
        this.setBackgroundPainted(false);
        this.addPopUp();
        this.minSiz = 20;
    }

    public static GJColorBar createInstance(GJPlotInterface plot) {
        GJAbstractGraph gr = (GJAbstractGraph)plot.getParentGraph();
        Rectangle2D r = gr.getAxesBounds();
        return GJColorBar.createInstance(plot, new Rectangle2D.Double(r.getX() + r.getWidth() - 0.15 * r.getWidth(), r.getY() + r.getHeight() - 0.5 * r.getHeight(), 0.05 * r.getWidth(), 0.4 * r.getHeight()));
    }

    public static GJColorBar createInstance(final GJPlotInterface plot, final Rectangle2D.Double r) {
        final GJAbstractGraph gr = (GJAbstractGraph)plot.getParentGraph();
        final GJColorBar colorbar = new GJColorBar();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                colorbar.parentPlot = plot;
                gr.add(colorbar);
                colorbar.setAxesRectangle(r);
                if (gr.getGraphContainer() != null) {
                    gr.getGraphContainer().addComponentListener(colorbar);
                    gr.getGraphContainer().addPropertyChangeListener(colorbar);
                }
                gr.addPropertyChangeListener(colorbar);
                colorbar.setFont(gr.getFont().deriveFont(8));
                gr.repaint();
            }
        });
        return colorbar;
    }

    public GJPlotInterface getParentPlot() {
        return this.parentPlot;
    }

    public void setParentPlot(GJPlotInterface p) {
        if (this.parentPlot != null && !p.getParentGraph().equals(this.parentPlot.getParentGraph())) {
            ((GJAbstractGraph)p.getParentGraph()).add(this);
        }
        this.parentPlot = p;
    }

    public ORIENTATION getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ORIENTATION orientation) {
        this.orientation = orientation;
        this.setPixelRectangle(new Rectangle2D.Double(this.getX(), this.getY(), this.getHeight(), this.getWidth()));
        this.revalidate();
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public void setLabels(double[] labels) {
        this.setLabels(ArrayUtils.boxed(labels), "%3.2f");
    }

    public void setLabels(double[] labels, String format) {
        this.setLabels(ArrayUtils.boxed(labels), format);
    }

    public void setLabels(Double[] labels) {
        this.setLabels(labels, "%3.2f");
    }

    public void setLabels(Double[] labels, String format) {
        this.labels = new String[labels.length];
        for (int k = 0; k < labels.length; ++k) {
            this.labels[k] = labels[k].isNaN() ? "" : String.format(format, labels[k]);
        }
    }

    public LABELPOSITION getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LABELPOSITION labelPosition) {
        this.labelPosition = labelPosition;
    }

    @Override
    public final void paintComponent(Graphics g) {
        if (this.parentPlot.getFill() != null && this.parentPlot.getFill().size() > 0) {
            int k;
            Graphics2D g2 = (Graphics2D)g.create();
            this.paintBackground(g2);
            Rectangle bounds = this.getBounds();
            Rectangle2D.Double r = new Rectangle2D.Double(((RectangularShape)bounds).getX(), ((RectangularShape)bounds).getY(), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
            FontMetrics metrics = g2.getFontMetrics();
            int maxStringWidth = 0;
            int stringAscent = metrics.getAscent();
            if (this.labels != null) {
                for (k = 0; k < this.labels.length; ++k) {
                    if (this.labels[k].isEmpty()) continue;
                    maxStringWidth = Math.max(maxStringWidth, metrics.stringWidth(this.labels[k]));
                }
            }
            switch (this.orientation) {
                case VERTICAL: {
                    double inc = (double)this.getHeight() / (double)this.parentPlot.getMultiplexLength();
                    if (this.labels == null) {
                        ((Rectangle2D)r).setRect(0.0, ((RectangularShape)r).getHeight() - inc, ((RectangularShape)r).getWidth(), inc);
                    } else {
                        ((Rectangle2D)r).setRect(0.0, ((RectangularShape)r).getHeight() - inc, Math.max(((RectangularShape)r).getWidth() / 4.0, ((RectangularShape)r).getWidth() - 1.2 * (double)maxStringWidth), inc);
                    }
                    for (k = 0; k < this.parentPlot.getMultiplexLength(); ++k) {
                        g2.setPaint((Paint)this.parentPlot.getFill().get(k));
                        g2.fill(r);
                        if (this.labels != null && k < this.labels.length && Math.IEEEremainder(k, this.labelInterval) == 0.0 && !this.labels[k].isEmpty()) {
                            g2.setPaint(this.getForeground());
                            if (this.labelPosition == LABELPOSITION.CENTER) {
                                g2.drawString(this.labels[k], (float)(((RectangularShape)r).getWidth() + 2.0), (float)(((RectangularShape)r).getY() + inc - (double)stringAscent / 2.0));
                            } else if (k < this.labels.length - 1) {
                                g2.drawString(this.labels[k], (float)(((RectangularShape)r).getWidth() + 2.0), (float)(((RectangularShape)r).getY() + (double)stringAscent / 2.0));
                            }
                        }
                        ((Rectangle2D)r).setRect(0.0, ((RectangularShape)r).getY() - inc, ((RectangularShape)r).getWidth(), inc);
                    }
                    break;
                }
                case HORIZONTAL: {
                    double inc = (double)this.getWidth() / (double)this.parentPlot.getMultiplexLength();
                    if (this.labels == null) {
                        ((Rectangle2D)r).setRect(0.0, 0.0, inc, this.getHeight());
                    } else {
                        ((Rectangle2D)r).setRect(0.0, 0.0, inc, (double)this.getHeight() / 4.0);
                    }
                    AffineTransform af = g2.getTransform();
                    for (int k2 = 0; k2 < this.parentPlot.getMultiplexLength(); ++k2) {
                        g2.setPaint((Paint)this.parentPlot.getFill().get(k2));
                        g2.fill(r);
                        if (this.labels != null && k2 < this.labels.length && Math.IEEEremainder(k2, this.labelInterval) == 0.0 && !this.labels[k2].isEmpty()) {
                            g2.setPaint(this.getForeground());
                            if (this.labelPosition == LABELPOSITION.CENTER) {
                                g2.rotate(1.5707963267948966, (float)(((RectangularShape)r).getX() + inc / 2.0 - (double)stringAscent / 2.0), (float)(((RectangularShape)r).getHeight() + 2.0));
                                g2.drawString(this.labels[k2], (float)(((RectangularShape)r).getX() + inc / 2.0 - (double)stringAscent / 2.0), (float)(((RectangularShape)r).getHeight() + 2.0));
                            } else if (k2 < this.labels.length - 1) {
                                g2.rotate(1.5707963267948966, (float)(((RectangularShape)r).getX() + inc - (double)stringAscent / 2.0), (float)(((RectangularShape)r).getHeight() + 2.0));
                                g2.drawString(this.labels[k2], (float)(((RectangularShape)r).getX() + inc - (double)stringAscent / 2.0), (float)(((RectangularShape)r).getHeight() + 2.0));
                            }
                        }
                        ((Rectangle2D)r).setRect(((RectangularShape)r).getX() + inc, 0.0, inc, ((RectangularShape)r).getHeight());
                        g2.setTransform(af);
                    }
                    break;
                }
            }
            g2.dispose();
        }
    }

    private void addPopUp() {
        this.popup = new JPopupMenu();
        JMenu menu = new JMenu("Alignment");
        JMenuItem menuItem = menu.add(new JMenuItem("Vertical"));
        menuItem.setActionCommand("Vertical");
        menuItem.addActionListener(this);
        menuItem = menu.add(new JMenuItem("Horizontal"));
        menuItem.setActionCommand("Horizontal");
        menuItem.addActionListener(this);
        this.popup.add(menu);
        menu = new JMenu("Color Scheme");
        this.popup.add(menu);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.popup.addMouseListener(popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Vertical")) {
            this.setOrientation(ORIENTATION.VERTICAL);
        } else if (e.getActionCommand().equals("Horizontal")) {
            this.setOrientation(ORIENTATION.HORIZONTAL);
        }
    }

    public int getLabelInterval() {
        return this.labelInterval;
    }

    public void setLabelInterval(int labelInterval) {
        this.labelInterval = labelInterval;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GJColorBar.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public static enum LABELPOSITION {
        CENTER,
        BORDER;

    }

    public static enum ORIENTATION {
        VERTICAL,
        HORIZONTAL;

    }
}

