/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.defaults;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kcl.waterloo.math.ArrayMath;

public class Colors {
    private static final LinkedHashMap<String, Color> color = new LinkedHashMap();
    private static final LinkedHashMap<Integer, Color> blueDarkOrange18 = new LinkedHashMap();
    private static final LinkedHashMap<Integer, Color> blueDarkRed18 = new LinkedHashMap();
    private static LinkedHashMap<Integer, Color> defaultMap = blueDarkRed18;
    private static final double ref_X = 95.047;
    private static final double ref_Y = 100.0;
    private static final double ref_Z = 108.883;
    private static final Colors instance = new Colors();

    private Colors() {
        color.put("TRANSPARENT", new Color(0, 0, 0, 0));
        color.put("ALICEBLUE", new Color(240, 248, 255));
        color.put("ANTIQUEWHITE", new Color(250, 235, 215));
        color.put("AQUA", new Color(0, 255, 255));
        color.put("AQUAMARINE", new Color(127, 255, 212));
        color.put("AZURE", new Color(240, 255, 255));
        color.put("BEIGE", new Color(245, 245, 220));
        color.put("BISQUE", new Color(255, 228, 196));
        color.put("BLACK", new Color(0, 0, 0));
        color.put("BLANCHEDALMOND", new Color(255, 235, 205));
        color.put("BLUE", new Color(0, 0, 255));
        color.put("BLUEVIOLET", new Color(138, 43, 226));
        color.put("BROWN", new Color(165, 42, 42));
        color.put("BURLYWOOD", new Color(222, 184, 135));
        color.put("CADETBLUE", new Color(95, 158, 160));
        color.put("CHARTREUSE", new Color(127, 255, 0));
        color.put("CHOCOLATE", new Color(210, 105, 30));
        color.put("CORAL", new Color(255, 127, 80));
        color.put("CORNFLOWERBLUE", new Color(100, 149, 237));
        color.put("CORNSILK", new Color(255, 248, 220));
        color.put("CRIMSON", new Color(220, 20, 60));
        color.put("CYAN", new Color(0, 255, 255));
        color.put("DARKBLUE", new Color(0, 0, 139));
        color.put("DARKCYAN", new Color(0, 139, 139));
        color.put("DARKGOLDENROD", new Color(184, 134, 11));
        color.put("DARKGRAY", new Color(169, 169, 169));
        color.put("DARKGREEN", new Color(0, 100, 0));
        color.put("DARKGREY", new Color(169, 169, 169));
        color.put("DARKKHAKI", new Color(189, 183, 107));
        color.put("DARKMAGENTA", new Color(139, 0, 139));
        color.put("DARKOLIVEGREEN", new Color(85, 107, 47));
        color.put("DARKORANGE", new Color(255, 140, 0));
        color.put("DARKORCHID", new Color(153, 50, 204));
        color.put("DARKRED", new Color(139, 0, 0));
        color.put("DARKSALMON", new Color(233, 150, 122));
        color.put("DARKSEAGREEN", new Color(143, 188, 143));
        color.put("DARKSLATEBLUE", new Color(72, 61, 139));
        color.put("DARKSLATEGRAY", new Color(47, 79, 79));
        color.put("DARKSLATEGREY", new Color(47, 79, 79));
        color.put("DARKTURQUOISE", new Color(0, 206, 209));
        color.put("DARKVIOLET", new Color(148, 0, 211));
        color.put("DEEPPINK", new Color(255, 20, 147));
        color.put("DEEPSKYBLUE", new Color(0, 191, 255));
        color.put("DIMGRAY", new Color(105, 105, 105));
        color.put("DIMGREY", new Color(105, 105, 105));
        color.put("DODGERBLUE", new Color(30, 144, 255));
        color.put("FIREBRICK", new Color(178, 34, 34));
        color.put("FLORALWHITE", new Color(255, 250, 240));
        color.put("FORESTGREEN", new Color(34, 139, 34));
        color.put("FUCHSIA", new Color(255, 0, 255));
        color.put("GAINSBORO", new Color(220, 220, 220));
        color.put("GHOSTWHITE", new Color(248, 248, 255));
        color.put("GOLD", new Color(255, 215, 0));
        color.put("GOLDENROD", new Color(218, 165, 32));
        color.put("GRAY", new Color(128, 128, 128));
        color.put("GREEN", new Color(0, 128, 0));
        color.put("GREENYELLOW", new Color(173, 255, 47));
        color.put("GREY", new Color(128, 128, 128));
        color.put("HONEYDEW", new Color(240, 255, 240));
        color.put("HOTPINK", new Color(255, 105, 180));
        color.put("INDIANRED", new Color(205, 92, 92));
        color.put("INDIGO", new Color(75, 0, 130));
        color.put("IVORY", new Color(255, 255, 240));
        color.put("KHAKI", new Color(240, 230, 140));
        color.put("LAVENDER", new Color(230, 230, 250));
        color.put("LAVENDERBLUSH", new Color(255, 240, 245));
        color.put("LAWNGREEN", new Color(124, 252, 0));
        color.put("LEMONCHIFFON", new Color(255, 250, 205));
        color.put("LIGHTBLUE", new Color(173, 216, 230));
        color.put("LIGHTCORAL", new Color(240, 128, 128));
        color.put("LIGHTCYAN", new Color(224, 255, 255));
        color.put("LIGHTGOLDENRODYELLOW", new Color(250, 250, 210));
        color.put("LIGHTGRAY", new Color(211, 211, 211));
        color.put("LIGHTGREEN", new Color(144, 238, 144));
        color.put("LIGHTGREY", new Color(211, 211, 211));
        color.put("LIGHTPINK", new Color(255, 182, 193));
        color.put("LIGHTSALMON", new Color(255, 160, 122));
        color.put("LIGHTSEAGREEN", new Color(32, 178, 170));
        color.put("LIGHTSKYBLUE", new Color(135, 206, 250));
        color.put("LIGHTSLATEGRAY", new Color(119, 136, 153));
        color.put("LIGHTSLATEGREY", new Color(119, 136, 153));
        color.put("LIGHTSTEELBLUE", new Color(176, 196, 222));
        color.put("LIGHTYELLOW", new Color(255, 255, 224));
        color.put("LIME", new Color(0, 255, 0));
        color.put("LIMEGREEN", new Color(50, 205, 50));
        color.put("LINEN", new Color(250, 240, 230));
        color.put("MAGENTA", new Color(255, 0, 255));
        color.put("MAROON", new Color(128, 0, 0));
        color.put("MEDIUMAQUAMARINE", new Color(102, 205, 170));
        color.put("MEDIUMBLUE", new Color(0, 0, 205));
        color.put("MEDIUMORCHID", new Color(186, 85, 211));
        color.put("MEDIUMPURPLE", new Color(147, 112, 219));
        color.put("MEDIUMSEAGREEN", new Color(60, 179, 113));
        color.put("MEDIUMSLATEBLUE", new Color(123, 104, 238));
        color.put("MEDIUMSPRINGGREEN", new Color(0, 250, 154));
        color.put("MEDIUMTURQUOISE", new Color(72, 209, 204));
        color.put("MEDIUMVIOLETRED", new Color(199, 21, 133));
        color.put("MIDNIGHTBLUE", new Color(25, 25, 112));
        color.put("MINTCREAM", new Color(245, 255, 250));
        color.put("MISTYROSE", new Color(255, 228, 225));
        color.put("MOCCASIN", new Color(255, 228, 181));
        color.put("NAVAJOWHITE", new Color(255, 222, 173));
        color.put("NAVY", new Color(0, 0, 128));
        color.put("OLDLACE", new Color(253, 245, 230));
        color.put("OLIVE", new Color(128, 128, 0));
        color.put("OLIVEDRAB", new Color(107, 142, 35));
        color.put("ORANGE", new Color(255, 165, 0));
        color.put("ORANGERED", new Color(255, 69, 0));
        color.put("ORCHID", new Color(218, 112, 214));
        color.put("PALEGOLDENROD", new Color(238, 232, 170));
        color.put("PALEGREEN", new Color(152, 251, 152));
        color.put("PALETURQUOISE", new Color(175, 238, 238));
        color.put("PALEVIOLETRED", new Color(219, 112, 147));
        color.put("PAPAYAWHIP", new Color(255, 239, 213));
        color.put("PEACHPUFF", new Color(255, 218, 185));
        color.put("PERU", new Color(205, 133, 63));
        color.put("PINK", new Color(255, 192, 203));
        color.put("PLUM", new Color(221, 160, 221));
        color.put("POWDERBLUE", new Color(176, 224, 230));
        color.put("PURPLE", new Color(128, 0, 128));
        color.put("RED", new Color(255, 0, 0));
        color.put("ROSYBROWN", new Color(188, 143, 143));
        color.put("ROYALBLUE", new Color(65, 105, 225));
        color.put("SADDLEBROWN", new Color(139, 69, 19));
        color.put("SALMON", new Color(250, 128, 114));
        color.put("SANDYBROWN", new Color(244, 164, 96));
        color.put("SEAGREEN", new Color(46, 139, 87));
        color.put("SEASHELL", new Color(255, 245, 238));
        color.put("SIENNA", new Color(160, 82, 45));
        color.put("SILVER", new Color(192, 192, 192));
        color.put("SKYBLUE", new Color(135, 206, 235));
        color.put("SLATEBLUE", new Color(106, 90, 205));
        color.put("SLATEGRAY", new Color(112, 128, 144));
        color.put("SLATEGREY", new Color(112, 128, 144));
        color.put("SNOW", new Color(255, 250, 250));
        color.put("SPRINGGREEN", new Color(0, 255, 127));
        color.put("STEELBLUE", new Color(70, 130, 180));
        color.put("TAN", new Color(210, 180, 140));
        color.put("TEAL", new Color(0, 128, 128));
        color.put("THISTLE", new Color(216, 191, 216));
        color.put("TOMATO", new Color(255, 99, 71));
        color.put("TURQUOISE", new Color(64, 224, 208));
        color.put("VIOLET", new Color(238, 130, 238));
        color.put("WHEAT", new Color(245, 222, 179));
        color.put("WHITE", new Color(255, 255, 255));
        color.put("WHITESMOKE", new Color(245, 245, 245));
        color.put("YELLOW", new Color(255, 255, 0));
        color.put("YELLOWGREEN", new Color(154, 205, 50));
        color.put("AREAFILL", new Color(245, 222, 179, 200));
        color.put("TRANSPARENTWHITE", new Color(255, 255, 255, 200));
        blueDarkOrange18.put(0, new Color(0, 102, 102));
        blueDarkOrange18.put(1, new Color(0, 153, 153));
        blueDarkOrange18.put(2, new Color(0, 204, 204));
        blueDarkOrange18.put(3, new Color(0, 255, 255));
        blueDarkOrange18.put(4, new Color(51, 255, 255));
        blueDarkOrange18.put(5, new Color(101, 255, 255));
        blueDarkOrange18.put(6, new Color(153, 255, 255));
        blueDarkOrange18.put(7, new Color(178, 255, 255));
        blueDarkOrange18.put(8, new Color(203, 255, 255));
        blueDarkOrange18.put(9, new Color(229, 255, 255));
        blueDarkOrange18.put(10, new Color(255, 229, 203));
        blueDarkOrange18.put(11, new Color(255, 202, 153));
        blueDarkOrange18.put(12, new Color(255, 173, 101));
        blueDarkOrange18.put(13, new Color(255, 142, 51));
        blueDarkOrange18.put(14, new Color(255, 110, 0));
        blueDarkOrange18.put(15, new Color(204, 85, 0));
        blueDarkOrange18.put(16, new Color(153, 61, 0));
        blueDarkOrange18.put(17, new Color(102, 39, 0));
        blueDarkRed18.put(0, new Color(36, 0, 216));
        blueDarkRed18.put(1, new Color(24, 28, 247));
        blueDarkRed18.put(2, new Color(40, 87, 255));
        blueDarkRed18.put(3, new Color(61, 135, 255));
        blueDarkRed18.put(4, new Color(86, 176, 255));
        blueDarkRed18.put(5, new Color(117, 211, 255));
        blueDarkRed18.put(6, new Color(153, 234, 255));
        blueDarkRed18.put(7, new Color(188, 249, 255));
        blueDarkRed18.put(8, new Color(234, 255, 255));
        blueDarkRed18.put(9, new Color(255, 255, 234));
        blueDarkRed18.put(10, new Color(255, 241, 188));
        blueDarkRed18.put(11, new Color(255, 214, 153));
        blueDarkRed18.put(12, new Color(255, 172, 117));
        blueDarkRed18.put(13, new Color(255, 120, 86));
        blueDarkRed18.put(14, new Color(255, 61, 61));
        blueDarkRed18.put(15, new Color(247, 39, 53));
        blueDarkRed18.put(16, new Color(216, 21, 47));
        blueDarkRed18.put(17, new Color(165, 0, 33));
    }

    public static ArrayList<Color> sortByHue() {
        ArrayList<Color> c = new ArrayList<Color>(color.values());
        Collections.sort(c, HueSorter.getInstance());
        return c;
    }

    public static ArrayList<Color> sortBySaturation() {
        ArrayList<Color> c = new ArrayList<Color>(color.values());
        Collections.sort(c, SaturationSorter.getInstance());
        return c;
    }

    public static ArrayList<Color> sortByLightness() {
        ArrayList<Color> c = new ArrayList<Color>(color.values());
        Collections.sort(c, LightnessSorter.getInstance());
        return c;
    }

    public static ArrayList<Color> sortByLuminance() {
        ArrayList<Color> c = new ArrayList<Color>(color.values());
        Collections.sort(c, LuminanceSorter.getInstance());
        return c;
    }

    public static LinkedHashMap<String, Color> getColors() {
        return color;
    }

    public static Color getColor(String s) {
        return color.get(s.toUpperCase());
    }

    public static Color[] getColor(String ... s) {
        Color[] p = new Color[s.length];
        for (int k = 0; k < s.length; ++k) {
            p[k] = color.get(s[k].toUpperCase());
        }
        return p;
    }

    public static String getColor(Color c) {
        if (color.containsValue(c)) {
            for (Map.Entry<String, Color> x : color.entrySet()) {
                if (!x.getValue().equals(c)) continue;
                return x.getKey();
            }
        }
        return "UNKNOWN";
    }

    public static Color getColor(int i) {
        return defaultMap.get(i);
    }

    public static Color getColor(Integer i) {
        return defaultMap.get(i);
    }

    public static float getLuminance(Color color) {
        return (float)color.getRed() * 0.3f + (float)color.getGreen() * 0.59f + (float)color.getBlue() * 0.11f;
    }

    public static float getTheta(Color c) {
        float[] hsl = Colors.toHSL(c);
        return hsl[1] * 360.0f;
    }

    public static float[] getLuminance(Color[] colors) {
        float[] lum = new float[colors.length];
        for (int k = 0; k < colors.length; ++k) {
            lum[k] = Colors.getLuminance(colors[k]);
        }
        return lum;
    }

    private static double hue2RGB(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666666666666 - vH) * 6.0;
        }
        return v1;
    }

    public static Color HSLtoRGB(float h, float s, float l) {
        if ((double)s == 0.0) {
            return new Color(l, l, l);
        }
        double var2 = (double)l < 0.5 ? (double)(l * (1.0f + s)) : (double)(l + s - s * l);
        double var1 = 2.0 * (double)l - var2;
        float r = (float)Colors.hue2RGB(var1, var2, (double)h + 0.3333333333333333);
        float g = (float)Colors.hue2RGB(var1, var2, h);
        float b = (float)Colors.hue2RGB(var1, var2, (double)h - 0.3333333333333333);
        return new Color(r, g, b);
    }

    public static float[] toHSL(Color color) {
        double s;
        double r = (double)color.getRed() / 255.0;
        double g = (double)color.getGreen() / 255.0;
        double b = (double)color.getBlue() / 255.0;
        double mn = ArrayMath.min(new double[]{r, g, b});
        double mx = ArrayMath.max(new double[]{r, g, b});
        double delta = mx - mn;
        double l = (mx + mn) / 2.0;
        double h = Double.NaN;
        if (delta == 0.0) {
            h = 0.0;
            s = 0.0;
        } else {
            s = l < 0.5 ? delta / (mx + mn) : delta / (2.0 - mx - mn);
            double deltaR = ((mx - r) / 6.0 + delta / 2.0) / delta;
            double deltaG = ((mx - g) / 6.0 + delta / 2.0) / delta;
            double deltaB = ((mx - b) / 6.0 + delta / 2.0) / delta;
            if (r == mx) {
                h = deltaB - deltaG;
            } else if (g == mx) {
                h = 0.3333333333333333 + deltaR - deltaB;
            } else if (b == mx) {
                h = 0.6666666666666666 + deltaG - deltaR;
            }
            if (h < 0.0) {
                h += 1.0;
            } else if (h > 1.0) {
                h -= 1.0;
            }
        }
        return new float[]{(float)h, (float)s, (float)l};
    }

    public static float[][] toHSL(Color[] colors) {
        float[][] hsl = new float[3][colors.length];
        for (int k = 0; k < colors.length; ++k) {
            hsl[k] = Colors.toHSL(colors[k]);
        }
        return hsl;
    }

    public static float[] toXYZ(Color color) {
        double var_R = (double)color.getRed() / 255.0;
        double var_G = (double)color.getGreen() / 255.0;
        double var_B = (double)color.getBlue() / 255.0;
        var_R = var_R > 0.04045 ? Math.pow((var_R + 0.055) / 1.055, 2.4) : (var_R /= 12.92);
        var_G = var_G > 0.04045 ? Math.pow((var_G + 0.055) / 1.055, 2.4) : (var_G /= 12.92);
        var_B = var_B > 0.04045 ? Math.pow((var_B + 0.055) / 1.055, 2.4) : (var_B /= 12.92);
        float X = (float)((var_R *= 100.0) * 0.4124 + (var_G *= 100.0) * 0.3576 + (var_B *= 100.0) * 0.1805);
        float Y = (float)(var_R * 0.2126 + var_G * 0.7152 + var_B * 0.0722);
        float Z = (float)(var_R * 0.0193 + var_G * 0.1192 + var_B * 0.9505);
        return new float[]{X, Y, Z};
    }

    public static float[][] toXYZ(Color[] colors) {
        float[][] xyz = new float[3][colors.length];
        for (int k = 0; k < colors.length; ++k) {
            xyz[k] = Colors.toXYZ(colors[k]);
        }
        return xyz;
    }

    public static float[] toLab(Color color) {
        float[] xyzcolor = Colors.toXYZ(color);
        double var_X = (double)xyzcolor[0] / 95.047;
        double var_Y = (double)xyzcolor[1] / 100.0;
        double var_Z = (double)xyzcolor[2] / 108.883;
        var_X = var_X > 0.008856 ? Math.pow(var_X, 0.3333333333333333) : 7.787 * var_X + 0.0;
        var_Y = var_Y > 0.008856 ? Math.pow(var_Y, 0.3333333333333333) : 7.787 * var_Y + 0.0;
        var_Z = var_Z > 0.008856 ? Math.pow(var_Z, 0.3333333333333333) : 7.787 * var_Z + 0.0;
        float CIEL = (float)(116.0 * var_Y - 16.0);
        float CIEa = (float)(500.0 * (var_X - var_Y));
        float CIEb = (float)(200.0 * (var_Y - var_Z));
        return new float[]{CIEL, CIEa, CIEb};
    }

    public static float[][] toLab(Color[] colors) {
        float[][] lab = new float[3][colors.length];
        for (int k = 0; k < colors.length; ++k) {
            lab[k] = Colors.toLab(colors[k]);
        }
        return lab;
    }

    public static float[] labToXYZ(float[] xyz) {
        double var_Y = ((double)xyz[0] + 16.0) / 116.0;
        double var_X = (double)xyz[1] / 500.0 + var_Y;
        double var_Z = var_Y - (double)xyz[2] / 200.0;
        var_Y = Math.pow(var_Y, 3.0) > 0.008856 ? Math.pow(var_Y, 3.0) : (var_Y - 0.0) / 7.787;
        var_X = Math.pow(var_X, 3.0) > 0.008856 ? Math.pow(var_X, 3.0) : (var_X - 0.0) / 7.787;
        var_Z = Math.pow(var_Z, 3.0) > 0.008856 ? Math.pow(var_Z, 3.0) : (var_Z - 0.0) / 7.787;
        float X = (float)(95.047 * var_X);
        float Y = (float)(100.0 * var_Y);
        float Z = (float)(108.883 * var_Z);
        return new float[]{X, Y, Z};
    }

    public static Color XYZToRGB(float[] xyz) {
        double var_X = xyz[0] / 100.0f;
        double var_Y = xyz[1] / 100.0f;
        double var_Z = xyz[2] / 100.0f;
        double var_R = var_X * 3.2406 + var_Y * -1.5372 + var_Z * -0.4986;
        double var_G = var_X * -0.9689 + var_Y * 1.8758 + var_Z * 0.0415;
        double var_B = var_X * 0.0557 + var_Y * -0.204 + var_Z * 1.057;
        var_R = var_R > 0.0031308 ? 1.055 * Math.pow(var_R, 0.4166666666666667) - 0.055 : 12.92 * var_R;
        var_G = var_G > 0.0031308 ? 1.055 * Math.pow(var_G, 0.4166666666666667) - 0.055 : 12.92 * var_G;
        var_B = var_B > 0.0031308 ? 1.055 * Math.pow(var_B, 0.4166666666666667) - 0.055 : 12.92 * var_B;
        float R = (float)var_R;
        float G = (float)var_G;
        float B = (float)var_B;
        return new Color(R, G, B);
    }

    public static Color labToRGB(float[] lab) {
        return Colors.XYZToRGB(Colors.labToXYZ(lab));
    }

    public static Color[] getArcSeries(Color color, int n, float theta) {
        float[] hsl = Colors.toHSL(color);
        theta /= 720.0f;
        double[] s = new double[1];
        if (n > 1) {
            s = ArrayMath.linspace(hsl[0] - theta, hsl[0] + theta, n);
        } else {
            s[0] = hsl[0] + theta;
        }
        Color[] colors = new Color[s.length];
        for (int k = 0; k < s.length; ++k) {
            colors[k] = Colors.HSLtoRGB((float)s[k], hsl[1], hsl[2]);
        }
        return colors;
    }

    public static Color getComplement(Color color) {
        float[] hsl = Colors.toHSL(color);
        float s = hsl[0] - 0.5f;
        return Colors.HSLtoRGB(s, hsl[1], hsl[2]);
    }

    public static Color[] getSplitComplements(Color color) {
        return Colors.getArcSeries(color, 2, 300.0f);
    }

    public static Color[] getTriads(Color color) {
        return Colors.getArcSeries(color, 2, 240.0f);
    }

    public static Color[] getAnalagous(Color color) {
        return Colors.getArcSeries(color, 2, 60.0f);
    }

    public static Color[] getMonochromeSeries(Color color, int n) {
        return Colors.getMonochromeSeries(color, n, 1.0);
    }

    public static Color[] getMonochromeSeries(Color color, int n, double llim) {
        float[] hsl = Colors.toHSL(color);
        double[] l = ArrayMath.linspace((double)hsl[2] + llim * (double)hsl[2], (double)hsl[2] - llim * (double)hsl[2], n);
        Color[] out = new Color[l.length];
        for (int k = 0; k < l.length; ++k) {
            out[k] = Colors.HSLtoRGB(hsl[0], hsl[1], (float)l[k]);
        }
        return out;
    }

    public static Color[] getSatSeries(Color color, int n) {
        float[] hsl = Colors.toHSL(color);
        double[] s = ArrayMath.linspace(0.0, 1.0, n);
        Color[] out = new Color[s.length];
        for (int k = 0; k < s.length; ++k) {
            out[k] = Colors.HSLtoRGB(hsl[0], (float)s[k], hsl[2]);
        }
        return out;
    }

    public static Color[] getLightnessSeries(Color color, int n) {
        float[] hsl = Colors.toHSL(color);
        double[] l = ArrayMath.linspace(0.0, 1.0, n);
        Color[] out = new Color[l.length];
        for (int k = 0; k < l.length; ++k) {
            out[k] = Colors.HSLtoRGB(hsl[0], hsl[1], (float)l[k]);
        }
        return out;
    }

    public static Color[] reverse(Color[] in) {
        Color[] out = new Color[in.length];
        int n = 0;
        for (int k = in.length - 1; k >= 0; --k) {
            out[n++] = in[k];
        }
        return out;
    }

    public static LinkedHashMap<Integer, Color> getDefaultMap() {
        return defaultMap;
    }

    public static void setDefaultMap(LinkedHashMap<Integer, Color> aDefaultMap) {
        defaultMap = aDefaultMap;
    }

    private static final class LuminanceSorter
    implements Comparator<Color> {
        private static final LuminanceSorter instance = new LuminanceSorter();

        private LuminanceSorter() {
        }

        private static LuminanceSorter getInstance() {
            return instance;
        }

        @Override
        public final int compare(Color c0, Color c1) {
            if (Colors.getLuminance(c0) > Colors.getLuminance(c1)) {
                return 1;
            }
            if (Colors.getLuminance(c0) < Colors.getLuminance(c1)) {
                return -1;
            }
            return 0;
        }
    }

    private static final class LightnessSorter
    implements Comparator<Color> {
        private static final LightnessSorter instance = new LightnessSorter();

        private LightnessSorter() {
        }

        private static LightnessSorter getInstance() {
            return instance;
        }

        @Override
        public final int compare(Color c0, Color c1) {
            if (Colors.toHSL(c0)[2] > Colors.toHSL(c1)[2]) {
                return 1;
            }
            if (Colors.toHSL(c0)[2] < Colors.toHSL(c1)[2]) {
                return -1;
            }
            return 0;
        }
    }

    private static final class SaturationSorter
    implements Comparator<Color> {
        private static SaturationSorter instance = new SaturationSorter();

        private SaturationSorter() {
        }

        private static SaturationSorter getInstance() {
            return instance;
        }

        @Override
        public final int compare(Color c0, Color c1) {
            if (Colors.toHSL(c0)[1] > Colors.toHSL(c1)[1]) {
                return 1;
            }
            if (Colors.toHSL(c0)[1] < Colors.toHSL(c1)[1]) {
                return -1;
            }
            return 0;
        }
    }

    private static final class HueSorter
    implements Comparator<Color> {
        private static final HueSorter instance = new HueSorter();

        private HueSorter() {
        }

        private static HueSorter getInstance() {
            return instance;
        }

        @Override
        public final int compare(Color c0, Color c1) {
            if (Colors.toHSL(c0)[0] > Colors.toHSL(c1)[0]) {
                return 1;
            }
            if (Colors.toHSL(c0)[0] < Colors.toHSL(c1)[0]) {
                return -1;
            }
            return 0;
        }
    }
}

