/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.actions;

import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.deploy.image.ImageSupport;
import kcl.waterloo.deploy.pde.PDEGraphics2D;
import kcl.waterloo.export.ExportFactory;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.gui.file.FileUtil;
import kcl.waterloo.gui.file.ImageFileChooser;
import kcl.waterloo.logging.CommonLogger;
import kcl.waterloo.swing.GCFrame;
import kcl.waterloo.swing.GCGridContainer;
import kcl.waterloo.xml.FileWrapper;
import kcl.waterloo.xml.GJDecoder;
import kcl.waterloo.xml.GJEncoder;

public class ActionServices {
    private ActionServices() {
        try {
            Class<?> c = Class.forName("kcl.waterloo.export.ExportFactory");
            if (c != null) {
                Singleton.exportFactoryPresent = true;
            }
        }
        catch (ClassNotFoundException ex) {
            Singleton.exportFactoryPresent = false;
        }
        Singleton.logger = new CommonLogger(ActionServices.class.getName());
    }

    public static boolean isUseChooser() {
        return Singleton.useChooser;
    }

    public static void setUseChooser(boolean aUseChooser) {
        Singleton.useChooser = aUseChooser;
    }

    public static FileWrapper open() {
        return ActionServices.open(null);
    }

    public static FileWrapper open(Component parent) {
        File file;
        if (ActionServices.isUseChooser()) {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new FileNameExtensionFilter("Waterloo graphics (.kclf)", "kclf"));
            chooser.addChoosableFileFilter(new FileNameExtensionFilter("Compressed Waterloo graphics (.kclf.gz)", "gz"));
            chooser.addChoosableFileFilter(new FileNameExtensionFilter("Waterloo MATLAB folders (.kclfig)", "kclfig"));
            chooser.addChoosableFileFilter(new FileNameExtensionFilter("All Waterloo Files", "kclf", "gz", "kclfig"));
            int val = chooser.showOpenDialog(parent);
            if (val != 0) {
                return new FileWrapper(null, null);
            }
            file = chooser.getSelectedFile();
        } else {
            parent = parent != null ? SwingUtilities.windowForComponent(parent) : null;
            Frame parent2 = parent instanceof Frame ? (Frame)SwingUtilities.windowForComponent(parent) : null;
            FileDialog chooser = new FileDialog(parent2, "Open File", 0);
            chooser.setLocationByPlatform(true);
            chooser.setFilenameFilter(new WaterlooFileOpenFilter());
            chooser.setVisible(true);
            file = new File(chooser.getDirectory(), chooser.getFile());
        }
        Singleton.logger.debug(String.format("Loading: %s", file.getPath()));
        FileWrapper fileWrapper = file.isDirectory() && file.getName().endsWith(".kclfig") ? ActionServices.getKCLFFile(file) : new FileWrapper(file, null);
        String s = fileWrapper.getFile().toString();
        Object loadedObject = GJDecoder.load(s);
        if (loadedObject instanceof LinkedHashMap) {
            LinkedHashMap map = (LinkedHashMap)loadedObject;
            Object newObj = map.get("Graphics");
            fileWrapper.setContents(newObj);
            fileWrapper.setErrorLog((ArrayList)map.get("ErrorLog"));
            Singleton.logger.debug(String.format("Loaded: %s", file.getPath()));
            return fileWrapper;
        }
        Singleton.logger.debug(String.format("Loaded: %s", file.getPath()));
        return new FileWrapper(null, null);
    }

    public static FileWrapper save(Object o) {
        return ActionServices.save(null, o);
    }

    public static FileWrapper save(Component parent, Object o) {
        File file;
        if (ActionServices.isUseChooser()) {
            JFileChooser chooser = new JFileChooser();
            int val = chooser.showSaveDialog(parent);
            if (val != 0) {
                return new FileWrapper(null, null);
            }
            file = chooser.getSelectedFile();
        } else {
            parent = parent != null ? SwingUtilities.windowForComponent(parent) : null;
            Frame parent2 = parent instanceof Frame ? (Frame)SwingUtilities.windowForComponent(parent) : null;
            FileDialog chooser = new FileDialog(parent2, "Save File", 1);
            chooser.setFilenameFilter(new WaterlooFileSaveFilter());
            chooser.setLocationByPlatform(true);
            chooser.setVisible(true);
            file = new File(chooser.getDirectory(), chooser.getFile());
        }
        Singleton.logger.debug(String.format("Saving: %s", file.getPath()));
        GJEncoder.save(file.getPath(), o);
        Singleton.logger.debug(String.format("Saved: %s", file.getPath()));
        return new FileWrapper(null, null);
    }

    public static void deployAs(Component c2) {
        ActionServices.deployAs(null, c2);
    }

    public static void deployAs(Component parent, final Component c2) {
        String folder;
        File file;
        if (ActionServices.isUseChooser()) {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new FileNameExtensionFilter("ProcessingJS (.pde)", "pde"));
            chooser.addChoosableFileFilter(new FileNameExtensionFilter("Scalable Vector Graphics (.svg)", "svg"));
            int val = chooser.showSaveDialog(parent);
            if (val != 0) {
                return;
            }
            file = chooser.getSelectedFile();
            folder = chooser.getCurrentDirectory().getPath();
        } else {
            parent = parent != null ? SwingUtilities.windowForComponent(parent) : null;
            Frame parent2 = parent instanceof Frame ? (Frame)SwingUtilities.windowForComponent(parent) : null;
            FileDialog chooser = new FileDialog(parent2, "Deploy to Web", 1);
            chooser.setFilenameFilter(new WaterlooDeployFilter());
            chooser.setLocationByPlatform(true);
            chooser.setVisible(true);
            file = new File(chooser.getDirectory(), chooser.getFile());
            folder = chooser.getDirectory();
        }
        String filename = file.getName();
        if (!filename.endsWith(".svg") && !filename.endsWith(".pde")) {
            filename = filename.concat(".").concat((String)GJDefaults.getMap2().get("DeployMode"));
        }
        String ext = ActionServices.getExtension(filename);
        final File file2 = new File(folder, filename);
        final String folder2 = file2.getPath().replace(".".concat(ActionServices.getExtension(file2.getPath())), "");
        if (ext.equals("pde")) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PDEGraphics2D g2 = PDEGraphics2D.paint(c2);
                    String jsLoc = (String)GJDefaults.getMap().get("Processing.jsLocation");
                    String cssLoc = (String)GJDefaults.getMap().get("Processing.cssLocation");
                    boolean httpd = (Boolean)GJDefaults.getMap().get("Processing.httpd");
                    try {
                        g2.write(file2.getPath(), true, jsLoc, cssLoc, httpd);
                        Singleton.logger.debug(String.format("PDE file saved to folder: %s", folder2));
                    }
                    catch (IOException ex) {
                        Singleton.logger.warn("IOException: " + ex.getMessage());
                    }
                }
            });
        } else if (Singleton.exportFactoryPresent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExportFactory.deploySVG(c2, file2, c2.getSize(), false, (String)GJDefaults.getMap().get("SVG.cssLocation"), (Boolean)GJDefaults.getMap().get("SVG.httpd"), new ArrayList<String>(), "", "");
                        Singleton.logger.debug(String.format("SVG file saved to folder: %s", folder2));
                    }
                    catch (IOException ex) {
                        Singleton.logger.warn("IOException: " + ex.getMessage());
                    }
                }
            });
        }
    }

    public static void saveAs(Component c) {
        ActionServices.saveAs(null, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAs(Component parent, Component c) {
        if (c instanceof GJGraphInterface && ((GJGraphInterface)((Object)c)).getGraphContainer() != null) {
            c = ((GJGraphInterface)((Object)c)).getGraphContainer();
        }
        boolean opaqueFlag = c.isOpaque();
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(true);
        }
        File file = null;
        try {
            if (ActionServices.isUseChooser()) {
                int val = ImageFileChooser.createSaveDialog(parent, "");
                switch (val) {
                    case 0: {
                        return;
                    }
                }
                ImageFileChooser fc = ImageFileChooser.getInstance();
                file = fc.getSelectedFile();
            } else {
                parent = parent != null ? SwingUtilities.windowForComponent(parent) : null;
                Frame parent2 = parent instanceof Frame ? (Frame)SwingUtilities.windowForComponent(parent) : null;
                FileDialog chooser = new FileDialog(parent2, "Deploy to Web", 1);
                chooser.setLocationByPlatform(true);
                chooser.setVisible(true);
                file = new File(chooser.getDirectory(), chooser.getFile());
            }
            c = ActionServices.getCopyOrSaveTarget(c);
            String ext = FileUtil.getExtension(file);
            Singleton.logger.debug(String.format("Saving: %s", file.getPath()));
            if (Singleton.exportFactoryPresent && ext.equals("pdf")) {
                ExportFactory.saveAsPDF(c, file);
            } else if (ext.equals("eps")) {
                ExportFactory.saveAsEPS(c, file);
            } else if (Singleton.exportFactoryPresent && ext.equals("svg")) {
                ExportFactory.saveAsSVG(c, file);
            } else if (Singleton.exportFactoryPresent && ext.equals("gz")) {
                ExportFactory.saveAsCompressedSVG(c, file);
            } else if (ext.equals("pde")) {
                PDEGraphics2D g2 = new PDEGraphics2D((Graphics2D)c.getGraphics(), c.getSize());
                c.paint(g2);
                g2.write(file.getPath(), false, "");
            } else {
                BufferedImage buffer = c.getGraphicsConfiguration().createCompatibleImage(c.getWidth(), c.getHeight());
                Graphics2D g2 = (Graphics2D)buffer.getGraphics();
                c.paint(g2);
                if (ext.isEmpty()) {
                    ext = "png";
                    file = new File(file.getPath().concat(".png"));
                }
                ImageIO.write((RenderedImage)buffer, ext, file);
            }
            Singleton.logger.debug(String.format("Saved: %s", file.getPath()));
        }
        catch (IOException ex) {
            if (file != null) {
                Singleton.logger.warn(String.format("IOException saving file: %s", file.getPath()));
            } else {
                Singleton.logger.warn(String.format("IOException saving file", new Object[0]));
            }
        }
        finally {
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(opaqueFlag);
            }
        }
    }

    public static void copy(GJBasicPanel panel) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        GJBasicPanel.LocalTransferable t = panel.getTransferable();
        clipboard.setContents(t, t);
    }

    public static SwingWorker<Boolean, Void> copyGraphics(final GJBasicPanel panel) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                try {
                    SecurityManager manager = System.getSecurityManager();
                    if (manager != null) {
                        manager.checkPermission(new AWTPermission("accessClipboard"));
                    }
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    GJBasicPanel panel2 = (GJBasicPanel)ActionServices.getCopyOrSaveTarget(panel);
                    GJBasicPanel.LocalTransferable t = panel2.getTransferable();
                    try {
                        clipboard.setContents(t, t);
                    }
                    catch (Exception ex) {
                        Singleton.logger.warn(ex.getMessage());
                    }
                    return Boolean.TRUE;
                }
                catch (SecurityException ex) {
                    Singleton.logger.warn("SecurityException: Clipboard access is not available");
                    return Boolean.FALSE;
                }
            }
        };
        worker.execute();
        return worker;
    }

    public static void copyAsImage(GJBasicPanel panel) {
        try {
            SecurityManager manager = System.getSecurityManager();
            if (manager != null) {
                manager.checkPermission(new AWTPermission("accessClipboard"));
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            panel = (GJBasicPanel)ActionServices.getCopyOrSaveTarget(panel);
            GJBasicPanel.LocalTransferable t = panel.getTransferable(false);
            clipboard.setContents(t, t);
        }
        catch (SecurityException ex) {
            Singleton.logger.warn("SecurityException: Clipboard access is not available");
        }
    }

    public static Component getCopyOrSaveTarget(Component c) {
        if (c instanceof GCFrame) {
            c = (Container)((Object)((GCFrame)c).getGraphicsContainer());
        } else if (c instanceof GCGridContainer) {
            c = ((GCGridContainer)c).getGrid();
        } else if (c instanceof GJGraphInterface && ((GJGraphInterface)((Object)c)).getGraphContainer() != null) {
            c = ((GJGraphInterface)((Object)c)).getGraphContainer();
        }
        return c;
    }

    public static void editDefaults() {
        GJDefaults.editDefaults();
    }

    private static FileWrapper getKCLFFile(File file) {
        File[] f = file.listFiles();
        File graphicsFile = null;
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (File f1 : f) {
            if (graphicsFile == null && f1.getName().endsWith(".kclf") || f1.getName().endsWith(".kclf.gz")) {
                graphicsFile = f1;
            }
            if (!ImageSupport.isImageFormatSupported(f1)) continue;
            imageFiles.add(f1);
        }
        return new FileWrapper(graphicsFile, null, imageFiles);
    }

    public static boolean isExportFactoryPresent() {
        return Singleton.exportFactoryPresent;
    }

    public static String getExtension(String s) {
        if (s.contains(".")) {
            int idx = s.lastIndexOf(".");
            return s.substring(idx + 1);
        }
        return "";
    }

    private static class WaterlooFileSaveFilter
    implements FilenameFilter {
        private WaterlooFileSaveFilter() {
        }

        @Override
        public boolean accept(File f, String s) {
            String extension = ActionServices.getExtension(s);
            if (extension != null) {
                return extension.equals("kclf") || extension.equals("gz");
            }
            return false;
        }
    }

    private static class WaterlooDeployFilter
    implements FilenameFilter {
        private WaterlooDeployFilter() {
        }

        @Override
        public boolean accept(File f, String s) {
            String extension = ActionServices.getExtension(s);
            if (extension != null) {
                return extension.equals("pde") || extension.equals("svg");
            }
            return false;
        }
    }

    private static class JWaterlooFileOpenFilter
    extends FileFilter {
        private JWaterlooFileOpenFilter() {
        }

        @Override
        public boolean accept(File s) {
            String extension = FileUtil.getExtension(s);
            if (extension != null) {
                return extension.equals("kclf") || extension.equals("gz") || extension.equals("kclfig");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "All Waterloo Files";
        }
    }

    private static class WaterlooFileOpenFilter
    implements FilenameFilter {
        private WaterlooFileOpenFilter() {
        }

        @Override
        public boolean accept(File f, String s) {
            String extension = ActionServices.getExtension(s);
            if (extension != null) {
                return extension.equals("kclf") || extension.equals("gz") || extension.equals("kclfig");
            }
            return false;
        }
    }

    private static class Singleton {
        private static final ActionServices instance = new ActionServices();
        private static boolean exportFactoryPresent;
        private static boolean useChooser;
        private static CommonLogger logger;

        private Singleton() {
        }

        static {
            useChooser = true;
        }
    }
}

