/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.norm;

import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.data.norm.Normalizer;

public class MaxNormalizer
implements Normalizer {
    double[] maxIn;
    double[] maxOut;

    @Override
    public void normalize(DataSet dataSet) {
        this.findMaxVectors(dataSet);
        for (DataSetRow row : dataSet.getRows()) {
            double[] normalizedInput = this.normalizeMax(row.getInput(), this.maxIn);
            row.setInput(normalizedInput);
            if (!dataSet.isSupervised()) continue;
            double[] normalizedOutput = this.normalizeMax(row.getDesiredOutput(), this.maxOut);
            row.setDesiredOutput(normalizedOutput);
        }
    }

    private void findMaxVectors(DataSet dataSet) {
        int i;
        int inputSize = dataSet.getInputSize();
        int outputSize = dataSet.getOutputSize();
        this.maxIn = new double[inputSize];
        for (i = 0; i < inputSize; ++i) {
            this.maxIn[i] = Double.MIN_VALUE;
        }
        this.maxOut = new double[outputSize];
        for (i = 0; i < outputSize; ++i) {
            this.maxOut[i] = Double.MIN_VALUE;
        }
        for (DataSetRow dataSetRow : dataSet.getRows()) {
            double[] input = dataSetRow.getInput();
            for (int i2 = 0; i2 < inputSize; ++i2) {
                if (!(input[i2] > this.maxIn[i2])) continue;
                this.maxIn[i2] = input[i2];
            }
            double[] output = dataSetRow.getDesiredOutput();
            for (int i3 = 0; i3 < outputSize; ++i3) {
                if (!(output[i3] > this.maxOut[i3])) continue;
                this.maxOut[i3] = output[i3];
            }
        }
    }

    public double[] normalizeMax(double[] vector, double[] max) {
        double[] normalizedVector = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            normalizedVector[i] = vector[i] / max[i];
        }
        return normalizedVector;
    }
}

