/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.benchmark;

import java.util.ArrayList;
import org.neuroph.util.benchmark.BenchmarkTask;
import org.neuroph.util.benchmark.BenchmarkTaskResults;
import org.neuroph.util.benchmark.Stopwatch;

public class Benchmark {
    ArrayList<BenchmarkTask> tasks = new ArrayList();

    public void addTask(BenchmarkTask task) {
        this.tasks.add(task);
    }

    public static void runTask(BenchmarkTask task) {
        System.out.println("Preparing task " + task.getName());
        task.prepareTest();
        System.out.println("Warming up " + task.getName());
        for (int i = 0; i < task.getWarmupIterations(); ++i) {
            task.runTest();
        }
        System.out.println("Runing " + task.getName());
        Stopwatch timer = new Stopwatch();
        BenchmarkTaskResults results = new BenchmarkTaskResults(task.getTestIterations());
        for (int i = 0; i < task.getTestIterations(); ++i) {
            timer.reset();
            timer.start();
            task.runTest();
            timer.stop();
            results.addElapsedTime(timer.getElapsedTime());
        }
        results.calculateStatistics();
        System.out.println(task.getName() + " results");
        System.out.println(results);
    }

    public void run() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            Benchmark.runTask(this.tasks.get(i));
        }
    }
}

