/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;

public class TrainingSetImport {
    public static DataSet importFromFile(String filePath, int inputsCount, int outputsCount, String separator) throws IOException, FileNotFoundException, NumberFormatException {
        InputStreamReader fileReader = null;
        try {
            DataSet trainingSet = new DataSet(inputsCount, outputsCount);
            fileReader = new FileReader(new File(filePath));
            BufferedReader reader = new BufferedReader(fileReader);
            String line = "";
            while ((line = reader.readLine()) != null) {
                int i;
                double[] inputs = new double[inputsCount];
                double[] outputs = new double[outputsCount];
                String[] values = line.split(separator);
                if (values[0].equals("")) continue;
                for (i = 0; i < inputsCount; ++i) {
                    inputs[i] = Double.parseDouble(values[i]);
                }
                for (i = 0; i < outputsCount; ++i) {
                    outputs[i] = Double.parseDouble(values[inputsCount + i]);
                }
                if (outputsCount > 0) {
                    trainingSet.addRow(new DataSetRow(inputs, outputs));
                    continue;
                }
                trainingSet.addRow(new DataSetRow(inputs));
            }
            return trainingSet;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (IOException ex) {
            if (fileReader != null) {
                fileReader.close();
            }
            ex.printStackTrace();
            throw ex;
        }
        catch (NumberFormatException ex) {
            fileReader.close();
            ex.printStackTrace();
            throw ex;
        }
    }
}

